/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp.rules;

import com.ahsrcm.corp.BatchType;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.User;
import com.ahsrcm.corp.cdl.CDLEntity;
import com.ahsrcm.corp.rules.Rule;
import com.ahsrcm.corp.rules.RuleOverride;
import com.ahsrcm.corp.rules.RuleSet;
import com.ahsrcm.corp.rules.Stage;
import com.ahsrcm.corp.rules.UserRole;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.java.dev.properties.container.PropertyContextable;
import net.java.dev.properties.util.BeanComparator;
import net.model3.collections.ListX;
import net.model3.collections.MapX;
import net.model3.collections.SetX;

public class RuleManager
implements Serializable {
    private static final long serialVersionUID = 6243891861838177244L;
    private RuleSet _ruleSet;
    private CDLEntity _cdlEntity;
    private List<RuleOverride> _overrides;
    private List<User> _users;
    private List<Rule> _rules;
    private ScanBatch _scanBatch;
    private transient Map<Stage, RuleOverride> _overridesByStage;
    BatchType _batchType;

    public RuleManager() {
    }

    public RuleManager(CDLEntity cDLEntity, BatchType batchType) {
        this._cdlEntity = cDLEntity;
        this._ruleSet = RuleSet.fetch(cDLEntity, batchType);
        this._rules = ListX.create(this._ruleSet.rules);
        this._batchType = batchType;
        this.loadRuleOverrides();
        this._users = User.getUsers(this._cdlEntity);
    }

    public RuleManager(ScanBatch scanBatch) {
        this(scanBatch.getCDLEntity(), (BatchType)scanBatch.batchType.get());
        this._scanBatch = scanBatch;
    }

    public void setScanBatch(ScanBatch scanBatch) {
        this._scanBatch = scanBatch;
    }

    final void loadRuleOverrides() {
        this._overrides = ListX.create();
        for (RuleOverride ruleOverride : RuleOverride.selectAll()) {
            if (!((BatchType)ruleOverride.batchType.get()).equals(this._ruleSet.batchType.get()) || !((CDLEntity)ruleOverride.cdlEntity.get()).isAuthorizationMatch(this._cdlEntity, false)) continue;
            this._overrides.add(ruleOverride);
        }
        BeanComparator beanComparator = BeanComparator.create((PropertyContextable[])new PropertyContextable[]{RuleOverride.$companyId, RuleOverride.$divisionId, RuleOverride.$locationId});
        Collections.sort(this._overrides, beanComparator);
    }

    public User getDefaultUser(Rule rule) {
        return this.getDefaultUser((Stage)rule.stage.get());
    }

    public List<User> getUsers() {
        return this._users;
    }

    public Set<User> getUsersWithRole(List<UserRole> list) {
        Set set = SetX.create();
        block0: for (User user : this._users) {
            for (UserRole userRole : list) {
                if (!user.roles.contains((Object)userRole)) continue;
                set.add(user);
                continue block0;
            }
        }
        return set;
    }

    public Set<User> getPossibleUsers(Stage stage) {
        if (stage == null) {
            return SetX.emptySet();
        }
        Set<User> set = this.getUsersWithRole(stage.getAllowedRoles());
        if (this._scanBatch != null && stage.equals(Stage.ReworkOut.get())) {
            set.add((User)this._scanBatch.creationUser.get());
        }
        return set;
    }

    public Map<Stage, RuleOverride> getOverridesByStage() {
        if (this._overridesByStage == null) {
            this._overridesByStage = MapX.create();
            for (RuleOverride ruleOverride : this._overrides) {
                this._overridesByStage.put((Stage)ruleOverride.stage.get(), ruleOverride);
            }
        }
        return this._overridesByStage;
    }

    public User getDefaultUser(Stage stage) {
        RuleOverride ruleOverride = this.getOverridesByStage().get(stage);
        if (ruleOverride != null) {
            return (User)ruleOverride.defaultUser.get();
        }
        if (this._scanBatch != null) {
            Set<User> set = this.getPossibleUsers(stage);
            if (set.size() == 1) {
                return set.iterator().next();
            }
            Set set2 = SetX.create((Object[])new UserRole[]{UserRole.CodingManager.get(), UserRole.DataEntryManager.get()});
            User user = null;
            for (User user2 : set) {
                Set set3 = SetX.create(user2.roles);
                if (!SetX.intersection((Collection)set2, (Collection)set3).isEmpty()) continue;
                if (user == null) {
                    user = user2;
                    continue;
                }
                user = null;
                break;
            }
            return user;
        }
        return null;
    }

    public Rule getRule(Stage stage) {
        return this._ruleSet.rulesByStage.get(stage);
    }

    public Rule getNextRequiredRule(Stage stage) {
        return this._ruleSet.rulesByStage.get(stage).nextRequiredRule();
    }

    public RuleSet getRuleSet() {
        return this._ruleSet;
    }

    public List<Rule> getRules() {
        return this._rules;
    }
}

