/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp.orm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.jdbc.handlers.SingleColumnHandler;
import net.model3.lang.StringX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;

public class ISeriesStringHandler
extends SingleColumnHandler<String> {
    private static final Log logger = LogHelper.getLog();
    private Integer _length = null;

    public void activated() {
        super.activated();
        this.getLength();
    }

    public Integer getSqlTypeAsInteger() {
        return 12;
    }

    public boolean canHandleType(Class<?> clazz) {
        return clazz.equals(String.class);
    }

    Integer getLength() {
        if (this.getPropertyContext() != null && this._length == null) {
            if (this.getColumn().getLength() != null) {
                this._length = this.getColumn().getLength().intValue();
            }
            if (this._length == null) {
                logger.warn((Object)"no lengthconstraint on {}.{}", (Object)this.getParentBeanContext().getType().getName(), (Object)this.getPropertyContext().getName());
                this._length = Integer.MAX_VALUE;
            }
        }
        return this._length;
    }

    protected boolean autoHandleNulls() {
        return false;
    }

    public void mapColumnValueToPreparedStatement(String string, PreparedStatement preparedStatement, int n) throws SQLException {
        if (string == null) {
            string = "";
        }
        this.getLength();
        if (this._length != null && string.length() > this.getLength()) {
            logger.warn((Object)"truncating property {} from '{}' to length {}", (Object)this.getPropertyContext().getQualifiedName(), (Object)string, (Object)this.getLength());
            string = string.substring(0, this.getLength());
        }
        preparedStatement.setString(n, string);
    }

    public Object getColumnValue(Object object, int n) {
        String string = (String)super.getColumnValue(object, n);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void loadProperty(WProperty<String> wProperty, ResultSet resultSet, int n) throws SQLException {
        String string = resultSet.getString(n);
        string = string != null ? StringX.trimRight((String)string) : "";
        wProperty.set((Object)string);
    }
}

