/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp.orm;

import com.ahsrcm.corp.AuthNetAuthentication;
import com.ahsrcm.corp.Location;
import com.ahsrcm.corp.rules.Rule;
import com.ahsrcm.corp.rules.RuleSet;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Calendar;
import net.java.dev.properties.jdbc.NullForeignKeyChecker;
import net.model3.lang.StringX;
import net.model3.util.BigDecimalX;

@Singleton
public class ISeriesNullForeignKeyChecker
extends NullForeignKeyChecker {
    public boolean isNull(Class<?> clazz, Object[] objectArray) {
        if (clazz.equals(RuleSet.class) || clazz.equals(Rule.class) || clazz.equals(AuthNetAuthentication.class) || clazz.equals(Location.class)) {
            return false;
        }
        if (objectArray == null) {
            return true;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            boolean bl = this.isValueNull(objectArray[i]);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    boolean isValueNull(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return StringX.isBlank((String)((String)object));
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() == 0.0;
        }
        return false;
    }

    public Object getNullValue(Class<?> clazz) {
        if (clazz.equals(String.class)) {
            return "";
        }
        if (clazz.equals(Integer.class)) {
            return 0;
        }
        if (clazz.equals(Long.class)) {
            return 0;
        }
        if (clazz.equals(BigDecimal.class)) {
            return BigDecimalX.ZERO;
        }
        if (clazz.equals(BigInteger.class)) {
            return new BigInteger("0");
        }
        if (clazz.equals(Date.class)) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, 1);
            calendar.set(2, 1);
            calendar.set(5, 1);
            return new Date(calendar.getTimeInMillis());
        }
        throw new RuntimeException("don't know how to handle " + clazz.getName());
    }
}

