/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp.orm;

import com.ahsrcm.corp.orm.ClientSideSession;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import net.java.dev.properties.jdbc.Session;
import net.java.dev.properties.jdbc.SessionContextStrategy;
import net.model3.lang.Function1;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

@Singleton
public class ClientSideSessionContext
implements SessionContextStrategy {
    Logger logger = LoggerHelper.getLogger();
    Session _session;
    ThreadLocal<Session> _threadLocalSessions = new ThreadLocal();
    @Inject
    Injector _injector;

    @Inject
    private ClientSideSessionContext() {
    }

    public void close(Session session) {
        if (this.getSessionForThread() == session) {
            this.setSessionForThread(null);
        }
        if (this._session == session) {
            this._session = null;
        }
    }

    public Session getSessionForThread() {
        Session session = this._threadLocalSessions.get();
        if (session == null) {
            session = this._session;
        }
        return session;
    }

    public void setSessionForThread(Session session) {
        if (session == null) {
            this._threadLocalSessions.remove();
        } else {
            this._threadLocalSessions.set(session);
        }
    }

    public Session newSessionForThread() {
        Session session = this.newSession();
        this.setSessionForThread(session);
        return session;
    }

    public Session newSession() {
        Session session = (Session)this._injector.getInstance(ClientSideSession.class);
        this.logger.debug((Object)("created session " + session));
        return session;
    }

    public Session currentSession(boolean bl) {
        Session session = this.getSessionForThread();
        if (session == null && bl) {
            this._session = (Session)this._injector.getInstance(ClientSideSession.class);
        }
        return this._session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withSession(Function1<Session, T> function1) {
        Session session = this._threadLocalSessions.get();
        try {
            Session session2 = this.newSession();
            this.setSessionForThread(session2);
            Object object = function1.apply((Object)session2);
            return (T)object;
        }
        finally {
            this.setSessionForThread(session);
        }
    }
}

