/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp.dto;

import com.ahsrcm.corp.dto.CompanyCPTCodes;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.ahsrcm.util.guice.Directories;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.model3.lang.StopWatch;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.newfile.File;
import net.model3.util.DateX;

@Singleton
public class CompanyCPTCodesFactory {
    private static final Log logger = LogHelper.getLog();
    @Inject
    Directories _directories;
    @Inject
    ScanningDao _scanningDao;
    CompanyCPTCodes _mostRecentCompanyCptCodes;

    @Inject
    private CompanyCPTCodesFactory() {
    }

    DateX getLastUpdateFromFile(File file) {
        if (file.exists()) {
            try {
                long l = Long.parseLong((String)file.readLines().get(0));
                return new DateX(l);
            }
            catch (Exception exception) {
                logger.error((Object)"error trying to load {}", (Object)file.getCanonicalPath(), (Object)exception);
            }
        }
        return null;
    }

    public DateX getLastUpdateInCache(String string) {
        File file = this._directories.companyCpt().file(string + ".timestamp");
        return this.getLastUpdateFromFile(file);
    }

    public CompanyCPTCodes loadFromCache(String string) {
        StopWatch stopWatch = new StopWatch();
        File file = this._directories.companyCpt().file(string);
        File file2 = this._directories.companyCpt().file(string + ".timestamp");
        if (file.exists()) {
            try {
                CompanyCPTCodes companyCPTCodes = this.fromCompressedByteArray(file.readBytes());
                logger.debug((Object)"loaded company cpt codes {} from cache in {}", (Object)string, (Object)stopWatch.stop());
                return companyCPTCodes;
            }
            catch (Exception exception) {
                logger.debug((Object)"error loading cache file {} will delete the file", (Object)file, (Object)exception);
            }
        }
        if (file.exists()) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                logger.error((Object)exception);
            }
        }
        if (file2.exists()) {
            try {
                file2.delete();
            }
            catch (Exception exception) {
                logger.error((Object)exception);
            }
        }
        return null;
    }

    public void saveToCache(CompanyCPTCodes companyCPTCodes) {
        companyCPTCodes.setCreation(new DateX());
        String string = companyCPTCodes.getCompanyCode();
        File file = this._directories.companyCpt().file(companyCPTCodes.getCompanyCode());
        File file2 = this._directories.companyCpt().file(string + ".timestamp");
        if (file.exists()) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                logger.error((Object)exception);
            }
        }
        if (file2.exists()) {
            try {
                file2.delete();
            }
            catch (Exception exception) {
                logger.error((Object)exception);
            }
        }
        DateX dateX = companyCPTCodes.getLastUpdate();
        file2.write(dateX.getTimeInMillis() + "\n" + dateX.toString());
        file.write(this.toCompressedByteArray(companyCPTCodes));
    }

    public CompanyCPTCodes load(String string) {
        if (this._mostRecentCompanyCptCodes != null && this._mostRecentCompanyCptCodes.getCompanyCode().equals(string)) {
            return this._mostRecentCompanyCptCodes;
        }
        DateX dateX = this.getLastUpdateInCache(string);
        boolean bl = false;
        CompanyCPTCodes companyCPTCodes = null;
        companyCPTCodes = this._scanningDao.getCPTCodesForCompany(string, dateX);
        if (companyCPTCodes == null) {
            companyCPTCodes = this.loadFromCache(string);
            if (companyCPTCodes == null) {
                companyCPTCodes = this._scanningDao.getCPTCodesForCompany(string, null);
            } else {
                bl = true;
            }
        }
        if (!bl) {
            this.saveToCache(companyCPTCodes);
        }
        this._mostRecentCompanyCptCodes = companyCPTCodes;
        return companyCPTCodes;
    }

    public byte[] toCompressedByteArray(String string) {
        return this.toCompressedByteArray(this.load(string));
    }

    public byte[] toCompressedByteArray(CompanyCPTCodes companyCPTCodes) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            ZipEntry zipEntry = new ZipEntry("CompanyCPTCodes");
            zipOutputStream.putNextEntry(zipEntry);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(zipOutputStream);
            objectOutputStream.writeObject(companyCPTCodes);
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public CompanyCPTCodes fromCompressedByteArray(byte[] byArray) {
        try {
            logger.debug((Object)"de-serializing cpt code byte stream");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ZipInputStream zipInputStream = new ZipInputStream(byteArrayInputStream);
            zipInputStream.getNextEntry();
            ObjectInputStream objectInputStream = new ObjectInputStream(zipInputStream);
            CompanyCPTCodes companyCPTCodes = (CompanyCPTCodes)objectInputStream.readObject();
            objectInputStream.close();
            return companyCPTCodes;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

