/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp.dto;

import com.ahsrcm.corp.dto.CompanyCPTCodes;
import com.ahsrcm.corp.dto.CptDiagnosis;
import com.ahsrcm.corp.dto.CptModifier;
import com.ahsrcm.corp.dto.CptProcedure;
import com.google.inject.Singleton;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import net.java.dev.properties.jdbc.SelectQuery;
import net.model3.lang.StopWatch;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.util.DateX;

@Singleton
public class CompanyCPTCodesDBLoader {
    private static final Log logger = LogHelper.getLog();

    public DateX getLastUpdate(String string) {
        DateX dateX = this.getMaxLastUpdate("ESPPRO", "EP", string);
        DateX dateX2 = this.getMaxLastUpdate("ESPMOD", "EN", string);
        DateX dateX3 = this.getMaxLastUpdate("ESPDIANEW", "EO", string);
        DateX dateX4 = this.getMaxLastUpdate("ESPPROXW", "EQ", string);
        DateX dateX5 = DateX.getMostRecent((DateX[])new DateX[]{dateX, dateX2, dateX3, dateX4});
        return dateX5;
    }

    public CompanyCPTCodes loadCompanyCPTCodesFromDB(String string) {
        StopWatch stopWatch = new StopWatch();
        final CompanyCPTCodes companyCPTCodes = new CompanyCPTCodes();
        companyCPTCodes.setCompanyCode(string);
        ParameterizedRowMapper<CptProcedure> parameterizedRowMapper = new ParameterizedRowMapper<CptProcedure>(){

            @Override
            public CptProcedure mapRow(ResultSet resultSet, int n) throws SQLException {
                CptProcedure cptProcedure = new CptProcedure();
                cptProcedure.setCode(resultSet.getString(1));
                cptProcedure.setDescription(resultSet.getString(2));
                cptProcedure.setGender(resultSet.getString(3));
                cptProcedure.setTimesPerformed(resultSet.getInt(4));
                cptProcedure.setTypeOfService(resultSet.getString(5));
                return cptProcedure;
            }
        };
        ParameterizedRowMapper<CptDiagnosis> parameterizedRowMapper2 = new ParameterizedRowMapper<CptDiagnosis>(){

            @Override
            public CptDiagnosis mapRow(ResultSet resultSet, int n) throws SQLException {
                CptDiagnosis cptDiagnosis = new CptDiagnosis();
                cptDiagnosis.setCode(resultSet.getString(1));
                cptDiagnosis.setDescription(resultSet.getString(2));
                cptDiagnosis.setGender(resultSet.getString(3));
                cptDiagnosis.setIcd9(resultSet.getString(4).toUpperCase().equals("Y"));
                return cptDiagnosis;
            }
        };
        ParameterizedRowMapper<CptModifier> parameterizedRowMapper3 = new ParameterizedRowMapper<CptModifier>(){

            @Override
            public CptModifier mapRow(ResultSet resultSet, int n) throws SQLException {
                CptModifier cptModifier = new CptModifier();
                cptModifier.setCode(resultSet.getString(1));
                cptModifier.setDescription(resultSet.getString(2));
                return cptModifier;
            }
        };
        companyCPTCodes.setProcedures(this.loadCodesFromDB("ESPPRO", "EPCMP", "EPPRO, EPD40, EPSEX, EPTPF, EPTOS", string, parameterizedRowMapper));
        companyCPTCodes.setModifiers(this.loadCodesFromDB("ESPMOD", "ENCMP", "ENMOD, END30", string, parameterizedRowMapper3));
        companyCPTCodes.setDiagnosis(this.loadCodesFromDB("ESPDIANEW", "EOCMP", "EODIA, EOD40, EOSEX, EOICD9FLG", string, parameterizedRowMapper2));
        new SelectQuery<Object>("select EQASA, EQPRO, EQTPF, EQEFFD, EQEXPD from ESPPROXW where EQCMP = ?", null, new Object[]{string}){

            protected Object processRow(ResultSet resultSet) throws SQLException {
                CptProcedure cptProcedure = companyCPTCodes.lookupProcedure(resultSet.getString(1));
                CptProcedure cptProcedure2 = companyCPTCodes.lookupProcedure(resultSet.getString(2));
                int n = resultSet.getInt(3);
                java.sql.Date date = CompanyCPTCodesDBLoader.fixSqlDate(resultSet.getDate(4));
                java.sql.Date date2 = CompanyCPTCodesDBLoader.fixSqlDate(resultSet.getDate(5));
                if (cptProcedure2 != null && cptProcedure != null) {
                    cptProcedure2.addAsaProcedure(cptProcedure, n, date, date2);
                }
                return null;
            }
        }.getResults();
        logger.debug((Object)"loaded cpt codes from db for company {} in {}", (Object)string, (Object)stopWatch.stop());
        return companyCPTCodes;
    }

    static java.sql.Date fixSqlDate(java.sql.Date date) {
        int n = date.getYear();
        int n2 = date.getMonth();
        int n3 = date.getDate();
        if (n == 40 && n3 == 1 && n2 == 0) {
            return new java.sql.Date(2040, 1, 1);
        }
        return date;
    }

    private <T> List<T> loadCodesFromDB(String string, String string2, String string3, String string4, final ParameterizedRowMapper<T> parameterizedRowMapper) {
        String string5 = "select " + string3 + " from " + string + " where " + string2 + " = ?";
        StopWatch stopWatch = new StopWatch();
        List list = new SelectQuery<T>(string5, null, new Object[]{string4}){

            protected T processRow(ResultSet resultSet) throws SQLException {
                return parameterizedRowMapper.mapRow(resultSet, -1);
            }
        }.getResults();
        logger.debug(new Object[]{"loaded company={} table={} record count={} in {}", string4, string, list.size(), stopWatch.stop()});
        return list;
    }

    DateX getMaxLastUpdate(String string, String string2, String string3) {
        String string4 = string2 + "CMP";
        String string5 = string2 + "DATL";
        String string6 = string2 + "TIML";
        String string7 = "select max(timestamp(" + string5 + "," + string6 + ")) from " + string + " where " + string4 + " = ?";
        return (DateX)new SelectQuery<DateX>(string7, null, new Object[]{string3}){

            protected DateX processRow(ResultSet resultSet) throws SQLException {
                Timestamp timestamp = resultSet.getTimestamp(1);
                return new DateX((Date)timestamp);
            }
        }.getResult();
    }

    static interface ParameterizedRowMapper<T> {
        public T mapRow(ResultSet var1, int var2) throws SQLException;
    }
}

