/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp.dto;

import com.ahsrcm.corp.dto.CptCode;
import com.ahsrcm.corp.dto.CptDiagnosis;
import com.ahsrcm.corp.dto.CptModifier;
import com.ahsrcm.corp.dto.CptProcedure;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.model3.util.DateX;

public class CompanyCPTCodes
implements Serializable {
    private static final long serialVersionUID = -6661146905156295657L;
    private DateX _lastUpdate;
    private DateX _creation;
    private String _companyCode;
    private List<CptProcedure> _procedures;
    private List<CptModifier> _modifiers;
    private List<CptDiagnosis> _diagnosis;
    private transient Map<String, CptProcedure> _proceduresMap;

    public Map<String, CptProcedure> getProceduresMap() {
        if (this._proceduresMap == null) {
            HashMap<String, CptProcedure> hashMap = new HashMap<String, CptProcedure>();
            for (CptProcedure cptProcedure : this.getProcedures()) {
                hashMap.put(cptProcedure.getCode(), cptProcedure);
            }
            this._proceduresMap = hashMap;
        }
        return this._proceduresMap;
    }

    public String getCompanyCode() {
        return this._companyCode;
    }

    public void setCompanyCode(String string) {
        this._companyCode = string;
    }

    public List<CptDiagnosis> getDiagnosis() {
        if (this._diagnosis == null) {
            this._diagnosis = new ArrayList<CptDiagnosis>();
        }
        return this._diagnosis;
    }

    public List<CptModifier> getModifiers() {
        if (this._modifiers == null) {
            this._modifiers = new ArrayList<CptModifier>();
        }
        return this._modifiers;
    }

    public List<CptProcedure> getProcedures() {
        if (this._procedures == null) {
            this._procedures = new ArrayList<CptProcedure>();
        }
        return this._procedures;
    }

    public <T extends CptCode> T lookup(Class<T> clazz, String string) {
        if (CptDiagnosis.class.isAssignableFrom(clazz)) {
            return (T)this.lookupDiagnosis(string);
        }
        if (CptModifier.class.isAssignableFrom(clazz)) {
            return (T)this.lookupModifier(string);
        }
        if (CptProcedure.class.isAssignableFrom(clazz)) {
            return (T)this.lookupProcedure(string);
        }
        throw new RuntimeException("don't know how to handler type " + clazz.getName());
    }

    public CptProcedure lookupProcedure(String string) {
        return this.getProceduresMap().get(string);
    }

    public CptDiagnosis lookupDiagnosis(String string) {
        return this.lookupMedicalCode(this.getDiagnosis(), string);
    }

    public CptModifier lookupModifier(String string) {
        return this.lookupMedicalCode(this.getModifiers(), string);
    }

    private <T extends CptCode> T lookupMedicalCode(List<T> list, String string) {
        for (CptCode cptCode : list) {
            if (!string.trim().equals(cptCode.getCode().trim())) continue;
            return (T)cptCode;
        }
        return null;
    }

    public void setDiagnosis(List<CptDiagnosis> list) {
        this._diagnosis = list;
    }

    public void setModifiers(List<CptModifier> list) {
        this._modifiers = list;
    }

    public void setProcedures(List<CptProcedure> list) {
        this._procedures = list;
    }

    public DateX getCreation() {
        return this._creation;
    }

    public void setCreation(DateX dateX) {
        this._creation = dateX;
    }

    public DateX getLastUpdate() {
        return this._lastUpdate;
    }

    public void setLastUpdate(DateX dateX) {
        this._lastUpdate = dateX;
    }

    static interface DateGetter {
        public DateX getDate();
    }
}

