/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp.cdl;

import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Database;
import com.ahsrcm.corp.Division;
import com.ahsrcm.corp.cdl.CDLFactory;
import java.io.Serializable;
import java.util.List;
import net.model3.collections.ListX;
import net.model3.lang.ClassX;
import net.model3.lang.StringX;

public class CDPEntity
implements Serializable {
    private static final long serialVersionUID = 2107265293750518711L;
    String _companyId;
    String _divisionId;
    String _practiceId;
    transient List<String> _keys;
    transient String _entityName;

    public CDPEntity(String string, String string2, String string3) {
        this._companyId = string;
        this._divisionId = string2;
        this._practiceId = string3;
    }

    public String getDatabaseId() {
        Database database = this.getDatabase();
        if (database == null) {
            return null;
        }
        return (String)database.id.get();
    }

    public String getCompanyId() {
        return this._companyId;
    }

    public String getDivisionId() {
        return this._divisionId;
    }

    public String getPracticeId() {
        return this._practiceId;
    }

    public Database getDatabase() {
        return (Database)this.getCompany().database.get();
    }

    public Company getCompany() {
        String string = this.getCompanyId();
        if (StringX.isNotBlank((String)string)) {
            return Company.fetchByPk(string);
        }
        return null;
    }

    public Division getDivision() {
        String string = this.getDivisionId();
        if (StringX.isNotBlank((String)string)) {
            return Division.fetchByPk(this.getCompanyId(), string);
        }
        return null;
    }

    public String getEntityName() {
        if (this._entityName == null) {
            this._entityName = CDLFactory.toEntityId(this._companyId, this._divisionId, this._practiceId);
        }
        return this._entityName;
    }

    public String toString() {
        return ClassX.getShortName(this.getClass()) + "[" + this.getEntityName() + "]";
    }

    public List<String> getKeys() {
        if (this._keys == null) {
            List list = ListX.create();
            for (String string : new String[]{this.getCompanyId(), this.getDivisionId(), this.getPracticeId()}) {
                if (StringX.isBlank((String)string)) break;
                list.add(string);
            }
            this._keys = list;
        }
        return this._keys;
    }

    public boolean isAuthorizationMatch(CDPEntity cDPEntity, boolean bl) {
        String string = this.getEntityName();
        String string2 = cDPEntity.getEntityName();
        if (bl) {
            return string2.startsWith(string);
        }
        return string.startsWith(string2) || string2.startsWith(string);
    }

    public int compareTo(CDPEntity cDPEntity) {
        return this.getEntityName().compareTo(cDPEntity.getEntityName());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CDPEntity cDPEntity = (CDPEntity)object;
        return cDPEntity.getEntityName().equals(this.getEntityName());
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + (this.getEntityName() != null ? this.getEntityName().hashCode() : 0);
        return n;
    }

    public String getWhereClause(String string) {
        String string2 = string + "CMP";
        String string3 = string + "DIV";
        String string4 = string + "PRA";
        return this.getWhereClause(string2, string3, string4, true);
    }

    public String getWhereClause(String string, String string2, String string3, boolean bl) {
        if (StringX.isBlank((String[])new String[]{string, string2, string3})) {
            return "1=1";
        }
        String string4 = this.getCompanyId();
        String string5 = this.getDivisionId();
        String string6 = this.getPracticeId();
        if (StringX.isNotBlank((String)string3)) {
            return "(" + string + " = '" + string4 + "' and " + string2 + " = '" + string5 + "' and " + string3 + " = '" + string6 + "')";
        }
        if (bl) {
            return "1=2";
        }
        return "1=1";
    }
}

