/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp.cdl;

import com.ahsrcm.corp.cdl.CDLAuthenticator;
import com.ahsrcm.corp.cdl.CDLEntity;
import java.util.List;
import java.util.Set;
import net.model3.collections.SetX;

public class CDLSet
implements CDLAuthenticator {
    final Set<String> _explicitlyAuthorized = SetX.create();
    final Set<String> _implicitlyAuthorized = SetX.create();
    final List<CDLEntity> _entities;

    public CDLSet(List<CDLEntity> list) {
        this._entities = list;
        for (CDLEntity cDLEntity : list) {
            this._explicitlyAuthorized.add(cDLEntity.getEntityName());
            for (CDLEntity cDLEntity2 : cDLEntity.getEntityChain(false)) {
                this._implicitlyAuthorized.add(cDLEntity2.getEntityName());
            }
        }
    }

    @Override
    public boolean isAuthorizationMatch(CDLEntity cDLEntity, boolean bl) {
        if (this._entities.size() < 2) {
            for (CDLEntity cDLEntity2 : this._entities) {
                if (!cDLEntity2.isAuthorizationMatch(cDLEntity, bl)) continue;
                return true;
            }
            return false;
        }
        if (!bl && this._implicitlyAuthorized.contains(cDLEntity.getEntityName())) {
            return true;
        }
        CDLEntity cDLEntity3 = cDLEntity;
        while (!cDLEntity3.isRoot()) {
            if (this._explicitlyAuthorized.contains(cDLEntity3.getEntityName())) {
                return true;
            }
            cDLEntity3 = cDLEntity3.getParent();
        }
        return false;
    }

    @Override
    public String getWhereClause(String string, String string2, String string3, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (CDLEntity cDLEntity : this._entities) {
            if (stringBuilder.length() == 0) {
                stringBuilder.append("(");
            } else {
                stringBuilder.append(" or ");
            }
            stringBuilder.append(cDLEntity.getWhereClause(string, string2, string3, bl));
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public List<CDLEntity> getEntities() {
        return this._entities;
    }
}

