/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp.cdl;

import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Division;
import com.ahsrcm.corp.Location;
import com.ahsrcm.corp.cdl.CDLAuthenticator;
import com.ahsrcm.corp.cdl.CDLEntity;
import com.ahsrcm.corp.cdl.CDLSet;
import com.ahsrcm.corp.cdl.NullCDLAuthenticator;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.model3.guice.DependencyInjector;
import net.model3.lang.StringX;

@Singleton
public class CDLFactory {
    Map<String, CDLEntity> _entityCache = new ConcurrentHashMap<String, CDLEntity>();
    CDLAuthenticator _nullAuthenticator = new NullCDLAuthenticator();

    public static final CDLFactory get() {
        return (CDLFactory)DependencyInjector.getInstance(CDLFactory.class);
    }

    @Inject
    private CDLFactory() {
    }

    public CDLAuthenticator createAuthenticator(List<CDLEntity> list) {
        if (list.isEmpty()) {
            return this._nullAuthenticator;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return new CDLSet(list);
    }

    public CDLEntity getCDL(Location location) {
        Object[] objectArray = location.getPrimaryKey();
        return this.getCDL((String)objectArray[0], (String)objectArray[1], (String)objectArray[2]);
    }

    public CDLEntity getCDL(Division division) {
        return this.getCDL((String)((Company)division.company.get()).id.get(), (String)division.id.get(), null);
    }

    public CDLEntity getCDL(Company company) {
        return this.getCDL((String)company.id.get(), null, null);
    }

    public static String toEntityId(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string4 : new String[]{string, string2, string3}) {
            if (StringX.isBlank((String)string4)) break;
            stringBuilder.append(string4.trim());
            stringBuilder.append(":");
        }
        return stringBuilder.toString();
    }

    public CDLEntity getCDL(String string) {
        if (StringX.isBlank((String)string)) {
            return this.getCDL("", "", "");
        }
        String[] stringArray = (string = string.trim()).split(":");
        int n = stringArray.length - 3;
        if (n < 0) {
            n = 0;
        }
        String string2 = stringArray[n++];
        String string3 = "";
        String string4 = "";
        if (n < stringArray.length) {
            string3 = stringArray[n++];
        }
        if (n < stringArray.length) {
            string4 = stringArray[n++];
        }
        return this.getCDL(string2, string3, string4);
    }

    public CDLEntity getCDL(String string, String string2, String string3) {
        String string4 = CDLFactory.toEntityId(string, string2, string3);
        CDLEntity cDLEntity = this._entityCache.get(string4);
        if (cDLEntity == null) {
            cDLEntity = new CDLEntity(string, string2, string3);
        }
        return cDLEntity;
    }
}

