/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp.cdl;

import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Database;
import com.ahsrcm.corp.Division;
import com.ahsrcm.corp.Location;
import com.ahsrcm.corp.cdl.CDLAuthenticator;
import com.ahsrcm.corp.cdl.CDLEntityHandler;
import com.ahsrcm.corp.cdl.CDLFactory;
import java.io.Serializable;
import java.util.List;
import net.java.dev.properties.jdbc.handlers.DefaultTypeHandler;
import net.model3.collections.ListX;
import net.model3.lang.ClassX;
import net.model3.lang.StringX;

@DefaultTypeHandler(value=CDLEntityHandler.class)
public class CDLEntity
implements CDLAuthenticator,
Serializable,
Comparable<CDLEntity> {
    private static final long serialVersionUID = 2107265293750518711L;
    String _companyId;
    String _divisionId;
    String _locationId;
    transient CDLEntity _parentEntity;
    transient boolean _parentEntitySet;
    transient List<String> _keys;
    transient String _entityName;

    static String upperit(String string) {
        if (string != null) {
            return string.toUpperCase();
        }
        return null;
    }

    CDLEntity(String string, String string2, String string3) {
        this._companyId = CDLEntity.upperit(string);
        this._divisionId = CDLEntity.upperit(string2);
        this._locationId = CDLEntity.upperit(string3);
    }

    public String getDatabaseId() {
        Database database = this.getDatabase();
        if (database == null) {
            return null;
        }
        return (String)database.id.get();
    }

    public String getCompanyId() {
        return this._companyId;
    }

    public String getDivisionId() {
        return this._divisionId;
    }

    public String getLocationId() {
        return this._locationId;
    }

    public Database getDatabase() {
        return (Database)this.getCompany().database.get();
    }

    public Company getCompany() {
        String string = this.getCompanyId();
        if (StringX.isNotBlank((String)string)) {
            return Company.fetchByPk(string);
        }
        return null;
    }

    public Division getDivision() {
        String string = this.getDivisionId();
        if (StringX.isNotBlank((String)string)) {
            return Division.fetchByPk(this.getCompanyId(), string);
        }
        return null;
    }

    public Location getLocation() {
        String string = this.getLocationId();
        if (StringX.isNotBlank((String)string)) {
            return Location.fetchByPk(this.getCompanyId(), this.getDivisionId(), string);
        }
        return null;
    }

    public boolean isRoot() {
        return StringX.isBlank((String[])new String[]{this._companyId, this._divisionId, this._locationId});
    }

    public boolean isCompanyLevel() {
        return StringX.isNotBlank((String)this._companyId) && StringX.isBlank((String)this._divisionId);
    }

    public boolean isDatabaseLevel() {
        return false;
    }

    public boolean isDivisionLevel() {
        return StringX.isNotBlank((String)this._divisionId) && StringX.isBlank((String)this._locationId);
    }

    public boolean isLocationLevel() {
        return StringX.isNotBlank((String)this._locationId);
    }

    public List<CDLEntity> getEntityChain(boolean bl) {
        List list = ListX.create();
        if (bl || !this.isRoot()) {
            list.add(this);
            for (CDLEntity cDLEntity : this.getAncestors(bl)) {
                list.add(cDLEntity);
            }
        }
        return list;
    }

    List<CDLEntity> getAncestors(boolean bl) {
        List list = ListX.create();
        for (CDLEntity cDLEntity = this.getParent(); cDLEntity != null && (bl || !cDLEntity.isRoot()); cDLEntity = cDLEntity.getParent()) {
            list.add(cDLEntity);
        }
        return list;
    }

    public String getEntityName() {
        if (this._entityName == null) {
            this._entityName = CDLFactory.toEntityId(this._companyId, this._divisionId, this._locationId);
        }
        return this._entityName;
    }

    public String toString() {
        return ClassX.getShortName(this.getClass()) + "[" + this.getEntityName() + "]";
    }

    public List<String> getKeys() {
        if (this._keys == null) {
            List list = ListX.create();
            for (String string : new String[]{this.getCompanyId(), this.getDivisionId(), this.getLocationId()}) {
                if (StringX.isBlank((String)string)) break;
                list.add(string);
            }
            this._keys = list;
        }
        return this._keys;
    }

    public CDLEntity getParent() {
        if (!this._parentEntitySet) {
            this._parentEntitySet = true;
            if (!this.isRoot()) {
                String string = this.getCompanyId();
                String string2 = this.getDivisionId();
                String string3 = this.getLocationId();
                if (this.isLocationLevel()) {
                    string3 = "";
                } else if (this.isDivisionLevel()) {
                    string2 = "";
                } else if (this.isCompanyLevel()) {
                    string = "";
                }
                this._parentEntity = CDLFactory.get().getCDL(string, string2, string3);
            }
        }
        return this._parentEntity;
    }

    @Override
    public boolean isAuthorizationMatch(CDLEntity cDLEntity, boolean bl) {
        String string = this.getEntityName();
        String string2 = cDLEntity.getEntityName();
        if (bl) {
            return string2.startsWith(string);
        }
        return string.startsWith(string2) || string2.startsWith(string);
    }

    @Override
    public int compareTo(CDLEntity cDLEntity) {
        return this.getEntityName().compareTo(cDLEntity.getEntityName());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CDLEntity cDLEntity = (CDLEntity)object;
        return cDLEntity.getEntityName().equals(this.getEntityName());
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + (this.getEntityName() != null ? this.getEntityName().hashCode() : 0);
        return n;
    }

    public String getWhereClause(String string) {
        String string2 = string + "CMP";
        String string3 = string + "DIV";
        String string4 = string + "LOS";
        return this.getWhereClause(string2, string3, string4, true);
    }

    @Override
    public String getWhereClause(String string, String string2, String string3, boolean bl) {
        if (StringX.isBlank((String[])new String[]{string, string2, string3})) {
            return "1=1";
        }
        String string4 = this.getCompanyId();
        String string5 = this.getDivisionId();
        String string6 = this.getLocationId();
        if (StringX.isNotBlank((String)string6)) {
            if (StringX.isNotBlank((String)string3)) {
                return "(" + string + " = '" + string4 + "' and " + string2 + " = '" + string5 + "' and " + string3 + " = '" + string6 + "')";
            }
            if (bl) {
                return "1=2";
            }
        }
        if (StringX.isNotBlank((String)string5)) {
            if (StringX.isNotBlank((String)string2)) {
                return "(" + string + " = '" + string4 + "' and " + string2 + " = '" + string5 + "')";
            }
            if (bl) {
                return "1=2";
            }
        }
        if (StringX.isNotBlank((String)string4)) {
            return string + " = '" + string4 + "'";
        }
        return "1=1";
    }
}

