/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp.beanprops;

import com.ahsrcm.corp.beanprops.StickyObjects;
import com.ahsrcm.corp.beanprops.StickyObjectsDelegateCache;
import com.google.inject.Inject;
import java.util.List;
import net.java.dev.properties.IndexedProperty;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.jdbc.Session;
import net.java.dev.properties.jdbc.cache.CacheEntryFetchByPk;
import net.java.dev.properties.jdbc.cache.SecondLevelCache;
import net.model3.lang.ThreadScheduler;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class StickyObjectSecondLevelCache
implements SecondLevelCache {
    static Logger logger = LoggerHelper.getLogger();
    final StickyObjectsDelegateCache _delegate;
    final StickyObjects _stickyObjects;

    @Inject
    public StickyObjectSecondLevelCache(StickyObjectsDelegateCache stickyObjectsDelegateCache, ThreadScheduler threadScheduler) {
        this(stickyObjectsDelegateCache, new StickyObjects());
    }

    public StickyObjectSecondLevelCache(StickyObjectsDelegateCache stickyObjectsDelegateCache, StickyObjects stickyObjects) {
        this._delegate = stickyObjectsDelegateCache;
        this._stickyObjects = stickyObjects;
        this.logUseDirtyCheckEqualsFalseWarning();
    }

    public boolean isFailedFetch(CacheEntryFetchByPk cacheEntryFetchByPk, Session session) {
        StickyObjects stickyObjects = this._stickyObjects;
        if (stickyObjects.hasStickyClassLoaded(cacheEntryFetchByPk.getCacheClass())) {
            return stickyObjects.getEntity(cacheEntryFetchByPk) == null;
        }
        return this._delegate.isFailedFetch(cacheEntryFetchByPk, session);
    }

    private void logUseDirtyCheckEqualsFalseWarning() {
        for (Class<Object> clazz : StickyObjects.getStickyClasses()) {
            if (!BeanContainer.get().getContext(clazz).useDirtyChecking()) continue;
            logger.warn((Object)"{} must have annotation of @Table(useDirtyChecking=false)", clazz);
        }
    }

    public <T> List<T> getIndexedProperty(IndexedProperty indexedProperty, Session session) {
        StickyObjects stickyObjects = this._stickyObjects;
        if (stickyObjects.hasStickyClassLoaded(indexedProperty.getParent().getClass())) {
            return stickyObjects.getIndexedProperty(indexedProperty);
        }
        return this._delegate.getIndexedProperty(indexedProperty, session);
    }

    public <T> T getEntity(CacheEntryFetchByPk cacheEntryFetchByPk, Session session) {
        StickyObjects stickyObjects = this._stickyObjects;
        if (stickyObjects.hasStickyClassLoaded(cacheEntryFetchByPk.getCacheClass())) {
            return stickyObjects.getEntity(cacheEntryFetchByPk);
        }
        return (T)this._delegate.getEntity(cacheEntryFetchByPk, session);
    }

    public <T> List<T> getSelectAll(Class<T> clazz, Session session) {
        StickyObjects stickyObjects = this._stickyObjects;
        if (stickyObjects.hasStickyClassLoaded(clazz)) {
            return stickyObjects.selectAll(clazz);
        }
        return this._delegate.getSelectAll(clazz, session);
    }

    public void evictSelectAll(Class<?> clazz) {
        this._delegate.evictSelectAll(clazz);
    }

    public void evictIndexedProperty(IndexedProperty indexedProperty) {
        this._delegate.evictIndexedProperty(indexedProperty);
    }

    public void evictEntity(Class<?> clazz, Object[] objectArray) {
        this._delegate.evictEntity(clazz, objectArray);
    }

    public void evictAll() {
        this._delegate.evictAll();
    }

    public <T> void cacheSelectAll(Class<T> clazz, List<T> list) {
        this._delegate.cacheSelectAll(clazz, list);
    }

    public <T> void cacheIndexedProperty(IndexedProperty<T> indexedProperty, List<T> list) {
        this._delegate.cacheIndexedProperty(indexedProperty, list);
    }

    public void cacheEntity(Object[] objectArray, Object object) {
        this._delegate.cacheEntity(objectArray, object);
    }

    public void cacheEntity(CacheEntryFetchByPk cacheEntryFetchByPk) {
        this._delegate.cacheEntity(cacheEntryFetchByPk);
    }
}

