/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp;

import com.ahsrcm.corp.AbstractAuthenticator;
import com.ahsrcm.corp.CodingCharge;
import com.ahsrcm.corp.HasUser;
import com.ahsrcm.corp.OrmBean;
import com.ahsrcm.corp.PatientFile;
import com.ahsrcm.corp.PatientFileTransaction;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.ScanBatchExtraData;
import com.ahsrcm.corp.ScannedImage;
import com.ahsrcm.corp.ScannedImageView;
import com.ahsrcm.corp.User;
import com.ahsrcm.corp.WorkflowNote;
import com.ahsrcm.corp.cdl.CDLAuthenticator;
import com.ahsrcm.corp.rules.UserRole;
import com.ahsrcm.scanning.dao.AuthorizationException;
import java.util.Set;
import net.model3.collections.SetX;
import net.model3.lang.ObjectX;

public class UserAuthenticator
extends AbstractAuthenticator {
    public static final Set<Class<?>> _updatableTypes = (Set)ObjectX.magicast((Object)SetX.create((Object[])new Class[]{ScanBatch.class, PatientFile.class, ScannedImage.class, CodingCharge.class, PatientFileTransaction.class, WorkflowNote.class, ScannedImageView.class, ScanBatchExtraData.class}));
    final User _user;

    public UserAuthenticator(User user) {
        this._user = user;
    }

    @Override
    public User getUser() {
        return this._user;
    }

    @Override
    public CDLAuthenticator getCDLAuthenticator() {
        return (CDLAuthenticator)this._user.cdlAuthenticator.get();
    }

    @Override
    public boolean canEnterCharges() {
        return this._user.roles.contains((Object)UserRole.Coder.get()) || this._user.roles.contains((Object)UserRole.CodingManager.get());
    }

    @Override
    public boolean canCancelBatchesAndVisits() {
        return this._user.canCancelBatchesAndVisits();
    }

    @Override
    public void validateForUpdate(OrmBean ormBean) {
        if (ormBean instanceof HasUser) {
            User user = ((HasUser)((Object)ormBean)).getUser();
            if (!user.equals(this._user)) {
                this.throwAuthorizationException(ormBean);
            }
        } else if (!this._user.hasRole(UserRole.Ops.get()) && !_updatableTypes.contains(ormBean.getClass())) {
            this.throwAuthorizationException(ormBean);
        } else {
            this.validateForReading(ormBean);
        }
    }

    @Override
    public void validateForReading(OrmBean ormBean) {
        User user;
        if (ormBean instanceof HasUser && (user = ((HasUser)((Object)ormBean)).getUser()).equals(this._user)) {
            return;
        }
        super.validateForReading(ormBean);
    }

    AuthorizationException throwAuthorizationException(Object object) {
        throw new AuthorizationException("User " + this.getUserDescription() + " is not authorized to update bean " + object);
    }

    @Override
    public boolean isAdministrator() {
        return this._user.isAdministrator();
    }

    @Override
    public boolean canAccessAllInfoEdgeUsers() {
        return this._user.canAccessAllInfoEdgeUsers();
    }

    @Override
    public Set<String> getIfsFileRoles() {
        return this._user.getIfsFileRoles();
    }

    @Override
    public boolean hasRole(UserRole userRole) {
        return this._user.hasRole(userRole);
    }
}

