/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp;

import com.ahsrcm.corp.Authenticator;
import com.ahsrcm.corp.Authorization;
import com.ahsrcm.corp.BaseBusinessBean;
import com.ahsrcm.corp.BatchType;
import com.ahsrcm.corp.BusinessEntity;
import com.ahsrcm.corp.BusinessEntityId;
import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Division;
import com.ahsrcm.corp.InfoedgeQuota;
import com.ahsrcm.corp.Location;
import com.ahsrcm.corp.UserAuthenticator;
import com.ahsrcm.corp.cdl.CDLAuthenticator;
import com.ahsrcm.corp.cdl.CDLEntity;
import com.ahsrcm.corp.cdl.CDLFactory;
import com.ahsrcm.corp.cdl.CDPEntity;
import com.ahsrcm.corp.cdl.PracticeCodeSecurity;
import com.ahsrcm.corp.rules.UserRole;
import com.ahsrcm.scanning.dao.ScanningDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.java.dev.properties.IndexedProperty;
import net.java.dev.properties.LazyIndexedProperty;
import net.java.dev.properties.LazyProperty;
import net.java.dev.properties.Property;
import net.java.dev.properties.annotations.Attributes;
import net.java.dev.properties.annotations.Bidirectional;
import net.java.dev.properties.annotations.Column;
import net.java.dev.properties.annotations.Table;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.BeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.ObservableIndexed;
import net.java.dev.properties.container.ObservableProperty;
import net.java.dev.properties.container.PropertyContextable;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.Query;
import net.java.dev.properties.jdbc.QueryForString;
import net.java.dev.properties.util.BeanComparator;
import net.model3.collections.CollectionX;
import net.model3.collections.ListX;
import net.model3.collections.SetX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.StringX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;

@Table(name="EHUSER", prefix="U0", useDirtyChecking=false)
public class User
extends BaseBusinessBean<User>
implements Serializable {
    private static final Log logger = LogHelper.getLog();
    private static final long serialVersionUID = 5348630240433136421L;
    @Column(suffix="INTN", key=true, length=10L)
    @Attributes(displayName="Folder Id")
    public final Property<String> id = ObservableProperty.create();
    @Column(suffix="USER", length=80L)
    @Attributes(displayName="User Id")
    public final Property<String> loginName = ObservableProperty.create((Object)"");
    @Column(suffix="DESC", length=40L)
    @Attributes(displayName="User Description")
    public final Property<String> description = ObservableProperty.create((Object)"");
    @Column(suffix="GRID")
    public final Property<User> group = ObservableProperty.create();
    @Column(suffix="EMAL", length=80L)
    public final Property<String> email = ObservableProperty.create((Object)"");
    @Bidirectional(value="user-entities", parent=true)
    public final IndexedProperty<BusinessEntity> businessEntities = ObservableIndexed.create();
    private transient UserAuthenticator _authenticator;
    private transient Set<String> _ifsFileRoles;
    private transient Set<String> _explicitCompanyIds;
    public final transient LazyIndexedProperty<Location> allowedLocations = new LazyIndexedProperty<Location>(){
        private static final long serialVersionUID = -6849478446839516029L;

        public void init(List<Location> list) {
            Set set = SetX.create();
            for (Object object : User.this.authorizations) {
                set.addAll(((Authorization)object).getAuthorizedLocations());
            }
            for (Object object : set) {
                if (object == null || ((Location)object).division.get() == null) continue;
                list.add((Location)object);
            }
        }
    };
    public final transient LazyProperty<PracticeCodeSecurity> practiceCodeSecurity = new LazyProperty<PracticeCodeSecurity>(){

        public PracticeCodeSecurity init() {
            List list = ListX.create();
            if (!User.this.hasCDLSecurity()) {
                for (BusinessEntity businessEntity : (List)User.this.businessEntities.get()) {
                    if (!businessEntity.getEntityId().equals("CDP")) continue;
                    String string = StringX.padRight((Object)businessEntity.value.get(), (int)12);
                    list.add(new CDPEntity(string.substring(0, 4), string.substring(4, 8), string.substring(8, 12)));
                }
            }
            return new PracticeCodeSecurity(list);
        }
    };
    public final transient LazyIndexedProperty<Authorization> authorizations = new LazyIndexedProperty<Authorization>(){
        private static final long serialVersionUID = -6849478446839516029L;
        private Authorization authorization;

        public void init(List<Authorization> list) {
            for (BusinessEntity businessEntity : User.this.getEntities(BusinessEntityId.CompanyDivisionLOS)) {
                this.authorization = new Authorization(businessEntity);
                if (!this.authorization.isValid()) continue;
                list.add(this.authorization);
            }
            if (User.this.group.get() != null) {
                list.addAll(((User)User.this.group.get()).authorizations.get());
            }
        }
    };
    public final transient LazyIndexedProperty<CDLEntity> cdlEntities = new LazyIndexedProperty<CDLEntity>(){
        private static final long serialVersionUID = -6849478446839516029L;

        public void init(List<CDLEntity> list) {
            for (BusinessEntity businessEntity : User.this.getEntities(BusinessEntityId.CompanyDivisionLOS)) {
                List list2 = ListX.create();
                String string = StringX.padRight((Object)businessEntity.value.get(), (int)12);
                CDLEntity cDLEntity = CDLFactory.get().getCDL(string.substring(0, 4), string.substring(4, 8), string.substring(8, 12));
                list.add(cDLEntity);
            }
        }
    };
    public final transient LazyProperty<CDLAuthenticator> cdlAuthenticator = new LazyProperty<CDLAuthenticator>(){
        private static final long serialVersionUID = 1184714307543072635L;

        public CDLAuthenticator init() {
            if (User.this.cdlEntities.size() == 0 && ((PracticeCodeSecurity)User.this.practiceCodeSecurity.get()).getList().size() > 0) {
                return (CDLAuthenticator)User.this.practiceCodeSecurity.get();
            }
            return CDLFactory.get().createAuthenticator(User.this.cdlEntities.get());
        }
    };
    public final transient LazyIndexedProperty<UserRole> roles = new LazyIndexedProperty<UserRole>(){
        private static final long serialVersionUID = -6849478446839516029L;

        public void init(List<UserRole> list) {
            for (BusinessEntity businessEntity : User.this.getEntities(BusinessEntityId.Role)) {
                String string = ((String)businessEntity.value.get()).trim();
                UserRole userRole = (UserRole)CurrentSession.get().fetchByPK(UserRole.class, new Object[]{string});
                if (userRole != null) {
                    list.add(userRole);
                    continue;
                }
                logger.warn((Object)"role {} not found", (Object)string);
            }
        }
    };
    public final transient LazyIndexedProperty<BatchType> batchTypes = new LazyIndexedProperty<BatchType>(){
        private static final long serialVersionUID = -6849478446839516029L;

        public void init(List<BatchType> list) {
            for (BusinessEntity businessEntity : User.this.getEntities(BusinessEntityId.BatchType)) {
                String string = ((String)businessEntity.value.get()).trim();
                BatchType batchType = (BatchType)CurrentSession.get().fetchByPK(BatchType.class, new Object[]{string});
                if (batchType != null) {
                    list.add(batchType);
                    continue;
                }
                logger.warn((Object)"batchType {} not found", (Object)string);
            }
        }
    };
    public final transient LazyIndexedProperty<Company> allowedCompanies = new LazyIndexedProperty<Company>(){
        private static final long serialVersionUID = -4961197847436288685L;

        public List<Company> init() {
            Set set = SetX.create();
            for (Location location : User.this.allowedLocations) {
                if (location.division.get() == null) {
                    logger.warn((Object)"Division was null for location: {}", (Object)location.getVisualId());
                    continue;
                }
                set.add((Company)((Division)location.division.get()).company.get());
            }
            return new ArrayList<Company>(set);
        }
    };
    public final transient LazyIndexedProperty<Division> allowedDivisions = new LazyIndexedProperty<Division>(){
        private static final long serialVersionUID = -4961197847436288685L;

        public List<Division> init() {
            Set set = SetX.create();
            for (Location location : User.this.allowedLocations) {
                set.add((Division)location.division.get());
            }
            return new ArrayList<Division>(set);
        }
    };
    public static final BeanContext $BeanContext = (BeanContext)BeanContainer.get().getContext(User.class);
    public static final IPropertyContext $visualId = $BeanContext.getProperty("visualId");
    public static final IPropertyContext $id = $BeanContext.getProperty("id");
    public static final IPropertyContext $loginName = $BeanContext.getProperty("loginName");
    public static final IPropertyContext $description = $BeanContext.getProperty("description");
    public static final IPropertyContext $group = $BeanContext.getProperty("group");
    public static final IPropertyContext $email = $BeanContext.getProperty("email");
    public static final IPropertyContext $businessEntities = $BeanContext.getProperty("businessEntities");
    public static final IPropertyContext $allowedLocations = $BeanContext.getProperty("allowedLocations");
    public static final IPropertyContext $practiceCodeSecurity = $BeanContext.getProperty("practiceCodeSecurity");
    public static final IPropertyContext $authorizations = $BeanContext.getProperty("authorizations");
    public static final IPropertyContext $cdlEntities = $BeanContext.getProperty("cdlEntities");
    public static final IPropertyContext $cdlAuthenticator = $BeanContext.getProperty("cdlAuthenticator");
    public static final IPropertyContext $roles = $BeanContext.getProperty("roles");
    public static final IPropertyContext $batchTypes = $BeanContext.getProperty("batchTypes");
    public static final IPropertyContext $allowedCompanies = $BeanContext.getProperty("allowedCompanies");
    public static final IPropertyContext $allowedDivisions = $BeanContext.getProperty("allowedDivisions");
    public static final User Meta = new User();

    public User() {
        BeanContainer.bind((Object)this);
    }

    public User(String string, String string2) {
        this.loginName.set((Object)string);
        this.id.set((Object)string2);
        BeanContainer.bind((Object)this);
    }

    public Set<BusinessEntity> getEntities(BusinessEntityId businessEntityId) {
        String string = businessEntityId.getDatabaseId();
        Set set = SetX.create();
        for (BusinessEntity businessEntity : this.businessEntities) {
            if (!((String)businessEntity.entityId.get()).trim().equals(string)) continue;
            set.add(businessEntity);
        }
        return set;
    }

    public boolean hasRole(UserRole userRole) {
        return this.roles.contains((Object)userRole);
    }

    public boolean isCoder() {
        return this.roles.contains((Object)UserRole.Coder.get());
    }

    public boolean isCodingManager() {
        return this.roles.contains((Object)UserRole.CodingManager.get());
    }

    public List<Division> getAuthorizedDivisions(Company company) {
        Set set = SetX.create();
        for (Division division : this.allowedDivisions) {
            if (!((Company)division.company.get()).equals(company)) continue;
            set.add(division);
        }
        return CollectionX.sort((List)ListX.create((Iterable)set), (Comparator)BeanComparator.create((PropertyContextable[])new PropertyContextable[]{Division.Meta.name}));
    }

    public List<Company> getExplicitlyAuthorizedCompanies() {
        Set set = SetX.create();
        for (Authorization authorization : this.authorizations) {
            if (!authorization.isCompanyLevel()) continue;
            set.add(authorization.getCompany());
        }
        return CollectionX.sort((List)ListX.create((Iterable)set), (Comparator)BeanComparator.create((PropertyContextable[])new PropertyContextable[]{Company.Meta.id}));
    }

    public Set<String> getExplicitlyAuthorizedCompanyIds() {
        if (this._explicitCompanyIds == null) {
            Set set = SetX.create();
            for (Authorization authorization : this.authorizations) {
                if (!authorization.isCompanyLevel()) continue;
                String string = (String)authorization.getCompany().id.get();
                string = string.trim();
                set.add(string);
            }
            this._explicitCompanyIds = set;
        }
        return this._explicitCompanyIds;
    }

    public void resetLazies() {
        this.allowedLocations.reset();
        this.authorizations.reset();
        this.cdlEntities.reset();
        this.cdlAuthenticator.reset();
        this.roles.reset();
        this.batchTypes.reset();
        this.allowedCompanies.reset();
        this.allowedDivisions.reset();
    }

    public List<Division> getExplicitlyAuthorizedDivisions() {
        Set set = SetX.create();
        for (Authorization authorization : this.authorizations) {
            if (authorization.isDivisionLevel()) {
                set.add(authorization.getDivision());
                continue;
            }
            if (!authorization.isCompanyLevel()) continue;
            set.addAll(authorization.getCompany().divisions.get());
        }
        return CollectionX.sort((List)ListX.create((Iterable)set), (Comparator)BeanComparator.create((PropertyContextable[])new PropertyContextable[]{Division.Meta.id}));
    }

    public List<Location> getAuthorizedLocations(Division division) {
        Set set = SetX.create();
        for (Location location : this.allowedLocations) {
            if (location.division.get() == null) {
                logger.warn((Object)"Division was null for location: {}", (Object)location.getVisualId());
                continue;
            }
            if (location.isInactive() || !((Division)location.division.get()).equals(division)) continue;
            set.add(location);
        }
        Location location = new Location();
        return CollectionX.sort((List)ListX.create((Iterable)set), (Comparator)BeanComparator.create((PropertyContextable[])new PropertyContextable[]{location.name}));
    }

    public Authenticator getAuthenticator() {
        if (this._authenticator == null) {
            this._authenticator = new UserAuthenticator(this);
        }
        return this._authenticator;
    }

    public boolean isManager() {
        return this.roles.contains((Object)UserRole.Administrator.get()) || this.roles.contains((Object)UserRole.CodingManager.get()) || this.roles.contains((Object)UserRole.DataEntryManager.get());
    }

    @Override
    public String toString() {
        return ((String)this.loginName.get()).trim() + " - " + ((String)this.description.get()).trim();
    }

    public boolean hasCDLSecurity() {
        return this.cdlEntities.size() > 0;
    }

    public boolean hasPracticeCodeSecurity() {
        return !this.hasCDLSecurity();
    }

    @Override
    public String getVisualId() {
        return (String)this.description.get();
    }

    public boolean isAdministrator() {
        return this.roles.contains((Object)UserRole.Administrator.get());
    }

    public boolean canCancelBatchesAndVisits() {
        return this.roles.contains((Object)UserRole.Administrator.get());
    }

    public boolean canAccessAllInfoEdgeUsers() {
        return this.roles.contains((Object)UserRole.AccessAllInfoEdgeUsers.get());
    }

    public static User fetchByLogin(String string) {
        if (string != null) {
            return User.fetch("U0USER = ?", string.toLowerCase());
        }
        return null;
    }

    public static User fetchByLoginOrId(String string) {
        User user = User.fetchByLogin(string);
        if (user == null) {
            user = User.fetchByPk(string);
        }
        return user;
    }

    public Set<String> getIfsFileRoles() {
        if (this._ifsFileRoles == null) {
            Set<String> set = this.initIfsFileRoles();
            if (this.group.get() != null) {
                set.addAll(((User)this.group.get()).getIfsFileRoles());
            }
            this._ifsFileRoles = set;
        }
        return this._ifsFileRoles;
    }

    private Set<String> initIfsFileRoles() {
        Set set = SetX.create();
        set.addAll(new QueryForString("select u2task from ehusac where u2intn = ?", null, new Object[]{this.id.get()}).getResults());
        set.addAll(new QueryForString("select tstask from ehtsec where tsintn = ?", null, new Object[]{this.id.get()}).getResults());
        Set set2 = SetX.create();
        for (String string : set) {
            set2.add(string.trim());
        }
        return set2;
    }

    public boolean canDoDataEntry() {
        return this.roles.contains((Object)UserRole.DataEntryUser.get()) || this.roles.contains((Object)UserRole.DataEntryManager.get());
    }

    public List<User> getColleagues() {
        List list = ListX.create();
        for (User user : User.selectAll()) {
            if (!this.isColleague(user)) continue;
            list.add(user);
        }
        return list;
    }

    public boolean isColleague(User user) {
        User user2 = this;
        User user3 = user;
        if (((String)user2.id.get()).equals(user3.id.get())) {
            return false;
        }
        if (user2.cdlEntities.size() > user3.cdlEntities.size()) {
            user2 = user;
            user3 = this;
        }
        for (CDLEntity cDLEntity : user2.cdlEntities.get()) {
            if (!user3.isAuthorizedTo(cDLEntity)) continue;
            return true;
        }
        return false;
    }

    public boolean isAuthorizedTo(CDLEntity cDLEntity) {
        return ((CDLAuthenticator)this.cdlAuthenticator.get()).isAuthorizationMatch(cDLEntity, false);
    }

    public static List<User> getUsers(CDLEntity cDLEntity) {
        List list = ListX.create();
        for (User user : User.selectAll()) {
            if (!user.isAuthorizedTo(cDLEntity)) continue;
            list.add(user);
        }
        return list;
    }

    public InfoedgeQuota getInfoedgeQuota() {
        InfoedgeQuota infoedgeQuota = InfoedgeQuota.fetchByPk((String)this.id.get());
        if (infoedgeQuota == null) {
            infoedgeQuota = InfoedgeQuota.fetchByPk("*ALL");
        }
        if (infoedgeQuota == null) {
            infoedgeQuota = new InfoedgeQuota();
            infoedgeQuota.quotaInMegs.set((Object)0x3200000);
        }
        return infoedgeQuota;
    }

    public String getId() {
        return (String)this.id.get();
    }

    public void setId(String string) {
        this.id.set((Object)string);
    }

    public String getLoginName() {
        return (String)this.loginName.get();
    }

    public void setLoginName(String string) {
        this.loginName.set((Object)string);
    }

    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String string) {
        this.description.set((Object)string);
    }

    public User getGroup() {
        return (User)this.group.get();
    }

    public void setGroup(User user) {
        this.group.set((Object)user);
    }

    public String getEmail() {
        return (String)this.email.get();
    }

    public void setEmail(String string) {
        this.email.set((Object)string);
    }

    public List<BusinessEntity> getBusinessEntities() {
        return (List)this.businessEntities.get();
    }

    public void setBusinessEntities(List<BusinessEntity> list) {
        this.businessEntities.set(list);
    }

    public void setAuthenticator(UserAuthenticator userAuthenticator) {
        this._authenticator = userAuthenticator;
    }

    public void setIfsFileRoles(Set<String> set) {
        this._ifsFileRoles = set;
    }

    public Set<String> getExplicitCompanyIds() {
        return this._explicitCompanyIds;
    }

    public void setExplicitCompanyIds(Set<String> set) {
        this._explicitCompanyIds = set;
    }

    public List<Location> getAllowedLocations() {
        return this.allowedLocations.get();
    }

    public void setAllowedLocations(List<Location> list) {
        this.allowedLocations.set(list);
    }

    public PracticeCodeSecurity getPracticeCodeSecurity() {
        return (PracticeCodeSecurity)this.practiceCodeSecurity.get();
    }

    public void setPracticeCodeSecurity(PracticeCodeSecurity practiceCodeSecurity) {
        this.practiceCodeSecurity.set((Object)practiceCodeSecurity);
    }

    public List<Authorization> getAuthorizations() {
        return this.authorizations.get();
    }

    public void setAuthorizations(List<Authorization> list) {
        this.authorizations.set(list);
    }

    public List<CDLEntity> getCdlEntities() {
        return this.cdlEntities.get();
    }

    public void setCdlEntities(List<CDLEntity> list) {
        this.cdlEntities.set(list);
    }

    public CDLAuthenticator getCdlAuthenticator() {
        return (CDLAuthenticator)this.cdlAuthenticator.get();
    }

    public void setCdlAuthenticator(CDLAuthenticator cDLAuthenticator) {
        this.cdlAuthenticator.set((Object)cDLAuthenticator);
    }

    public List<UserRole> getRoles() {
        return this.roles.get();
    }

    public void setRoles(List<UserRole> list) {
        this.roles.set(list);
    }

    public List<BatchType> getBatchTypes() {
        return this.batchTypes.get();
    }

    public void setBatchTypes(List<BatchType> list) {
        this.batchTypes.set(list);
    }

    public List<Company> getAllowedCompanies() {
        return this.allowedCompanies.get();
    }

    public void setAllowedCompanies(List<Company> list) {
        this.allowedCompanies.set(list);
    }

    public List<Division> getAllowedDivisions() {
        return this.allowedDivisions.get();
    }

    public void setAllowedDivisions(List<Division> list) {
        this.allowedDivisions.set(list);
    }

    public static User fetchByPk(String string) {
        return (User)CurrentSession.get().fetchByPK(User.class, new Object[]{string});
    }

    public static Query<User> select(String string, Object ... objectArray) {
        return CurrentSession.get().select(User.class, string, objectArray);
    }

    public static List<User> selectAll() {
        return ((ScanningDao)DependencyInjector.getInstance(ScanningDao.class)).selectAll(User.class);
    }

    public static User fetch(String string, Object ... objectArray) {
        return (User)ListX.getFirst(User.select(string, objectArray));
    }
}

