/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp;

import com.ahsrcm.corp.BaseBusinessBean;
import com.ahsrcm.corp.HasUser;
import com.ahsrcm.corp.User;
import com.ahsrcm.scanning.dao.ScanningDao;
import java.util.Date;
import java.util.List;
import net.java.dev.properties.Property;
import net.java.dev.properties.annotations.Column;
import net.java.dev.properties.annotations.Table;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.BeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.ObservableProperty;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.Query;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.StringX;
import net.model3.text.ThreadSafeSimpleDateFormat;
import net.model3.util.DateX;

@Table(name="XXSESS", prefix="SS")
public class SingleSignOnSession
extends BaseBusinessBean<SingleSignOnSession>
implements HasUser {
    private static final long serialVersionUID = 7425019824620206537L;
    private static ThreadSafeSimpleDateFormat _timestampFormat = new ThreadSafeSimpleDateFormat("1yyMMddHHmmss");
    private static ThreadSafeSimpleDateFormat _cyymmddDateFormat = new ThreadSafeSimpleDateFormat("1yyMMdd");
    private static ThreadSafeSimpleDateFormat _hhmmssTimeFormat = new ThreadSafeSimpleDateFormat("HHmmss");
    @Column(suffix="SESS", key=true, length=80L)
    public final Property<String> sessionId = ObservableProperty.create();
    @Column(suffix="INTN")
    public final Property<User> user = ObservableProperty.create();
    @Column(suffix="SGLT")
    public final Property<Long> lastRequestDate = ObservableProperty.create();
    @Column(suffix="SGLM")
    public final Property<Long> lastRequestTime = ObservableProperty.create();
    @Column(suffix="SSCL")
    public final Property<Integer> sessionTimeout = ObservableProperty.create();
    public static final BeanContext $BeanContext = (BeanContext)BeanContainer.get().getContext(SingleSignOnSession.class);
    public static final IPropertyContext $visualId = $BeanContext.getProperty("visualId");
    public static final IPropertyContext $sessionId = $BeanContext.getProperty("sessionId");
    public static final IPropertyContext $user = $BeanContext.getProperty("user");
    public static final IPropertyContext $lastRequestDate = $BeanContext.getProperty("lastRequestDate");
    public static final IPropertyContext $lastRequestTime = $BeanContext.getProperty("lastRequestTime");
    public static final IPropertyContext $sessionTimeout = $BeanContext.getProperty("sessionTimeout");
    public static final SingleSignOnSession Meta = new SingleSignOnSession();

    public SingleSignOnSession() {
        BeanContainer.bind((Object)this);
    }

    public void updateLastRequest() {
        Date date = new Date();
        this.lastRequestDate.set((Object)new Long(_cyymmddDateFormat.format(date)));
        this.lastRequestTime.set((Object)new Long(_hhmmssTimeFormat.format(date)));
    }

    public boolean isStillValid() {
        DateX dateX = this.getLastRequestAsTimestamp();
        DateX dateX2 = new DateX();
        DateX dateX3 = dateX.addMinutes(((Integer)this.sessionTimeout.get()).intValue());
        return !dateX3.before(dateX2);
    }

    DateX getLastRequestAsTimestamp() {
        StringBuilder stringBuilder = new StringBuilder();
        StringX.appendNumeric((Appendable)stringBuilder, (long)((Long)this.lastRequestDate.get()), (int)7);
        StringX.appendNumeric((Appendable)stringBuilder, (long)((Long)this.lastRequestTime.get()), (int)6);
        try {
            return new DateX(_timestampFormat.parse(stringBuilder.toString()));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public User getUser() {
        return (User)this.user.get();
    }

    public String getSessionId() {
        return (String)this.sessionId.get();
    }

    public void setSessionId(String string) {
        this.sessionId.set((Object)string);
    }

    public void setUser(User user) {
        this.user.set((Object)user);
    }

    public Long getLastRequestDate() {
        return (Long)this.lastRequestDate.get();
    }

    public void setLastRequestDate(Long l) {
        this.lastRequestDate.set((Object)l);
    }

    public Long getLastRequestTime() {
        return (Long)this.lastRequestTime.get();
    }

    public void setLastRequestTime(Long l) {
        this.lastRequestTime.set((Object)l);
    }

    public Integer getSessionTimeout() {
        return (Integer)this.sessionTimeout.get();
    }

    public void setSessionTimeout(Integer n) {
        this.sessionTimeout.set((Object)n);
    }

    public static SingleSignOnSession fetchByPk(String string) {
        return (SingleSignOnSession)CurrentSession.get().fetchByPK(SingleSignOnSession.class, new Object[]{string});
    }

    public static Query<SingleSignOnSession> select(String string, Object ... objectArray) {
        return CurrentSession.get().select(SingleSignOnSession.class, string, objectArray);
    }

    public static List<SingleSignOnSession> selectAll() {
        return ((ScanningDao)DependencyInjector.getInstance(ScanningDao.class)).selectAll(SingleSignOnSession.class);
    }

    public static SingleSignOnSession fetch(String string, Object ... objectArray) {
        return (SingleSignOnSession)ListX.getFirst(SingleSignOnSession.select(string, objectArray));
    }
}

