/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp;

import com.ahsrcm.core.virtualmanager.VirtualManagerDAO;
import com.ahsrcm.corp.BaseBusinessBean;
import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Database;
import com.ahsrcm.corp.Division;
import com.ahsrcm.corp.Login;
import com.ahsrcm.corp.SecurityTokenProperty;
import com.ahsrcm.corp.User;
import com.ahsrcm.corp.cdl.DatabaseCDLEntity;
import com.ahsrcm.scanning.dao.ScanningDao;
import java.sql.Date;
import java.sql.Time;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.dev.properties.Property;
import net.java.dev.properties.PropertyImpl;
import net.java.dev.properties.annotations.Bidirectional;
import net.java.dev.properties.annotations.Column;
import net.java.dev.properties.annotations.Table;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.BeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.ObservableIndexed;
import net.java.dev.properties.container.ObservableProperty;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.Query;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.util.DateX;

@Table(name="ESPTOKEN", prefix="E4")
public class SecurityToken
extends BaseBusinessBean<SecurityToken> {
    private static final long serialVersionUID = 1027460012968412959L;
    @Column(suffix="TOK", key=true, length=64L)
    public final Property<String> token = ObservableProperty.create();
    @Column(suffix="CMP,DIV")
    public final Property<Division> division = ObservableProperty.create();
    @Column(suffix="JOB", length=10L)
    public final Property<String> jobName = ObservableProperty.create();
    @Bidirectional(value="token-props", parent=true)
    public final ObservableIndexed<SecurityTokenProperty> properties = ObservableIndexed.create();
    @Column(name="\"E4JOB#\"")
    public final Property<Integer> jobNumber = ObservableProperty.create();
    @Column(suffix="PAT", length=12L)
    public final Property<String> patientNumber = ObservableProperty.create();
    @Column(suffix="USER", length=10L)
    public final Property<String> userId = ObservableProperty.create();
    @Column(suffix="ENC")
    public final Property<Long> encounter = ObservableProperty.create();
    @Column(suffix="SGR")
    public final Property<Long> patientFileId = ObservableProperty.create();
    @Column(suffix="TYP", length=3L)
    public final Property<String> type = ObservableProperty.create();
    @Column(suffix="DATL")
    public final Property<Date> lastChangeDate = ObservableProperty.create();
    @Column(suffix="TIML")
    public final Property<Time> lastChangeTime = new ObservableProperty();
    public final transient Property<DateX> lastChangeTimestamp = new PropertyImpl<DateX>(){
        private static final long serialVersionUID = -4746112265964595512L;

        public DateX get() {
            return new DateX((Date)SecurityToken.this.lastChangeDate.get(), (Time)SecurityToken.this.lastChangeTime.get());
        }

        public void set(DateX dateX) {
            super.set((Object)dateX);
            if (dateX == null) {
                SecurityToken.this.lastChangeDate.set(null);
                SecurityToken.this.lastChangeTime.set(null);
            } else {
                SecurityToken.this.lastChangeDate.set((Object)dateX.asSqlDate());
                SecurityToken.this.lastChangeTime.set((Object)dateX.asSqlTime());
            }
        }
    };
    public static final BeanContext $BeanContext = (BeanContext)BeanContainer.get().getContext(SecurityToken.class);
    public static final IPropertyContext $visualId = $BeanContext.getProperty("visualId");
    public static final IPropertyContext $token = $BeanContext.getProperty("token");
    public static final IPropertyContext $division = $BeanContext.getProperty("division");
    public static final IPropertyContext $jobName = $BeanContext.getProperty("jobName");
    public static final IPropertyContext $properties = $BeanContext.getProperty("properties");
    public static final IPropertyContext $jobNumber = $BeanContext.getProperty("jobNumber");
    public static final IPropertyContext $patientNumber = $BeanContext.getProperty("patientNumber");
    public static final IPropertyContext $userId = $BeanContext.getProperty("userId");
    public static final IPropertyContext $encounter = $BeanContext.getProperty("encounter");
    public static final IPropertyContext $patientFileId = $BeanContext.getProperty("patientFileId");
    public static final IPropertyContext $type = $BeanContext.getProperty("type");
    public static final IPropertyContext $lastChangeDate = $BeanContext.getProperty("lastChangeDate");
    public static final IPropertyContext $lastChangeTime = $BeanContext.getProperty("lastChangeTime");
    public static final IPropertyContext $lastChangeTimestamp = $BeanContext.getProperty("lastChangeTimestamp");
    public static final SecurityToken Meta = new SecurityToken();

    public SecurityToken() {
        BeanContainer.bind((Object)this);
    }

    public static final SecurityToken resolve(String string) {
        SecurityToken securityToken = SecurityToken.fetchByPk(string);
        if (securityToken == null) {
            securityToken = SecurityToken.fetchFromClientDatabase(string);
            CurrentSession.get().insert((Object)securityToken);
            for (SecurityTokenProperty securityTokenProperty : securityToken.properties) {
                CurrentSession.get().insert((Object)securityTokenProperty);
            }
            CurrentSession.get().commit();
        }
        return securityToken;
    }

    public static final SecurityToken fetchFromClientDatabase(String string) {
        if (!string.startsWith("TKN")) {
            throw new RuntimeException("token id does not start with TKN " + string);
        }
        String string2 = string.substring(3, 7);
        Database database = Database.fetchByPk(string2);
        if (database == null) {
            throw new RuntimeException("database '" + string2 + "' not found in the token!  tokenId:" + string);
        }
        DatabaseCDLEntity databaseCDLEntity = new DatabaseCDLEntity(database);
        VirtualManagerDAO virtualManagerDAO = (VirtualManagerDAO)DependencyInjector.getInstance(VirtualManagerDAO.class);
        SecurityToken securityToken = virtualManagerDAO.fetchByPk(databaseCDLEntity, SecurityToken.class, string);
        Query<SecurityTokenProperty> query = virtualManagerDAO.select(databaseCDLEntity, SecurityTokenProperty.class, "E9TOK = ?", string);
        securityToken.properties.set(query);
        return securityToken;
    }

    public Map<String, String> getPropertiesAsMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.properties.get() != null && this.properties.get().size() > 0) {
            for (SecurityTokenProperty securityTokenProperty : this.properties.get()) {
                hashMap.put((String)securityTokenProperty.key.get(), (String)securityTokenProperty.value.get());
            }
        }
        return hashMap;
    }

    public String getPropertyValueByName(String string) {
        return this.getPropertiesAsMap().get(string);
    }

    public String getDatabaseId() {
        return (String)((Database)((Company)((Division)this.division.get()).company.get()).database.get()).id.get();
    }

    public void setProperty(String string, String string2) {
        SecurityTokenProperty securityTokenProperty = null;
        for (SecurityTokenProperty securityTokenProperty2 : this.properties) {
            if (!((String)securityTokenProperty2.key.get()).equals(string)) continue;
            securityTokenProperty = securityTokenProperty2;
            break;
        }
        if (securityTokenProperty == null) {
            securityTokenProperty = new SecurityTokenProperty();
            this.properties.add((Object)securityTokenProperty);
            securityTokenProperty.key.set((Object)string);
            CurrentSession.get().insert((Object)securityTokenProperty);
        }
        securityTokenProperty.value.set((Object)string2);
    }

    public void createLogin() {
        Login login = Login.fetchByPk((String)this.token.get());
        if (login == null) {
            login = new Login(this);
            CurrentSession.get().insert((Object)login);
        }
    }

    public User getUser() {
        return User.fetchByLoginOrId(this.getUserId());
    }

    public String getToken() {
        return (String)this.token.get();
    }

    public void setToken(String string) {
        this.token.set((Object)string);
    }

    public Division getDivision() {
        return (Division)this.division.get();
    }

    public void setDivision(Division division) {
        this.division.set((Object)division);
    }

    public String getJobName() {
        return (String)this.jobName.get();
    }

    public void setJobName(String string) {
        this.jobName.set((Object)string);
    }

    public List<SecurityTokenProperty> getProperties() {
        return this.properties.get();
    }

    public void setProperties(List<SecurityTokenProperty> list) {
        this.properties.set(list);
    }

    public Integer getJobNumber() {
        return (Integer)this.jobNumber.get();
    }

    public void setJobNumber(Integer n) {
        this.jobNumber.set((Object)n);
    }

    public String getPatientNumber() {
        return (String)this.patientNumber.get();
    }

    public void setPatientNumber(String string) {
        this.patientNumber.set((Object)string);
    }

    public String getUserId() {
        return (String)this.userId.get();
    }

    public void setUserId(String string) {
        this.userId.set((Object)string);
    }

    public Long getEncounter() {
        return (Long)this.encounter.get();
    }

    public void setEncounter(Long l) {
        this.encounter.set((Object)l);
    }

    public Long getPatientFileId() {
        return (Long)this.patientFileId.get();
    }

    public void setPatientFileId(Long l) {
        this.patientFileId.set((Object)l);
    }

    public String getType() {
        return (String)this.type.get();
    }

    public void setType(String string) {
        this.type.set((Object)string);
    }

    public Date getLastChangeDate() {
        return (Date)this.lastChangeDate.get();
    }

    public void setLastChangeDate(Date date) {
        this.lastChangeDate.set((Object)date);
    }

    public Time getLastChangeTime() {
        return (Time)this.lastChangeTime.get();
    }

    public void setLastChangeTime(Time time) {
        this.lastChangeTime.set((Object)time);
    }

    public DateX getLastChangeTimestamp() {
        return (DateX)this.lastChangeTimestamp.get();
    }

    public void setLastChangeTimestamp(DateX dateX) {
        this.lastChangeTimestamp.set((Object)dateX);
    }

    public static SecurityToken fetchByPk(String string) {
        return (SecurityToken)CurrentSession.get().fetchByPK(SecurityToken.class, new Object[]{string});
    }

    public static Query<SecurityToken> select(String string, Object ... objectArray) {
        return CurrentSession.get().select(SecurityToken.class, string, objectArray);
    }

    public static List<SecurityToken> selectAll() {
        return ((ScanningDao)DependencyInjector.getInstance(ScanningDao.class)).selectAll(SecurityToken.class);
    }

    public static SecurityToken fetch(String string, Object ... objectArray) {
        return (SecurityToken)ListX.getFirst(SecurityToken.select(string, objectArray));
    }
}

