/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp;

import com.ahsrcm.core.crypto.CryptoEngine;
import com.ahsrcm.core.crypto.DecryptedData;
import com.ahsrcm.core.crypto.EncryptedData;
import com.ahsrcm.core.scanning.gui.ScannedImageProxy;
import com.ahsrcm.corp.BaseBusinessBeanWithStatus;
import com.ahsrcm.corp.DocumentType;
import com.ahsrcm.corp.HasCDLEntity;
import com.ahsrcm.corp.HasPatientFileId;
import com.ahsrcm.corp.PatientFile;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.beanprops.NotNull;
import com.ahsrcm.corp.cdl.CDLEntity;
import com.ahsrcm.corp.orm.RotationHandler;
import com.ahsrcm.corp.orm.Status;
import com.ahsrcm.scanning.app.client.GetImageResult;
import com.ahsrcm.scanning.dao.ClientScanningDao;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.ahsrcm.util.ToStringBuilder;
import com.ahsrcm.util.guice.Directories;
import java.lang.ref.WeakReference;
import java.util.List;
import net.java.dev.properties.Property;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.annotations.Bidirectional;
import net.java.dev.properties.annotations.Column;
import net.java.dev.properties.annotations.Table;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.BeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.ObservableProperty;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.Query;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.imaging.Rotation;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import net.model3.newfile.File;

@Table(name="ESPSCNPD", prefix="EE", cacheTimeout="0 seconds")
public class ScannedImage
extends BaseBusinessBeanWithStatus<ScannedImage>
implements HasCDLEntity,
HasPatientFileId {
    private static final Logger logger = LoggerHelper.getLogger(ScannedImage.class);
    private static final long serialVersionUID = 6477460362944289205L;
    @Column(suffix="DID", key=true)
    @NotNull
    public final Property<Long> id = ObservableProperty.create();
    @Column(suffix="SCN")
    @Bidirectional(value="batch-images")
    public final Property<ScanBatch> batch = ObservableProperty.create();
    @Column(suffix="SGR")
    public final Property<Long> patientFileId = ObservableProperty.create();
    @Column(suffix="ROT", typeHandler=RotationHandler.class)
    @NotNull
    public final Property<Rotation> rotation = ObservableProperty.create((Object)Rotation.NONE);
    @Column(suffix="PAG")
    @NotNull
    public final Property<Integer> pageNumber = ObservableProperty.create((Object)1);
    @Column(suffix="PAGES")
    @NotNull
    public final Property<Integer> totalPages = ObservableProperty.create((Object)1);
    @Column(suffix="DTP")
    public final Property<DocumentType> documentType = ObservableProperty.create();
    @Column(suffix="VER")
    @NotNull
    private final Property<Integer> version = ObservableProperty.create((Object)0);
    @Column(suffix="SRDOC")
    @NotNull
    private final Property<Boolean> isOriginalDocument = ObservableProperty.create((Object)false);
    @Column(suffix="ENCKEY", length=32L)
    @NotNull
    private final Property<String> encryptionKey = ObservableProperty.create((Object)"");
    @Column(suffix="SRDID")
    @NotNull
    private final Property<Long> originalDocument = ObservableProperty.create((Object)0L);
    @Column(suffix="SRPG")
    @NotNull
    private final Property<Integer> pageNumberInOriginal = ObservableProperty.create((Object)0);
    @Column(suffix="UP")
    @NotNull
    public final Property<Boolean> uploaded = ObservableProperty.create((Object)false);
    @Column(suffix="MD5", length=32L)
    @NotNull
    public final Property<String> md5 = ObservableProperty.create((Object)"");
    @Column(suffix="PREVDID")
    @NotNull
    public final Property<Long> previousVersion = ObservableProperty.create();
    @Column(suffix="SIZE")
    @NotNull
    public final Property<Long> size = ObservableProperty.create((Object)0L);
    @Column(suffix="FILEEXT", length=10L)
    @NotNull
    public final Property<String> fileExtension = ObservableProperty.create((Object)"");
    @Column(suffix="FILE", length=200L)
    @NotNull
    public final Property<String> fileName = ObservableProperty.create((Object)"");
    private WeakReference<ScannedImageProxy> _scannedImageProxyRef;
    public static final BeanContext $BeanContext = (BeanContext)BeanContainer.get().getContext(ScannedImage.class);
    public static final IPropertyContext $visualId = $BeanContext.getProperty("visualId");
    public static final IPropertyContext $creationUser = $BeanContext.getProperty("creationUser");
    public static final IPropertyContext $creationDate = $BeanContext.getProperty("creationDate");
    public static final IPropertyContext $creationTime = $BeanContext.getProperty("creationTime");
    public static final IPropertyContext $lastChangeUser = $BeanContext.getProperty("lastChangeUser");
    public static final IPropertyContext $lastChangeDate = $BeanContext.getProperty("lastChangeDate");
    public static final IPropertyContext $lastChangeTime = $BeanContext.getProperty("lastChangeTime");
    public static final IPropertyContext $creationTimestamp = $BeanContext.getProperty("creationTimestamp");
    public static final IPropertyContext $lastChangeTimestamp = $BeanContext.getProperty("lastChangeTimestamp");
    public static final IPropertyContext $status = $BeanContext.getProperty("status");
    public static final IPropertyContext $id = $BeanContext.getProperty("id");
    public static final IPropertyContext $batch = $BeanContext.getProperty("batch");
    public static final IPropertyContext $patientFileId = $BeanContext.getProperty("patientFileId");
    public static final IPropertyContext $rotation = $BeanContext.getProperty("rotation");
    public static final IPropertyContext $pageNumber = $BeanContext.getProperty("pageNumber");
    public static final IPropertyContext $documentType = $BeanContext.getProperty("documentType");
    public static final IPropertyContext $version = $BeanContext.getProperty("version");
    public static final IPropertyContext $isOriginalDocument = $BeanContext.getProperty("isOriginalDocument");
    public static final IPropertyContext $encryptionKey = $BeanContext.getProperty("encryptionKey");
    public static final IPropertyContext $originalDocument = $BeanContext.getProperty("originalDocument");
    public static final IPropertyContext $pageNumberInOriginal = $BeanContext.getProperty("pageNumberInOriginal");
    public static final IPropertyContext $uploaded = $BeanContext.getProperty("uploaded");
    public static final IPropertyContext $md5 = $BeanContext.getProperty("md5");
    public static final IPropertyContext $previousVersion = $BeanContext.getProperty("previousVersion");
    public static final IPropertyContext $size = $BeanContext.getProperty("size");
    public static final IPropertyContext $fileExtension = $BeanContext.getProperty("fileExtension");
    public static final IPropertyContext $fileName = $BeanContext.getProperty("fileName");
    public static final ScannedImage Meta = new ScannedImage();

    public ScannedImage() {
        BeanContainer.bind((Object)this);
    }

    public ScannedImageProxy getImageProxy() {
        ScannedImageProxy scannedImageProxy = null;
        if (this._scannedImageProxyRef != null) {
            scannedImageProxy = (ScannedImageProxy)this._scannedImageProxyRef.get();
        }
        if (scannedImageProxy == null) {
            scannedImageProxy = new ScannedImageProxy(this);
            this._scannedImageProxyRef = new WeakReference<ScannedImageProxy>(scannedImageProxy);
        }
        return scannedImageProxy;
    }

    private static String getImageName(long l, int n, Boolean bl) {
        String string = "";
        if (bl.booleanValue()) {
            string = ScannedImage.getCryptoEngine().getCryptoHelper().getEncryptedFileExtension();
        }
        return l + "-" + n + ".tiff" + string;
    }

    public File getImageFile() {
        return this.getImageFile(null);
    }

    public File getImageFile(Integer n) {
        if (n == null) {
            n = (Integer)this.version.get();
        }
        long l = 0L;
        if (this.batch.get() != null) {
            l = (Long)((ScanBatch)this.batch.get()).id.get();
        }
        return ScannedImage.getImageFile(null, l, (Long)this.id.get(), n);
    }

    public static File getImageFile(Directory directory, long l, long l2, int n) {
        if (directory == null) {
            directory = ScannedImage.getDirectories().imageRoot();
        }
        Directory directory2 = ScanBatch.getImageDirectory(l, directory, false);
        File file = new File(directory2, ScannedImage.getImageName(l2, n, ScannedImage.useImageEncryption()));
        logger.debug((Object)("getImageFile -- file canonical path=" + file.getCanonicalPath()));
        return file;
    }

    public static Boolean useImageEncryption() {
        ScanningDao scanningDao = (ScanningDao)DependencyInjector.getInstance(ScanningDao.class);
        Boolean bl = scanningDao.useImageEncryption();
        return bl;
    }

    public static CryptoEngine getCryptoEngine() {
        return (CryptoEngine)DependencyInjector.getInstance(CryptoEngine.class);
    }

    public GetImageResult getImageData() {
        File file = this.getImageFile();
        if (file.exists()) {
            return new GetImageResult(200, file.readBytes());
        }
        if (ClientScanningDao.Impl.get() != null) {
            GetImageResult getImageResult = ((ClientScanningDao)DependencyInjector.getInstance(ClientScanningDao.class)).getImageData(this);
            if (getImageResult.getHttpCode() == 200) {
                if (ScannedImage.useImageEncryption().booleanValue()) {
                    EncryptedData encryptedData = ScannedImage.getCryptoEngine().encrypt(new DecryptedData(getImageResult.getBytes()));
                    file.write(encryptedData.getBytes());
                    return new GetImageResult(200, encryptedData.getBytes());
                }
                file.write(getImageResult.getBytes());
                return getImageResult;
            }
            return getImageResult;
        }
        return null;
    }

    public PatientFile getPatientFile() {
        long l = this.getPatientFileId();
        List<PatientFile> list = this.getBatch().getPatientFiles();
        for (PatientFile patientFile : list) {
            long l2 = patientFile.getId();
            if (l2 != l) continue;
            return patientFile;
        }
        return null;
    }

    public File getQueuedFile() {
        return ScannedImage.getQueuedFile(this.getBatch().getId(), (Long)this.id.get(), (Integer)this.version.get());
    }

    public static File getQueuedFile(long l, long l2, int n) {
        return ScannedImage.getDirectories().scannedImageUploadQueue().file(l + "-" + l2 + "-" + n + ".tiff");
    }

    public String getImageProxyUuid() {
        return "scannedimage-" + this.id.get() + "-" + this.version.get();
    }

    @Override
    public CDLEntity getCDLEntity() {
        return ((ScanBatch)this.batch.get()).getCDLEntity();
    }

    @Override
    public Long getPatientFileId() {
        return (Long)this.patientFileId.get();
    }

    @Override
    public void setPatientFile(PatientFile patientFile) {
        this.patientFileId.set((Object)((Long)patientFile.id.get()));
        this.batch.set((Object)((ScanBatch)patientFile.batch.get()));
    }

    WeakReference<ScannedImageProxy> getScannedImageProxyRef() {
        return this._scannedImageProxyRef;
    }

    void setScannedImageProxyRef(WeakReference<ScannedImageProxy> weakReference) {
        this._scannedImageProxyRef = weakReference;
    }

    public boolean isVisible() {
        boolean bl = this.getStatus() == null || this.getStatus() == Status.Active;
        boolean bl2 = this.getIsOriginalDocument() == null || this.getIsOriginalDocument() == false;
        boolean bl3 = this.getPatientFileId() != null;
        return bl && bl3 && bl2;
    }

    @Override
    public String toString() {
        return ToStringBuilder.toString(this, true, new RProperty[]{this.id, this.batch, this.pageNumber, this.patientFileId});
    }

    private void setVersion(Integer n) {
        this.version.set((Object)n);
    }

    static Directories getDirectories() {
        return (Directories)DependencyInjector.getInstance(Directories.class);
    }

    public Long getId() {
        return (Long)this.id.get();
    }

    public void setId(Long l) {
        this.id.set((Object)l);
    }

    public ScanBatch getBatch() {
        return (ScanBatch)this.batch.get();
    }

    public void setBatch(ScanBatch scanBatch) {
        this.batch.set((Object)scanBatch);
    }

    public void setPatientFileId(Long l) {
        this.patientFileId.set((Object)l);
    }

    public Rotation getRotation() {
        return (Rotation)this.rotation.get();
    }

    public void setRotation(Rotation rotation) {
        this.rotation.set((Object)rotation);
    }

    public Integer getPageNumber() {
        return (Integer)this.pageNumber.get();
    }

    public void setPageNumber(Integer n) {
        this.pageNumber.set((Object)n);
    }

    public void setTotalPages(Integer n) {
        this.totalPages.set((Object)n);
    }

    public DocumentType getDocumentType() {
        return (DocumentType)this.documentType.get();
    }

    public void setDocumentType(DocumentType documentType) {
        this.documentType.set((Object)documentType);
    }

    public Integer getVersion() {
        return (Integer)this.version.get();
    }

    public Boolean getIsOriginalDocument() {
        return (Boolean)this.isOriginalDocument.get();
    }

    public void setIsOriginalDocument(Boolean bl) {
        this.isOriginalDocument.set((Object)bl);
    }

    public String getEncryptionKey() {
        return (String)this.encryptionKey.get();
    }

    public void setEncryptionKey(String string) {
        this.encryptionKey.set((Object)string);
    }

    public Long getOriginalDocument() {
        return (Long)this.originalDocument.get();
    }

    public void setOriginalDocument(Long l) {
        this.originalDocument.set((Object)l);
    }

    public Integer getPageNumberInOriginal() {
        return (Integer)this.pageNumberInOriginal.get();
    }

    public Integer getTotalPages() {
        return (Integer)this.totalPages.get();
    }

    public void setPageNumberInOriginal(Integer n) {
        this.pageNumberInOriginal.set((Object)n);
    }

    public Boolean getUploaded() {
        return (Boolean)this.uploaded.get();
    }

    public void setUploaded(Boolean bl) {
        this.uploaded.set((Object)bl);
    }

    public String getMd5() {
        return (String)this.md5.get();
    }

    public void setMd5(String string) {
        this.md5.set((Object)string);
    }

    public Long getPreviousVersion() {
        return (Long)this.previousVersion.get();
    }

    public void setPreviousVersion(Long l) {
        this.previousVersion.set((Object)l);
    }

    public Long getSize() {
        return (Long)this.size.get();
    }

    public void setSize(Long l) {
        this.size.set((Object)l);
    }

    public String getFileExtension() {
        return (String)this.fileExtension.get();
    }

    public void setFileExtension(String string) {
        this.fileExtension.set((Object)string);
    }

    public String getFileName() {
        return (String)this.fileName.get();
    }

    public void setFileName(String string) {
        this.fileName.set((Object)string);
    }

    public static ScannedImage fetchByPk(Long l) {
        return (ScannedImage)CurrentSession.get().fetchByPK(ScannedImage.class, new Object[]{l});
    }

    public static Query<ScannedImage> select(String string, Object ... objectArray) {
        return CurrentSession.get().select(ScannedImage.class, string, objectArray);
    }

    public static List<ScannedImage> selectAll() {
        return ((ScanningDao)DependencyInjector.getInstance(ScanningDao.class)).selectAll(ScannedImage.class);
    }

    public static ScannedImage fetch(String string, Object ... objectArray) {
        return (ScannedImage)ListX.getFirst(ScannedImage.select(string, objectArray));
    }
}

