/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp;

import com.ahsrcm.corp.BaseBusinessBeanWithAuditTrail;
import com.ahsrcm.corp.BatchType;
import com.ahsrcm.corp.CodingCharge;
import com.ahsrcm.corp.Doctor;
import com.ahsrcm.corp.HasCDLEntity;
import com.ahsrcm.corp.HasPatientFileId;
import com.ahsrcm.corp.Location;
import com.ahsrcm.corp.PatientFile;
import com.ahsrcm.corp.PatientFileTransaction;
import com.ahsrcm.corp.ScannedImage;
import com.ahsrcm.corp.User;
import com.ahsrcm.corp.WorkflowNote;
import com.ahsrcm.corp.beanprops.NotNull;
import com.ahsrcm.corp.cdl.CDLEntity;
import com.ahsrcm.corp.rules.RuleManager;
import com.ahsrcm.corp.rules.Stage;
import com.ahsrcm.scanning.dao.ScanningDao;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.java.dev.properties.LazyProperty;
import net.java.dev.properties.Property;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.RPropertyImpl;
import net.java.dev.properties.annotations.Bidirectional;
import net.java.dev.properties.annotations.Column;
import net.java.dev.properties.annotations.Table;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.BeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.ObservableIndexed;
import net.java.dev.properties.container.ObservableProperty;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.Query;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.newfile.Directory;
import net.model3.util.DateX;

@Table(name="ESPSCNB", prefix="ED", cacheTimeout="0 seconds")
public class ScanBatch
extends BaseBusinessBeanWithAuditTrail<ScanBatch>
implements HasCDLEntity {
    static final int DIR_DIGIT_INCREMENT = 3;
    private static final Log logger = LogHelper.getLog();
    private static final long serialVersionUID = 4926533293962785627L;
    @Column(name="EDSCN", key=true)
    @NotNull
    public final Property<Long> id = ObservableProperty.create();
    @Column(name="EDCMP,EDDIV,EDLOS")
    @NotNull
    public final Property<Location> location = ObservableProperty.create();
    @Column(name="EDDOS")
    @NotNull
    public final Property<Date> dateOfService = ObservableProperty.create((Object)new Date(0L));
    public final transient RProperty<String> dateOfServiceString = new RPropertyImpl<String>(){
        private static final long serialVersionUID = 7984392125308650701L;

        public String get() {
            DateX dateX = new DateX((java.util.Date)ScanBatch.this.dateOfService.get());
            return dateX.getMonth() + "/" + dateX.getDay() + "/" + dateX.getYear();
        }
    };
    @Column(name="\"ED#PG\"")
    @NotNull
    public final Property<Integer> expectedImageCount = ObservableProperty.create((Object)0);
    @Column(name="EDCOM", length=40L)
    @NotNull
    public final Property<String> comment = ObservableProperty.create();
    @Column(name="EDCDR")
    @NotNull
    public final Property<Boolean> codingRequired = ObservableProperty.create((Object)false);
    @Column(name="EDCOD")
    public final Property<User> coder = ObservableProperty.create();
    @Column(name="EDBTP")
    @NotNull
    public final Property<BatchType> batchType = ObservableProperty.create();
    @Column(name="EDSTG")
    @NotNull
    public final Property<Stage> stage = ObservableProperty.create();
    @Column(name="\"ED#GR\"")
    @NotNull
    public final Property<Integer> expectedVisitCount = ObservableProperty.create((Object)0);
    @Bidirectional(value="batch-patientFiles", parent=true)
    public final ObservableIndexed<PatientFile> patientFiles = ObservableIndexed.create();
    @Column(name="!EDCMP,!EDDIV,EDDR")
    public final Property<Doctor> doctor = ObservableProperty.create();
    @Bidirectional(value="batch-images", parent=true)
    private final ObservableIndexed<ScannedImage> images = ObservableIndexed.create();
    @Bidirectional(value="batch-notes", parent=true)
    private final ObservableIndexed<WorkflowNote> notes = ObservableIndexed.create();
    @Bidirectional(value="batch-transactions", parent=true)
    public final ObservableIndexed<PatientFileTransaction> transactions = ObservableIndexed.create();
    @Bidirectional(value="batch-charges", parent=true)
    private final ObservableIndexed<CodingCharge> charges = ObservableIndexed.create();
    public final transient Property<RuleManager> ruleManager = new LazyProperty<RuleManager>(){
        private static final long serialVersionUID = -5528477151062325994L;

        public RuleManager init() {
            RuleManager ruleManager = new RuleManager(((Location)ScanBatch.this.location.get()).getCDLEntity(), (BatchType)ScanBatch.this.batchType.get());
            ruleManager.getRuleSet().rules.set(ruleManager.getRules());
            ruleManager.setScanBatch(ScanBatch.this);
            return ruleManager;
        }
    };
    public static final BeanContext $BeanContext = (BeanContext)BeanContainer.get().getContext(ScanBatch.class);
    public static final IPropertyContext $visualId = $BeanContext.getProperty("visualId");
    public static final IPropertyContext $creationUser = $BeanContext.getProperty("creationUser");
    public static final IPropertyContext $creationDate = $BeanContext.getProperty("creationDate");
    public static final IPropertyContext $creationTime = $BeanContext.getProperty("creationTime");
    public static final IPropertyContext $lastChangeUser = $BeanContext.getProperty("lastChangeUser");
    public static final IPropertyContext $lastChangeDate = $BeanContext.getProperty("lastChangeDate");
    public static final IPropertyContext $lastChangeTime = $BeanContext.getProperty("lastChangeTime");
    public static final IPropertyContext $creationTimestamp = $BeanContext.getProperty("creationTimestamp");
    public static final IPropertyContext $lastChangeTimestamp = $BeanContext.getProperty("lastChangeTimestamp");
    public static final IPropertyContext $id = $BeanContext.getProperty("id");
    public static final IPropertyContext $location = $BeanContext.getProperty("location");
    public static final IPropertyContext $dateOfService = $BeanContext.getProperty("dateOfService");
    public static final IPropertyContext $dateOfServiceString = $BeanContext.getProperty("dateOfServiceString");
    public static final IPropertyContext $expectedImageCount = $BeanContext.getProperty("expectedImageCount");
    public static final IPropertyContext $comment = $BeanContext.getProperty("comment");
    public static final IPropertyContext $codingRequired = $BeanContext.getProperty("codingRequired");
    public static final IPropertyContext $coder = $BeanContext.getProperty("coder");
    public static final IPropertyContext $batchType = $BeanContext.getProperty("batchType");
    public static final IPropertyContext $stage = $BeanContext.getProperty("stage");
    public static final IPropertyContext $expectedVisitCount = $BeanContext.getProperty("expectedVisitCount");
    public static final IPropertyContext $patientFiles = $BeanContext.getProperty("patientFiles");
    public static final IPropertyContext $doctor = $BeanContext.getProperty("doctor");
    public static final IPropertyContext $images = $BeanContext.getProperty("images");
    public static final IPropertyContext $notes = $BeanContext.getProperty("notes");
    public static final IPropertyContext $transactions = $BeanContext.getProperty("transactions");
    public static final IPropertyContext $charges = $BeanContext.getProperty("charges");
    public static final IPropertyContext $ruleManager = $BeanContext.getProperty("ruleManager");
    public static final ScanBatch Meta = new ScanBatch();

    public ScanBatch() {
        BeanContainer.bind((Object)this);
    }

    public static Directory getImageDirectory(long l, Directory directory, boolean bl) {
        Directory directory2 = new Directory(directory, ScanBatch.getImagePath(l));
        if (bl) {
            directory2.makeDirectories();
        }
        return directory2;
    }

    public static String getImagePath(long l) {
        StringBuilder stringBuilder;
        String string = String.valueOf(l);
        int n = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (string.length() > 0) {
            stringBuilder = new StringBuilder(string);
            for (int i = string.length(); i < n; ++i) {
                stringBuilder.append("x");
            }
            arrayList.add(0, stringBuilder.toString() + "/");
            string = string.substring(0, string.length() - 3 > 0 ? string.length() - 3 : 0);
        }
        stringBuilder = new StringBuilder();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append((String)iterator.next());
        }
        return stringBuilder.toString();
    }

    public PatientFile addPatientFile() {
        PatientFile patientFile = new PatientFile();
        patientFile.id.set((Object)((ScanningDao)ScanningDao.Impl.get()).nextControlNumber(PatientFile.class));
        logger.debug((Object)"Setting the scan batch on patient file | {}", patientFile.id.get());
        patientFile.batch.set((Object)this);
        logger.debug((Object)"Patient File after batch.set | {}", (Object)patientFile);
        patientFile.stage.set((Object)Stage.ScanningInProgress.get());
        ((ScanningDao)ScanningDao.Impl.get()).insert(patientFile);
        logger.trace((Object)"Patient File {} added. Size now {}.", patientFile.id.get(), (Object)this.patientFiles.size());
        return patientFile;
    }

    public int nextPageNumber() {
        int n = 0;
        for (ScannedImage scannedImage : this.images) {
            if (scannedImage.getIsOriginalDocument().booleanValue() || (Integer)scannedImage.pageNumber.get() <= n) continue;
            n = (Integer)scannedImage.pageNumber.get();
        }
        return n + 1;
    }

    public synchronized PatientFile getLastVisit() {
        if (this.patientFiles.size() == 0) {
            this.addPatientFile();
        }
        logger.trace((Object)"ScanBatch {} current size of patientFiles is {}", this.id.get(), (Object)this.patientFiles.size());
        return (PatientFile)this.patientFiles.get(this.patientFiles.size() - 1);
    }

    @Override
    public CDLEntity getCDLEntity() {
        return ((Location)this.location.get()).getCDLEntity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends HasPatientFileId> void doAdd(ObservableIndexed<T> observableIndexed, T t) {
        if (t.getPatientFileId() == null || t.getPatientFileId().equals(new Long(0L))) {
            logger.error((Object)"adding object without a patient file id  t = {}", t);
        }
        ObservableIndexed<T> observableIndexed2 = observableIndexed;
        synchronized (observableIndexed2) {
            logger.debug((Object)"ScanBatch {} added  t = {}", this.id.get(), t);
            observableIndexed.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void doRemove(ObservableIndexed<T> observableIndexed, T t) {
        ObservableIndexed<T> observableIndexed2 = observableIndexed;
        synchronized (observableIndexed2) {
            logger.debug((Object)"scanbatch = {} removed  t = {}", this.id.get(), t);
            observableIndexed.remove(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> List<T> doGet(ObservableIndexed<T> observableIndexed) {
        ObservableIndexed<T> observableIndexed2 = observableIndexed;
        synchronized (observableIndexed2) {
            return ListX.create((Iterable)observableIndexed.get());
        }
    }

    public void addCharge(CodingCharge codingCharge) {
        this.doAdd(this.charges, codingCharge);
    }

    public void removeCharge(CodingCharge codingCharge) {
        this.doRemove(this.charges, codingCharge);
    }

    public List<CodingCharge> getCharges() {
        return this.doGet(this.charges);
    }

    public void addImage(ScannedImage scannedImage) {
        this.doAdd(this.images, scannedImage);
    }

    public void removeImage(ScannedImage scannedImage) {
        this.doRemove(this.images, scannedImage);
    }

    public List<ScannedImage> getAllImages() {
        return this.doGet(this.images);
    }

    public List<ScannedImage> getVisibleImages() {
        List list = ListX.create();
        for (ScannedImage scannedImage : this.doGet(this.images)) {
            if (!scannedImage.isVisible()) continue;
            list.add(scannedImage);
        }
        return list;
    }

    public int getVisibleImageCount() {
        int n = 0;
        for (ScannedImage scannedImage : this.doGet(this.images)) {
            if (!scannedImage.isActive()) continue;
            ++n;
        }
        return n;
    }

    public void addNote(WorkflowNote workflowNote) {
        this.doAdd(this.notes, workflowNote);
    }

    public void removeNote(WorkflowNote workflowNote) {
        this.doRemove(this.notes, workflowNote);
    }

    public List<WorkflowNote> getNotes() {
        return this.doGet(this.notes);
    }

    public Long getId() {
        return (Long)this.id.get();
    }

    public void setId(Long l) {
        this.id.set((Object)l);
    }

    public Location getLocation() {
        return (Location)this.location.get();
    }

    public void setLocation(Location location) {
        this.location.set((Object)location);
    }

    public Date getDateOfService() {
        return (Date)this.dateOfService.get();
    }

    public void setDateOfService(Date date) {
        this.dateOfService.set((Object)date);
    }

    public String getDateOfServiceString() {
        return (String)this.dateOfServiceString.get();
    }

    public Integer getExpectedImageCount() {
        return (Integer)this.expectedImageCount.get();
    }

    public void setExpectedImageCount(Integer n) {
        this.expectedImageCount.set((Object)n);
    }

    public String getComment() {
        return (String)this.comment.get();
    }

    public void setComment(String string) {
        this.comment.set((Object)string);
    }

    public Boolean getCodingRequired() {
        return (Boolean)this.codingRequired.get();
    }

    public void setCodingRequired(Boolean bl) {
        this.codingRequired.set((Object)bl);
    }

    public User getCoder() {
        return (User)this.coder.get();
    }

    public void setCoder(User user) {
        this.coder.set((Object)user);
    }

    public BatchType getBatchType() {
        return (BatchType)this.batchType.get();
    }

    public void setBatchType(BatchType batchType) {
        this.batchType.set((Object)batchType);
    }

    public Stage getStage() {
        return (Stage)this.stage.get();
    }

    public void setStage(Stage stage) {
        this.stage.set((Object)stage);
    }

    public Integer getExpectedVisitCount() {
        return (Integer)this.expectedVisitCount.get();
    }

    public void setExpectedVisitCount(Integer n) {
        this.expectedVisitCount.set((Object)n);
    }

    public List<PatientFile> getPatientFiles() {
        return this.patientFiles.get();
    }

    public void setPatientFiles(List<PatientFile> list) {
        this.patientFiles.set(list);
    }

    public Doctor getDoctor() {
        return (Doctor)this.doctor.get();
    }

    public void setDoctor(Doctor doctor) {
        this.doctor.set((Object)doctor);
    }

    public void setImages(List<ScannedImage> list) {
        this.images.set(list);
    }

    public void setNotes(List<WorkflowNote> list) {
        this.notes.set(list);
    }

    public List<PatientFileTransaction> getTransactions() {
        return this.transactions.get();
    }

    public void setTransactions(List<PatientFileTransaction> list) {
        this.transactions.set(list);
    }

    public void setCharges(List<CodingCharge> list) {
        this.charges.set(list);
    }

    public RuleManager getRuleManager() {
        return (RuleManager)this.ruleManager.get();
    }

    public void setRuleManager(RuleManager ruleManager) {
        this.ruleManager.set((Object)ruleManager);
    }

    public static ScanBatch fetchByPk(Long l) {
        return (ScanBatch)CurrentSession.get().fetchByPK(ScanBatch.class, new Object[]{l});
    }

    public static Query<ScanBatch> select(String string, Object ... objectArray) {
        return CurrentSession.get().select(ScanBatch.class, string, objectArray);
    }

    public static List<ScanBatch> selectAll() {
        return ((ScanningDao)DependencyInjector.getInstance(ScanningDao.class)).selectAll(ScanBatch.class);
    }

    public static ScanBatch fetch(String string, Object ... objectArray) {
        return (ScanBatch)ListX.getFirst(ScanBatch.select(string, objectArray));
    }
}

