/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp;

import com.ahsrcm.core.scanning.gui.ImageProxy;
import com.ahsrcm.corp.BaseBusinessBeanWithAuditTrail;
import com.ahsrcm.corp.CodingCharge;
import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Database;
import com.ahsrcm.corp.Division;
import com.ahsrcm.corp.HasCDLEntity;
import com.ahsrcm.corp.HasPatientFileId;
import com.ahsrcm.corp.Location;
import com.ahsrcm.corp.PatientFileTransaction;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.ScannedImage;
import com.ahsrcm.corp.User;
import com.ahsrcm.corp.WorkflowNote;
import com.ahsrcm.corp.WorkflowNoteType;
import com.ahsrcm.corp.beanprops.NotNull;
import com.ahsrcm.corp.cdl.CDLEntity;
import com.ahsrcm.corp.rules.Rule;
import com.ahsrcm.corp.rules.RuleManager;
import com.ahsrcm.corp.rules.Stage;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.ahsrcm.util.ToStringBuilder;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import net.java.dev.properties.Property;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.RPropertyImpl;
import net.java.dev.properties.annotations.Bidirectional;
import net.java.dev.properties.annotations.Column;
import net.java.dev.properties.annotations.Table;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.BeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.ObservableProperty;
import net.java.dev.properties.container.PropertyContextable;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.Query;
import net.java.dev.properties.jdbc.QueryForString;
import net.java.dev.properties.util.BeanComparator;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.StringX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;

@Table(name="ESPSCNPH", prefix="EV", cacheTimeout="0 seconds")
public class PatientFile
extends BaseBusinessBeanWithAuditTrail<PatientFile>
implements HasCDLEntity {
    private static final Log logger = LogHelper.getLog();
    private static final long serialVersionUID = -7543384940083212458L;
    @Column(suffix="SGR", key=true)
    public final Property<Long> id = ObservableProperty.create();
    @Column(suffix="SCN")
    @Bidirectional(value="batch-patientFiles")
    public final Property<ScanBatch> batch = ObservableProperty.create();
    @Column(name="EVPAT", length=12L)
    public final Property<String> patientNumber = ObservableProperty.create();
    public final transient RProperty<String> patientFullName = new RPropertyImpl<String>(){
        private static final long serialVersionUID = 7984392125308650701L;

        public String get() {
            return StringX.combineNameParts((String)((String)PatientFile.this.patientLastName.get()), (String)((String)PatientFile.this.patientFirstName.get()), (String)((String)PatientFile.this.patientMiddleName.get()));
        }
    };
    @Column(name="EVFNM", length=10L)
    public final Property<String> patientFirstName = ObservableProperty.create();
    @Column(name="EVLNM", length=20L)
    public final Property<String> patientLastName = ObservableProperty.create();
    @Column(name="EVMNM", length=1L)
    public final Property<String> patientMiddleName = ObservableProperty.create();
    @Column(name="!EVCASE")
    @NotNull
    public final Property<Long> caseNumber = ObservableProperty.create((Object)0L);
    @Column(name="EVENC1")
    @NotNull
    public final Property<Long> encounter = ObservableProperty.create((Object)0L);
    @Column(name="!EVENC2")
    @NotNull
    public final Property<Long> splitEnc = ObservableProperty.create((Object)0L);
    @Column(suffix="STG")
    public final Property<Stage> stage = ObservableProperty.create();
    @Column(suffix="CODR")
    public final Property<User> coder = ObservableProperty.create();
    @Column(suffix="RWRK")
    public final Property<User> reworker = ObservableProperty.create();
    @Column(suffix="DUSR")
    public final Property<User> dataEntryUser = ObservableProperty.create();
    public static final BeanContext $BeanContext = (BeanContext)BeanContainer.get().getContext(PatientFile.class);
    public static final IPropertyContext $visualId = $BeanContext.getProperty("visualId");
    public static final IPropertyContext $creationUser = $BeanContext.getProperty("creationUser");
    public static final IPropertyContext $creationDate = $BeanContext.getProperty("creationDate");
    public static final IPropertyContext $creationTime = $BeanContext.getProperty("creationTime");
    public static final IPropertyContext $lastChangeUser = $BeanContext.getProperty("lastChangeUser");
    public static final IPropertyContext $lastChangeDate = $BeanContext.getProperty("lastChangeDate");
    public static final IPropertyContext $lastChangeTime = $BeanContext.getProperty("lastChangeTime");
    public static final IPropertyContext $creationTimestamp = $BeanContext.getProperty("creationTimestamp");
    public static final IPropertyContext $lastChangeTimestamp = $BeanContext.getProperty("lastChangeTimestamp");
    public static final IPropertyContext $id = $BeanContext.getProperty("id");
    public static final IPropertyContext $batch = $BeanContext.getProperty("batch");
    public static final IPropertyContext $patientNumber = $BeanContext.getProperty("patientNumber");
    public static final IPropertyContext $patientFullName = $BeanContext.getProperty("patientFullName");
    public static final IPropertyContext $patientFirstName = $BeanContext.getProperty("patientFirstName");
    public static final IPropertyContext $patientLastName = $BeanContext.getProperty("patientLastName");
    public static final IPropertyContext $patientMiddleName = $BeanContext.getProperty("patientMiddleName");
    public static final IPropertyContext $caseNumber = $BeanContext.getProperty("caseNumber");
    public static final IPropertyContext $encounter = $BeanContext.getProperty("encounter");
    public static final IPropertyContext $splitEnc = $BeanContext.getProperty("splitEnc");
    public static final IPropertyContext $stage = $BeanContext.getProperty("stage");
    public static final IPropertyContext $coder = $BeanContext.getProperty("coder");
    public static final IPropertyContext $reworker = $BeanContext.getProperty("reworker");
    public static final IPropertyContext $dataEntryUser = $BeanContext.getProperty("dataEntryUser");
    public static final PatientFile Meta = new PatientFile();

    public PatientFile() {
        BeanContainer.bind((Object)this);
    }

    public Rule currentRule() {
        return this.getRuleManager().getRule((Stage)this.stage.get());
    }

    public RuleManager getRuleManager() {
        return (RuleManager)((ScanBatch)this.batch.get()).ruleManager.get();
    }

    <T extends HasPatientFileId> List<T> getInstances(List<T> list) {
        List list2 = ListX.create();
        Long l = (Long)this.id.get();
        for (HasPatientFileId hasPatientFileId : list) {
            Long l2 = hasPatientFileId.getPatientFileId();
            if (l2 == null || !l2.equals(l)) continue;
            list2.add(hasPatientFileId);
        }
        return list2;
    }

    public List<ScannedImage> getVisibleImages() {
        return this.getInstances(((ScanBatch)this.batch.get()).getVisibleImages());
    }

    public List<ScannedImage> getAllImages() {
        return this.getInstances(((ScanBatch)this.batch.get()).getAllImages());
    }

    public List<WorkflowNote> getNotes() {
        return this.getInstances(((ScanBatch)this.batch.get()).getNotes());
    }

    public List<PatientFileTransaction> getTransactions() {
        return this.getInstances(((ScanBatch)this.batch.get()).transactions.get());
    }

    public List<CodingCharge> getCharges() {
        return this.getInstances(((ScanBatch)this.batch.get()).getCharges());
    }

    public List<ImageProxy> getVisibleImageProxies() {
        List list = ListX.create();
        List<ScannedImage> list2 = this.getVisibleImages();
        Collections.sort(list2, BeanComparator.create((PropertyContextable[])new PropertyContextable[]{ScannedImage.Meta.pageNumber}));
        for (ScannedImage scannedImage : list2) {
            list.add(scannedImage.getImageProxy());
        }
        return list;
    }

    public ScannedImage newScannedImage(boolean bl) {
        int n = ((ScanBatch)this.batch.get()).nextPageNumber();
        logger.trace((Object)"Page number is {}", (Object)n);
        ScannedImage scannedImage = new ScannedImage();
        scannedImage.id.set((Object)((ScanningDao)ScanningDao.Impl.get()).nextControlNumber(ScannedImage.class));
        scannedImage.patientFileId.set((Object)((Long)this.id.get()));
        scannedImage.pageNumber.set((Object)n);
        scannedImage.batch.set((Object)((ScanBatch)this.batch.get()));
        if (bl) {
            ((ScanningDao)ScanningDao.Impl.get()).insert(scannedImage);
        }
        return scannedImage;
    }

    public WorkflowNote addNote(String string, WorkflowNoteType workflowNoteType, int n) {
        WorkflowNote workflowNote = new WorkflowNote(this);
        workflowNote.sequence.set((Object)n);
        workflowNote.type.set((Object)workflowNoteType);
        workflowNote.text.set((Object)string);
        return workflowNote;
    }

    public int getMaxChargeSequence() {
        int n = 0;
        for (CodingCharge codingCharge : this.getCharges()) {
            n = Math.max((Integer)codingCharge.sequence.get(), n);
        }
        return n;
    }

    public int getMaxNoteSequence() {
        int n = 0;
        for (WorkflowNote workflowNote : this.getNotes()) {
            n = Math.max((Integer)workflowNote.sequence.get(), n);
        }
        return n;
    }

    public void updateStage(Stage stage, User user) {
        if (stage == null) {
            return;
        }
        this.stage.set((Object)stage);
        if (stage.equals(Stage.CodingQueue.get())) {
            this.coder.set((Object)user);
        } else if (stage.equals(Stage.DataEntryQueue.get())) {
            this.dataEntryUser.set((Object)user);
        } else if (stage.equals(Stage.IndexDocuments.get()) || stage.equals(Stage.ReworkIn.get()) || stage.equals(Stage.ReworkOut.get()) || stage.equals(Stage.ScanningInProgress.get()) || stage.equals(Stage.Concurrency.get())) {
            this.reworker.set((Object)user);
        }
    }

    public Database getDatabase() {
        return (Database)this.getCompany().database.get();
    }

    public Company getCompany() {
        ScanBatch scanBatch = null;
        Location location = null;
        Division division = null;
        try {
            scanBatch = (ScanBatch)this.batch.get();
            location = (Location)scanBatch.location.get();
            division = (Division)location.division.get();
            return (Company)division.company.get();
        }
        catch (NullPointerException nullPointerException) {
            logger.debug((Object)"NPE getting company", (Object)nullPointerException);
            return null;
        }
    }

    @Override
    public String getVisualId() {
        return ((Long)this.id.get()).toString() + " - " + (String)((Stage)this.stage.get()).id.get();
    }

    @Override
    public String toString() {
        return ToStringBuilder.toString(this, false, new RProperty[]{this.id, this.batch});
    }

    public void scheduleImageDownloading() {
        for (ScannedImage scannedImage : this.getVisibleImages()) {
            scannedImage.getImageProxy().scheduleDownload();
        }
    }

    @Override
    public CDLEntity getCDLEntity() {
        return ((ScanBatch)this.batch.get()).getCDLEntity();
    }

    public String getAccessionNumber() {
        return (String)new QueryForString("select EXACC from ESPINTE where EXSGR = ?"){

            protected void prepareQuery() throws SQLException {
                this.getStatement().setLong(1, (Long)PatientFile.this.id.get());
            }
        }.getResult();
    }

    public Long getId() {
        return (Long)this.id.get();
    }

    public void setId(Long l) {
        this.id.set((Object)l);
    }

    public ScanBatch getBatch() {
        return (ScanBatch)this.batch.get();
    }

    public void setBatch(ScanBatch scanBatch) {
        this.batch.set((Object)scanBatch);
    }

    public String getPatientNumber() {
        return (String)this.patientNumber.get();
    }

    public void setPatientNumber(String string) {
        this.patientNumber.set((Object)string);
    }

    public String getPatientFullName() {
        return (String)this.patientFullName.get();
    }

    public String getPatientFirstName() {
        return (String)this.patientFirstName.get();
    }

    public void setPatientFirstName(String string) {
        this.patientFirstName.set((Object)string);
    }

    public String getPatientLastName() {
        return (String)this.patientLastName.get();
    }

    public void setPatientLastName(String string) {
        this.patientLastName.set((Object)string);
    }

    public String getPatientMiddleName() {
        return (String)this.patientMiddleName.get();
    }

    public void setPatientMiddleName(String string) {
        this.patientMiddleName.set((Object)string);
    }

    public Long getCaseNumber() {
        return (Long)this.caseNumber.get();
    }

    public void setCaseNumber(Long l) {
        this.caseNumber.set((Object)l);
    }

    public Long getEncounter() {
        return (Long)this.encounter.get();
    }

    public void setEncounter(Long l) {
        this.encounter.set((Object)l);
    }

    public Long getSplitEnc() {
        return (Long)this.splitEnc.get();
    }

    public void setSplitEnc(Long l) {
        this.splitEnc.set((Object)l);
    }

    public Stage getStage() {
        return (Stage)this.stage.get();
    }

    public void setStage(Stage stage) {
        this.stage.set((Object)stage);
    }

    public User getCoder() {
        return (User)this.coder.get();
    }

    public void setCoder(User user) {
        this.coder.set((Object)user);
    }

    public User getReworker() {
        return (User)this.reworker.get();
    }

    public void setReworker(User user) {
        this.reworker.set((Object)user);
    }

    public User getDataEntryUser() {
        return (User)this.dataEntryUser.get();
    }

    public void setDataEntryUser(User user) {
        this.dataEntryUser.set((Object)user);
    }

    public static PatientFile fetchByPk(Long l) {
        return (PatientFile)CurrentSession.get().fetchByPK(PatientFile.class, new Object[]{l});
    }

    public static Query<PatientFile> select(String string, Object ... objectArray) {
        return CurrentSession.get().select(PatientFile.class, string, objectArray);
    }

    public static List<PatientFile> selectAll() {
        return ((ScanningDao)DependencyInjector.getInstance(ScanningDao.class)).selectAll(PatientFile.class);
    }

    public static PatientFile fetch(String string, Object ... objectArray) {
        return (PatientFile)ListX.getFirst(PatientFile.select(string, objectArray));
    }
}

