/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp;

import com.ahsrcm.corp.BaseBusinessBean;
import com.ahsrcm.corp.HasUser;
import com.ahsrcm.corp.SecurityToken;
import com.ahsrcm.corp.SingleSignOnSession;
import com.ahsrcm.corp.User;
import com.ahsrcm.corp.beanprops.LazyUid80Property;
import com.ahsrcm.scanning.app.server.ServerAppConfig;
import com.ahsrcm.scanning.dao.ScanningDao;
import java.util.List;
import java.util.Set;
import net.java.dev.properties.Property;
import net.java.dev.properties.annotations.Column;
import net.java.dev.properties.annotations.Table;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.BeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.ObservableProperty;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.Query;
import net.model3.chrono.DateTime;
import net.model3.collections.ListX;
import net.model3.collections.SetX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.StringX;
import net.model3.lang.TimeDuration;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.util.Tokenizer;

@Table(name="ESPSESSION", prefix="ES", cacheTimeout="10 minutes")
public class Login
extends BaseBusinessBean<Login>
implements HasUser {
    private static Logger logger = LoggerHelper.getLogger();
    private static TimeDuration _defaultSessionDuration = new TimeDuration("6 hours");
    private static TimeDuration _sessionNoUpdateWindow;
    private static final long serialVersionUID = 7425019824620206537L;
    @Column(suffix="SES", key=true, length=80L)
    public final Property<String> id = new LazyUid80Property();
    @Column(suffix="TYP", length=3L)
    public final Property<String> type = ObservableProperty.create();
    @Column(suffix="USR")
    public final Property<User> user = ObservableProperty.create();
    @Column(suffix="DATC")
    public final Property<DateTime> created = ObservableProperty.create();
    @Column(suffix="DATL")
    public final Property<DateTime> lastChange = ObservableProperty.create();
    @Column(suffix="DATE")
    public final Property<DateTime> expires = ObservableProperty.create();
    @Column(suffix="DATEXT", sqlType=1, length=10L)
    public final Property<String> expiresExtension = ObservableProperty.create();
    @Column(suffix="SVR", sqlType=12, length=512L)
    private final Property<String> servers = ObservableProperty.create((Object)"");
    @Column(suffix="TYPD", length=50L)
    public final Property<String> description = ObservableProperty.create();
    transient Set<String> _serversSet;
    public static final BeanContext $BeanContext;
    public static final IPropertyContext $visualId;
    public static final IPropertyContext $id;
    public static final IPropertyContext $type;
    public static final IPropertyContext $user;
    public static final IPropertyContext $created;
    public static final IPropertyContext $lastChange;
    public static final IPropertyContext $expires;
    public static final IPropertyContext $expiresExtension;
    public static final IPropertyContext $servers;
    public static final IPropertyContext $description;
    public static final Login Meta;

    static TimeDuration getSessionNoUpdateWindow() {
        if (_sessionNoUpdateWindow == null) {
            ServerAppConfig serverAppConfig = (ServerAppConfig)((Object)DependencyInjector.get().getInstance(ServerAppConfig.class));
            _sessionNoUpdateWindow = serverAppConfig.getSessionNoUpdateWindow();
        }
        return _sessionNoUpdateWindow;
    }

    public Login() {
        BeanContainer.bind((Object)this);
    }

    public Login(SingleSignOnSession singleSignOnSession) {
        BeanContainer.bind((Object)this);
        this.id.set((Object)((String)singleSignOnSession.sessionId.get()));
        this.type.set((Object)"EAX");
        this.user.set((Object)((User)singleSignOnSession.user.get()));
        this.updateExpires();
    }

    Login(SecurityToken securityToken) {
        BeanContainer.bind((Object)this);
        this.id.set((Object)((String)securityToken.token.get()));
        User user = User.fetchByLoginOrId((String)securityToken.userId.get());
        if (user == null) {
            throw new RuntimeException("cannot find a user for ESPTOKEN.ESUSR = " + (String)securityToken.userId.get() + " token = " + (String)securityToken.token.get());
        }
        this.user.set((Object)user);
        this.type.set((Object)"TOK");
        DateTime dateTime = new DateTime();
        this.created.set((Object)dateTime);
        this.updateExpiration();
    }

    @Override
    public void preInsert() {
        super.preInsert();
        if (this.created.get() == null) {
            this.created.set((Object)new DateTime());
            this.lastChange.set((Object)((DateTime)this.created.get()));
        }
    }

    public TimeDuration getSessionDuration() {
        TimeDuration timeDuration = _defaultSessionDuration;
        String string = (String)this.expiresExtension.get();
        if (StringX.isNotBlank((String)string)) {
            try {
                timeDuration = new TimeDuration(string);
            }
            catch (Exception exception) {
                logger.error((Object)"invalid session extension '{}' in {}", (Object)string, (Object)this);
            }
        }
        return timeDuration;
    }

    private void updateExpires() {
        DateTime dateTime = new DateTime();
        DateTime dateTime2 = dateTime.add(this.getSessionDuration());
        if (this.expires.get() == null || dateTime2.after((DateTime)this.expires.get())) {
            this.expires.set((Object)dateTime2);
            this.lastChange.set((Object)dateTime);
        }
    }

    public void updateExpiration() {
        DateTime dateTime = new DateTime().subtract(Login.getSessionNoUpdateWindow());
        if (this.lastChange.get() == null || ((DateTime)this.lastChange.get()).before(dateTime)) {
            this.updateExpires();
            this.lastChange.set((Object)new DateTime());
            SingleSignOnSession singleSignOnSession = SingleSignOnSession.fetchByPk((String)this.id.get());
            if (singleSignOnSession != null) {
                singleSignOnSession.updateLastRequest();
            }
        }
    }

    private String getServers() {
        return (String)this.servers.get();
    }

    private void setServers(String string) {
        this.servers.set((Object)string);
    }

    Set<String> getServersUsed() {
        if (this._serversSet == null) {
            this._serversSet = SetX.create((Object[])new Tokenizer(this.getServers(), ":").getAllTokens());
        }
        return this._serversSet;
    }

    public void addServer(String string) {
        if (StringX.isNotBlank((String)string)) {
            String string2 = string.trim();
            Set<String> set = this.getServersUsed();
            if (!set.contains(string2)) {
                set.add(string2);
                this.setServers(":" + StringX.join(set, (String)":") + ":");
            }
        }
    }

    public boolean isStillValid() {
        return ((DateTime)this.expires.get()).isInTheFuture();
    }

    @Override
    public User getUser() {
        return (User)this.user.get();
    }

    public String getId() {
        return (String)this.id.get();
    }

    public void setId(String string) {
        this.id.set((Object)string);
    }

    public String getType() {
        return (String)this.type.get();
    }

    public void setType(String string) {
        this.type.set((Object)string);
    }

    public void setUser(User user) {
        this.user.set((Object)user);
    }

    public DateTime getCreated() {
        return (DateTime)this.created.get();
    }

    public void setCreated(DateTime dateTime) {
        this.created.set((Object)dateTime);
    }

    public DateTime getLastChange() {
        return (DateTime)this.lastChange.get();
    }

    public void setLastChange(DateTime dateTime) {
        this.lastChange.set((Object)dateTime);
    }

    public DateTime getExpires() {
        return (DateTime)this.expires.get();
    }

    public void setExpires(DateTime dateTime) {
        this.expires.set((Object)dateTime);
    }

    public String getExpiresExtension() {
        return (String)this.expiresExtension.get();
    }

    public void setExpiresExtension(String string) {
        this.expiresExtension.set((Object)string);
    }

    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String string) {
        this.description.set((Object)string);
    }

    public static Login fetchByPk(String string) {
        return (Login)CurrentSession.get().fetchByPK(Login.class, new Object[]{string});
    }

    public static Query<Login> select(String string, Object ... objectArray) {
        return CurrentSession.get().select(Login.class, string, objectArray);
    }

    public static List<Login> selectAll() {
        return ((ScanningDao)DependencyInjector.getInstance(ScanningDao.class)).selectAll(Login.class);
    }

    public static Login fetch(String string, Object ... objectArray) {
        return (Login)ListX.getFirst(Login.select(string, objectArray));
    }

    static {
        $BeanContext = (BeanContext)BeanContainer.get().getContext(Login.class);
        $visualId = $BeanContext.getProperty("visualId");
        $id = $BeanContext.getProperty("id");
        $type = $BeanContext.getProperty("type");
        $user = $BeanContext.getProperty("user");
        $created = $BeanContext.getProperty("created");
        $lastChange = $BeanContext.getProperty("lastChange");
        $expires = $BeanContext.getProperty("expires");
        $expiresExtension = $BeanContext.getProperty("expiresExtension");
        $servers = $BeanContext.getProperty("servers");
        $description = $BeanContext.getProperty("description");
        Meta = new Login();
    }
}

