/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp;

import com.ahsrcm.corp.BaseBusinessBeanWithStatus;
import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Database;
import com.ahsrcm.corp.Doctor;
import com.ahsrcm.corp.HasCDLEntity;
import com.ahsrcm.corp.Location;
import com.ahsrcm.corp.beanprops.NotNull;
import com.ahsrcm.corp.cdl.CDLEntity;
import com.ahsrcm.corp.cdl.CDLFactory;
import com.ahsrcm.corp.orm.Status;
import com.ahsrcm.scanning.dao.ScanningDao;
import java.util.List;
import net.java.dev.properties.Property;
import net.java.dev.properties.annotations.Bidirectional;
import net.java.dev.properties.annotations.Column;
import net.java.dev.properties.annotations.Table;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.BeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.ObservableIndexed;
import net.java.dev.properties.container.ObservableProperty;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.Query;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;

@Table(name="ESPDIV", prefix="EC", useDirtyChecking=false)
public class Division
extends BaseBusinessBeanWithStatus<Division>
implements HasCDLEntity {
    private static final long serialVersionUID = 2391370789530349439L;
    @Column(name="ECCMP", key=true)
    @Bidirectional(value="company-divisions")
    public final Property<Company> company = ObservableProperty.create();
    @Column(name="ECDIV", key=true, length=4L)
    @NotNull
    public final Property<String> id = new ObservableProperty();
    @Bidirectional(value="division-locations", parent=true)
    public final ObservableIndexed<Location> locations = ObservableIndexed.create();
    @Bidirectional(value="division-doctors", parent=true)
    public final ObservableIndexed<Doctor> doctors = ObservableIndexed.create();
    @Column(name="ECNAMD", length=40L)
    @NotNull
    public final Property<String> name = new ObservableProperty();
    public static final BeanContext $BeanContext = (BeanContext)BeanContainer.get().getContext(Division.class);
    public static final IPropertyContext $visualId = $BeanContext.getProperty("visualId");
    public static final IPropertyContext $creationUser = $BeanContext.getProperty("creationUser");
    public static final IPropertyContext $creationDate = $BeanContext.getProperty("creationDate");
    public static final IPropertyContext $creationTime = $BeanContext.getProperty("creationTime");
    public static final IPropertyContext $lastChangeUser = $BeanContext.getProperty("lastChangeUser");
    public static final IPropertyContext $lastChangeDate = $BeanContext.getProperty("lastChangeDate");
    public static final IPropertyContext $lastChangeTime = $BeanContext.getProperty("lastChangeTime");
    public static final IPropertyContext $creationTimestamp = $BeanContext.getProperty("creationTimestamp");
    public static final IPropertyContext $lastChangeTimestamp = $BeanContext.getProperty("lastChangeTimestamp");
    public static final IPropertyContext $status = $BeanContext.getProperty("status");
    public static final IPropertyContext $company = $BeanContext.getProperty("company");
    public static final IPropertyContext $id = $BeanContext.getProperty("id");
    public static final IPropertyContext $locations = $BeanContext.getProperty("locations");
    public static final IPropertyContext $doctors = $BeanContext.getProperty("doctors");
    public static final IPropertyContext $name = $BeanContext.getProperty("name");
    public static final Division Meta = new Division();

    public Division() {
        BeanContainer.bind((Object)this);
    }

    @Override
    public String getVisualId() {
        return (String)this.id.get() + " - " + ((String)this.name.get()).trim();
    }

    @Override
    public CDLEntity getCDLEntity() {
        return CDLFactory.get().getCDL(this);
    }

    public Database getDatabase() {
        return (Database)((Company)this.company.get()).database.get();
    }

    public List<Doctor> getActiveDoctors() {
        List list = ListX.create();
        for (Doctor doctor : this.doctors.get()) {
            if (doctor.status.get() == Status.Inactive) continue;
            list.add(doctor);
        }
        return list;
    }

    public List<Location> getActiveLocations() {
        List list = ListX.create();
        for (Location location : this.locations.get()) {
            if (location.status.get() == Status.Inactive) continue;
            list.add(location);
        }
        return list;
    }

    public Company getCompany() {
        return (Company)this.company.get();
    }

    public void setCompany(Company company) {
        this.company.set((Object)company);
    }

    public String getId() {
        return (String)this.id.get();
    }

    public void setId(String string) {
        this.id.set((Object)string);
    }

    public List<Location> getLocations() {
        return this.locations.get();
    }

    public void setLocations(List<Location> list) {
        this.locations.set(list);
    }

    public List<Doctor> getDoctors() {
        return this.doctors.get();
    }

    public void setDoctors(List<Doctor> list) {
        this.doctors.set(list);
    }

    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String string) {
        this.name.set((Object)string);
    }

    public static Division fetchByPk(String string, String string2) {
        return (Division)CurrentSession.get().fetchByPK(Division.class, new Object[]{string, string2});
    }

    public static Query<Division> select(String string, Object ... objectArray) {
        return CurrentSession.get().select(Division.class, string, objectArray);
    }

    public static List<Division> selectAll() {
        return ((ScanningDao)DependencyInjector.getInstance(ScanningDao.class)).selectAll(Division.class);
    }

    public static Division fetch(String string, Object ... objectArray) {
        return (Division)ListX.getFirst(Division.select(string, objectArray));
    }
}

