/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp;

import com.ahsrcm.corp.BaseBusinessBeanWithStatus;
import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.ISeries;
import com.ahsrcm.corp.beanprops.NotNull;
import com.ahsrcm.corp.orm.AttributeProperty;
import com.ahsrcm.esb.dataqueue.DataQueueStatus;
import com.ahsrcm.scanning.app.server.DatabaseConfig;
import com.ahsrcm.scanning.app.server.ServerAppConfig;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.ibm.as400.access.AS400JDBCDriver;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import net.java.dev.properties.Property;
import net.java.dev.properties.PropertyImpl;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.RPropertyImpl;
import net.java.dev.properties.annotations.Bidirectional;
import net.java.dev.properties.annotations.Column;
import net.java.dev.properties.annotations.Table;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.BeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.ObservableIndexed;
import net.java.dev.properties.container.ObservableProperty;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.Query;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.StringX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.util.StringJoiner;
import net.sf.log4jdbc.DriverSpy;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;

@Table(name="ESPDBM", prefix="EB", useDirtyChecking=false)
public class Database
extends BaseBusinessBeanWithStatus<Database> {
    private static final Log logger = LogHelper.getLog();
    private static final long serialVersionUID = 6736530884515187609L;
    @Column(name="EBISID")
    @NotNull
    @Bidirectional(value="iseries-databases")
    public final Property<ISeries> iSeries = ObservableProperty.create();
    public final transient RProperty<String> iSeriesId = new RPropertyImpl<String>(){
        private static final long serialVersionUID = 7984392125308650701L;

        public String get() {
            return (String)((ISeries)Database.this.iSeries.get()).id.get();
        }
    };
    @Column(name="EBDBID", key=true, length=4L)
    public final Property<String> id = ObservableProperty.create();
    @Column(name="EBDLIB", length=10L)
    public final Property<String> library = ObservableProperty.create((Object)"");
    @Column(name="EBDSC", length=40L)
    public final Property<String> description = ObservableProperty.create((Object)"");
    @Column(name="EBENAB")
    public final Property<Boolean> esbEnabled = ObservableProperty.create((Object)false);
    @Column(name="EBESTS", typeHandler=DataQueueStatus.OrmHandler.class)
    public final Property<DataQueueStatus> esbStatus = ObservableProperty.create();
    @Bidirectional(value="database-companies", parent=true)
    public final ObservableIndexed<Company> companies = ObservableIndexed.create();
    public final transient Property<String> overrideLibraryList = AttributeProperty.create("");
    public final transient Property<String> libraryList = new PropertyImpl<String>(){
        private static final long serialVersionUID = -38930950378725517L;

        public String get() {
            return new StringJoiner(Database.this.getLibraryList(), ",").toString();
        }

        public void set(String string) {
            string = string.trim();
            String string2 = new StringJoiner(Database.this.getDefaultLibraryList(), ",").toString();
            if (string2.equalsIgnoreCase(string)) {
                Database.this.overrideLibraryList.set((Object)"");
            } else {
                Database.this.overrideLibraryList.set((Object)string);
            }
        }
    };
    public static final BeanContext $BeanContext = (BeanContext)BeanContainer.get().getContext(Database.class);
    public static final IPropertyContext $visualId = $BeanContext.getProperty("visualId");
    public static final IPropertyContext $creationUser = $BeanContext.getProperty("creationUser");
    public static final IPropertyContext $creationDate = $BeanContext.getProperty("creationDate");
    public static final IPropertyContext $creationTime = $BeanContext.getProperty("creationTime");
    public static final IPropertyContext $lastChangeUser = $BeanContext.getProperty("lastChangeUser");
    public static final IPropertyContext $lastChangeDate = $BeanContext.getProperty("lastChangeDate");
    public static final IPropertyContext $lastChangeTime = $BeanContext.getProperty("lastChangeTime");
    public static final IPropertyContext $creationTimestamp = $BeanContext.getProperty("creationTimestamp");
    public static final IPropertyContext $lastChangeTimestamp = $BeanContext.getProperty("lastChangeTimestamp");
    public static final IPropertyContext $status = $BeanContext.getProperty("status");
    public static final IPropertyContext $iSeries = $BeanContext.getProperty("iSeries");
    public static final IPropertyContext $iSeriesId = $BeanContext.getProperty("iSeriesId");
    public static final IPropertyContext $id = $BeanContext.getProperty("id");
    public static final IPropertyContext $library = $BeanContext.getProperty("library");
    public static final IPropertyContext $description = $BeanContext.getProperty("description");
    public static final IPropertyContext $esbEnabled = $BeanContext.getProperty("esbEnabled");
    public static final IPropertyContext $esbStatus = $BeanContext.getProperty("esbStatus");
    public static final IPropertyContext $companies = $BeanContext.getProperty("companies");
    public static final IPropertyContext $overrideLibraryList = $BeanContext.getProperty("overrideLibraryList");
    public static final IPropertyContext $libraryList = $BeanContext.getProperty("libraryList");
    public static final Database Meta = new Database();

    public Database() {
        BeanContainer.bind((Object)this);
    }

    @Override
    public String getVisualId() {
        return (String)this.description.get();
    }

    public String getJdbcUrl() {
        ServerAppConfig serverAppConfig = (ServerAppConfig)((Object)DependencyInjector.get().getInstance(ServerAppConfig.class));
        String string = "";
        if (serverAppConfig.getEsbJdbcLogging()) {
            string = "jdbc:log4";
        }
        String string2 = new StringJoiner(this.getLibraryList(), ",").toString();
        return string + "jdbc:as400://" + (String)this.library.get() + "/;naming=system;libraries=" + string2 + ";date format=usa;errors=full";
    }

    public String getJdbcUrlWithDefaultLibraryList() {
        ServerAppConfig serverAppConfig = (ServerAppConfig)((Object)DependencyInjector.get().getInstance(ServerAppConfig.class));
        String string = "";
        if (serverAppConfig.getEsbJdbcLogging()) {
            string = "jdbc:log4";
        }
        String string2 = new StringJoiner(this.getDefaultLibraryList(), ",").toString();
        return string + "jdbc:as400://" + (String)this.library.get() + "/;naming=system;libraries=" + string2 + ";date format=usa;errors=full";
    }

    public DataSource createDataSource() {
        Properties properties = new Properties();
        String string = this.getJdbcUrl();
        properties.put("url", this.getJdbcUrl());
        ServerAppConfig serverAppConfig = (ServerAppConfig)((Object)DependencyInjector.get().getInstance(ServerAppConfig.class));
        if (serverAppConfig.getEsbJdbcLogging()) {
            properties.put("driverClassName", DriverSpy.class.getName());
        } else {
            properties.put("driverClassName", AS400JDBCDriver.class.getName());
        }
        properties.put("username", ((ISeries)this.iSeries.get()).user.get());
        properties.put("password", ((ISeries)this.iSeries.get()).password.get());
        DatabaseConfig databaseConfig = ((ServerAppConfig)((Object)DependencyInjector.getInstance(ServerAppConfig.class))).getDatabaseConfig();
        properties.put("logAbandoned", "" + databaseConfig.getLogAbandoned());
        properties.put("removeAbandoned", "" + databaseConfig.getRemoveAbandoned());
        properties.put("removeAbandonedTimeout", databaseConfig.getRemoveAbandonedTimeout());
        properties.put("maxActive", "40");
        properties.put("testWhileIdle", "true");
        properties.put("testOnReturn", "true");
        properties.put("testOnBorrow", "true");
        properties.put("timeBetweenEvictionRunsMillis", "600000");
        properties.put("poolPreparedStatements", "true");
        properties.put("defaultAutoCommit", "true");
        properties.put("initialSize", "1");
        properties.put("maxWait", "3000");
        properties.put("validationQuery", "select 1+1 from QUSRSYS/ESPCON");
        logger.info((Object)"database {} is using jdbc url = {}", this.id.get(), (Object)string);
        try {
            return (BasicDataSource)BasicDataSourceFactory.createDataSource((Properties)properties);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public List<String> getLibraryList() {
        if (StringX.isNotBlank((String)((String)this.overrideLibraryList.get()))) {
            List list = ListX.create();
            for (String string : ((String)this.overrideLibraryList.get()).split(",")) {
                if ((string = string.trim()).equalsIgnoreCase("*DFT")) {
                    list.addAll(this.getDefaultLibraryList());
                    continue;
                }
                if (!StringX.isNotBlank((String)string)) continue;
                list.add(string);
            }
            return list;
        }
        return this.getDefaultLibraryList();
    }

    public List<String> getDefaultLibraryList() {
        String string = (String)this.id.get();
        if (this.isEnterprise()) {
            String string2 = "EAX_PF010";
            if (string.equals("6001")) {
                string2 = "EAX_PF010T";
            }
            ServerAppConfig serverAppConfig = (ServerAppConfig)((Object)DependencyInjector.getInstance(ServerAppConfig.class));
            return ListX.create((Object[])new String[]{serverAppConfig.getInfoedgeDataLibrary(), "EAG" + string, "EAD" + string, string2, "EAX_PB010", "SIDVLPLIB"});
        }
        List list = ListX.create((Object[])new String[]{"VMG" + string, "VMP" + string, "VMC" + string, "VMD" + string, "VMW" + string, "VMA" + string, "QGPL", "QTEMP"});
        return list;
    }

    public boolean isEnterprise() {
        return ((String)this.id.get()).equals("0001") || ((String)this.id.get()).equals("6001");
    }

    public String getDnsName() {
        return (String)this.library.get();
    }

    public boolean isClient() {
        return !this.isEnterprise();
    }

    public static Database getEnterpriseDatabase() {
        ServerAppConfig serverAppConfig = (ServerAppConfig)((Object)DependencyInjector.get().getInstance(ServerAppConfig.class));
        return Database.fetchByPk(serverAppConfig.getEnterpriseDatabaseId());
    }

    public ISeries getISeries() {
        return (ISeries)this.iSeries.get();
    }

    public void setISeries(ISeries iSeries) {
        this.iSeries.set((Object)iSeries);
    }

    public String getISeriesId() {
        return (String)this.iSeriesId.get();
    }

    public String getId() {
        return (String)this.id.get();
    }

    public void setId(String string) {
        this.id.set((Object)string);
    }

    public String getLibrary() {
        return (String)this.library.get();
    }

    public void setLibrary(String string) {
        this.library.set((Object)string);
    }

    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String string) {
        this.description.set((Object)string);
    }

    public Boolean getEsbEnabled() {
        return (Boolean)this.esbEnabled.get();
    }

    public void setEsbEnabled(Boolean bl) {
        this.esbEnabled.set((Object)bl);
    }

    public DataQueueStatus getEsbStatus() {
        return (DataQueueStatus)((Object)this.esbStatus.get());
    }

    public void setEsbStatus(DataQueueStatus dataQueueStatus) {
        this.esbStatus.set((Object)dataQueueStatus);
    }

    public List<Company> getCompanies() {
        return this.companies.get();
    }

    public void setCompanies(List<Company> list) {
        this.companies.set(list);
    }

    public String getOverrideLibraryList() {
        return (String)this.overrideLibraryList.get();
    }

    public void setOverrideLibraryList(String string) {
        this.overrideLibraryList.set((Object)string);
    }

    public void setLibraryList(String string) {
        this.libraryList.set((Object)string);
    }

    public static Database fetchByPk(String string) {
        return (Database)CurrentSession.get().fetchByPK(Database.class, new Object[]{string});
    }

    public static Query<Database> select(String string, Object ... objectArray) {
        return CurrentSession.get().select(Database.class, string, objectArray);
    }

    public static List<Database> selectAll() {
        return ((ScanningDao)DependencyInjector.getInstance(ScanningDao.class)).selectAll(Database.class);
    }

    public static Database fetch(String string, Object ... objectArray) {
        return (Database)ListX.getFirst(Database.select(string, objectArray));
    }
}

