/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp;

import com.ahsrcm.corp.BaseBusinessBeanWithStatus;
import com.ahsrcm.corp.Division;
import com.ahsrcm.corp.HasCDLEntity;
import com.ahsrcm.corp.HasPatientFileId;
import com.ahsrcm.corp.PatientFile;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.ScannedImage;
import com.ahsrcm.corp.beanprops.LazyUid32Property;
import com.ahsrcm.corp.beanprops.NotNull;
import com.ahsrcm.corp.cdl.CDLEntity;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.ahsrcm.util.ToStringBuilder;
import java.sql.Date;
import java.util.List;
import net.java.dev.properties.Property;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.RPropertyImpl;
import net.java.dev.properties.annotations.Attributes;
import net.java.dev.properties.annotations.Bidirectional;
import net.java.dev.properties.annotations.Column;
import net.java.dev.properties.annotations.Table;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.BeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.ObservableProperty;
import net.java.dev.properties.container.PropertyContext;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.Query;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

@Table(name="ESPCHRG", prefix="EM")
public class CodingCharge
extends BaseBusinessBeanWithStatus<CodingCharge>
implements HasCDLEntity,
HasPatientFileId {
    private static final Logger logger = LoggerHelper.getLogger();
    private static final long serialVersionUID = 1623953362675601927L;
    @Column(suffix="CMP,DIV")
    public final Property<Division> division = ObservableProperty.create();
    @Column(suffix="SCN")
    @Bidirectional(value="batch-charges")
    public final Property<ScanBatch> batch = ObservableProperty.create();
    @Column(suffix="DOS")
    @NotNull
    public final Property<Date> dateOfService = ObservableProperty.create();
    @Column(suffix="SGR")
    public final Property<Long> patientFileId = ObservableProperty.create();
    @Column(suffix="UID", key=true, length=32L)
    final Property<String> uid = new LazyUid32Property();
    @Attributes(displayName="Seq")
    @Column(suffix="CSQ")
    public final ObservableProperty<Integer> sequence = new ObservableProperty();
    @Column(suffix="DID")
    public final ObservableProperty<ScannedImage> image = new ObservableProperty();
    @Column(suffix="LOS", length=4L)
    public final ObservableProperty<String> locationId = ObservableProperty.create();
    @Column(suffix="DR", length=5L)
    public final ObservableProperty<String> doctorId = ObservableProperty.create();
    @Column(suffix="DRR", length=5L)
    public final ObservableProperty<String> referralId = ObservableProperty.create((Object)"");
    @Column(suffix="TPF")
    public final ObservableProperty<Integer> timesPerformed = ObservableProperty.create((Object)0);
    @Column(suffix="ACC", length=20L)
    public final ObservableProperty<String> accessionNumber = ObservableProperty.create((Object)"");
    @Column(suffix="PRO", length=5L)
    public final ObservableProperty<String> procedureCode = ObservableProperty.create((Object)"");
    @Column(suffix="PROPRE", length=5L)
    public final ObservableProperty<String> priorProcedureCode = ObservableProperty.create((Object)"");
    @Column(suffix="TPFP")
    public final ObservableProperty<Integer> procedureBaseUnits = ObservableProperty.create((Object)0);
    @Column(suffix="ASA", length=5L)
    public final ObservableProperty<String> asaProcedureCode = ObservableProperty.create();
    @Column(suffix="TPFA")
    public final ObservableProperty<Integer> asaProcedureBaseUnits = ObservableProperty.create((Object)0);
    @Column(suffix="DIA1", length=8L)
    public final ObservableProperty<String> diagnosis1Code = ObservableProperty.create();
    @Column(suffix="DIA2", length=8L)
    public final ObservableProperty<String> diagnosis2Code = ObservableProperty.create();
    @Column(suffix="DIA3", length=8L)
    public final ObservableProperty<String> diagnosis3Code = ObservableProperty.create();
    @Column(suffix="DIA4", length=8L)
    public final ObservableProperty<String> diagnosis4Code = ObservableProperty.create();
    @Column(suffix="CC1", length=2L)
    public final ObservableProperty<String> conditionCode1 = ObservableProperty.create();
    @Column(suffix="CC2", length=2L)
    public final ObservableProperty<String> conditionCode2 = ObservableProperty.create();
    @Column(suffix="CC3", length=2L)
    public final ObservableProperty<String> conditionCode3 = ObservableProperty.create();
    @Column(suffix="CC4", length=2L)
    public final ObservableProperty<String> conditionCode4 = ObservableProperty.create();
    @Column(suffix="CC5", length=2L)
    public final ObservableProperty<String> conditionCode5 = ObservableProperty.create();
    @Column(suffix="RSN", length=1L)
    public final ObservableProperty<String> transportationReason = ObservableProperty.create();
    public final transient RProperty<String> diagnosisAsString = new RPropertyImpl<String>(){
        private static final long serialVersionUID = 7984392125308650701L;

        public String get() {
            return CodingCharge.this.getCptCodesAsString(new Property[]{CodingCharge.this.diagnosis1Code, CodingCharge.this.diagnosis2Code, CodingCharge.this.diagnosis3Code, CodingCharge.this.diagnosis4Code});
        }
    };
    public final transient RProperty<String> modifierAsString = new RPropertyImpl<String>(){
        private static final long serialVersionUID = 7984392125308650701L;

        public String get() {
            return CodingCharge.this.getCptCodesAsString(new Property[]{CodingCharge.this.modifier1Code, CodingCharge.this.modifier2Code, CodingCharge.this.modifier3Code, CodingCharge.this.modifier4Code});
        }
    };
    @Column(suffix="MOD1", length=2L)
    public final ObservableProperty<String> modifier1Code = ObservableProperty.create();
    @Column(suffix="MOD2", length=2L)
    public final ObservableProperty<String> modifier2Code = ObservableProperty.create();
    @Column(suffix="MOD3", length=2L)
    public final ObservableProperty<String> modifier3Code = ObservableProperty.create();
    @Column(suffix="MOD4", length=2L)
    public final ObservableProperty<String> modifier4Code = ObservableProperty.create();
    @Column(suffix="MRN", length=20L)
    public final ObservableProperty<String> medicalRecordNum = ObservableProperty.create();
    public static final BeanContext $BeanContext = (BeanContext)BeanContainer.get().getContext(CodingCharge.class);
    public static final IPropertyContext $visualId = $BeanContext.getProperty("visualId");
    public static final IPropertyContext $creationUser = $BeanContext.getProperty("creationUser");
    public static final IPropertyContext $creationDate = $BeanContext.getProperty("creationDate");
    public static final IPropertyContext $creationTime = $BeanContext.getProperty("creationTime");
    public static final IPropertyContext $lastChangeUser = $BeanContext.getProperty("lastChangeUser");
    public static final IPropertyContext $lastChangeDate = $BeanContext.getProperty("lastChangeDate");
    public static final IPropertyContext $lastChangeTime = $BeanContext.getProperty("lastChangeTime");
    public static final IPropertyContext $creationTimestamp = $BeanContext.getProperty("creationTimestamp");
    public static final IPropertyContext $lastChangeTimestamp = $BeanContext.getProperty("lastChangeTimestamp");
    public static final IPropertyContext $status = $BeanContext.getProperty("status");
    public static final IPropertyContext $division = $BeanContext.getProperty("division");
    public static final IPropertyContext $batch = $BeanContext.getProperty("batch");
    public static final IPropertyContext $dateOfService = $BeanContext.getProperty("dateOfService");
    public static final IPropertyContext $patientFileId = $BeanContext.getProperty("patientFileId");
    public static final IPropertyContext $uid = $BeanContext.getProperty("uid");
    public static final IPropertyContext $sequence = $BeanContext.getProperty("sequence");
    public static final IPropertyContext $image = $BeanContext.getProperty("image");
    public static final IPropertyContext $locationId = $BeanContext.getProperty("locationId");
    public static final IPropertyContext $doctorId = $BeanContext.getProperty("doctorId");
    public static final IPropertyContext $referralId = $BeanContext.getProperty("referralId");
    public static final IPropertyContext $timesPerformed = $BeanContext.getProperty("timesPerformed");
    public static final IPropertyContext $accessionNumber = $BeanContext.getProperty("accessionNumber");
    public static final IPropertyContext $procedureCode = $BeanContext.getProperty("procedureCode");
    public static final IPropertyContext $priorProcedureCode = $BeanContext.getProperty("priorProcedureCode");
    public static final IPropertyContext $procedureBaseUnits = $BeanContext.getProperty("procedureBaseUnits");
    public static final IPropertyContext $asaProcedureCode = $BeanContext.getProperty("asaProcedureCode");
    public static final IPropertyContext $asaProcedureBaseUnits = $BeanContext.getProperty("asaProcedureBaseUnits");
    public static final IPropertyContext $diagnosis1Code = $BeanContext.getProperty("diagnosis1Code");
    public static final IPropertyContext $diagnosis2Code = $BeanContext.getProperty("diagnosis2Code");
    public static final IPropertyContext $diagnosis3Code = $BeanContext.getProperty("diagnosis3Code");
    public static final IPropertyContext $diagnosis4Code = $BeanContext.getProperty("diagnosis4Code");
    public static final IPropertyContext $diagnosisAsString = $BeanContext.getProperty("diagnosisAsString");
    public static final IPropertyContext $modifierAsString = $BeanContext.getProperty("modifierAsString");
    public static final IPropertyContext $modifier1Code = $BeanContext.getProperty("modifier1Code");
    public static final IPropertyContext $modifier2Code = $BeanContext.getProperty("modifier2Code");
    public static final IPropertyContext $modifier3Code = $BeanContext.getProperty("modifier3Code");
    public static final IPropertyContext $modifier4Code = $BeanContext.getProperty("modifier4Code");
    public static final IPropertyContext $medicalRecordNum = $BeanContext.getProperty("medicalRecordNum");
    public static final CodingCharge Meta = new CodingCharge();

    public CodingCharge() {
        BeanContainer.bind((Object)this);
    }

    public CodingCharge(boolean bl) {
        this();
    }

    public void updateHeaderInfo(PatientFile patientFile) {
        logger.debug((Object)"updateHeaderInfo to pf = {}   {}   {}", (Object)patientFile, this.procedureCode, this.sequence);
        if (patientFile == null) {
            this.batch.set(null);
            this.division.set(null);
            this.patientFileId.set(null);
        } else {
            CDLEntity cDLEntity = patientFile.getCDLEntity();
            this.division.set((Object)cDLEntity.getDivision());
            this.batch.set((Object)((ScanBatch)patientFile.batch.get()));
            this.patientFileId.set((Object)((Long)patientFile.id.get()));
        }
    }

    Object[] getCptCodingKey(String string) {
        return new Object[]{this.getCDLEntity().getCompanyId(), string};
    }

    String getCptCodesAsString(Property<?> ... propertyArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Property<?> property : propertyArray) {
            String string = (String)property.get();
            if (!StringX.isNotBlank((String)string)) continue;
            stringBuilder.append(string);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString().trim();
    }

    @Override
    public Long getPatientFileId() {
        return (Long)this.patientFileId.get();
    }

    @Override
    public void setPatientFile(PatientFile patientFile) {
        this.patientFileId.set((Object)((Long)patientFile.id.get()));
        this.batch.set((Object)((ScanBatch)patientFile.batch.get()));
    }

    @Override
    public CDLEntity getCDLEntity() {
        return ((ScanBatch)this.batch.get()).getCDLEntity();
    }

    @Override
    public String toString() {
        return ToStringBuilder.toString(this, false, new RProperty[]{this.uid, this.patientFileId, this.procedureCode, this.asaProcedureCode, this.sequence});
    }

    public Division getDivision() {
        return (Division)this.division.get();
    }

    public void setDivision(Division division) {
        this.division.set((Object)division);
    }

    public ScanBatch getBatch() {
        return (ScanBatch)this.batch.get();
    }

    public void setBatch(ScanBatch scanBatch) {
        this.batch.set((Object)scanBatch);
    }

    public Date getDateOfService() {
        return (Date)this.dateOfService.get();
    }

    public void setDateOfService(Date date) {
        this.dateOfService.set((Object)date);
    }

    public void setPatientFileId(Long l) {
        this.patientFileId.set((Object)l);
    }

    public String getUid() {
        return (String)this.uid.get();
    }

    public void setUid(String string) {
        this.uid.set((Object)string);
    }

    public Integer getSequence() {
        return (Integer)this.sequence.get();
    }

    public void setSequence(Integer n) {
        this.sequence.set((Object)n);
    }

    public ScannedImage getImage() {
        return (ScannedImage)this.image.get();
    }

    public void setImage(ScannedImage scannedImage) {
        this.image.set((Object)scannedImage);
    }

    public String getLocationId() {
        return (String)this.locationId.get();
    }

    public void setLocationId(String string) {
        this.locationId.set((Object)string);
    }

    public String getDoctorId() {
        return (String)this.doctorId.get();
    }

    public void setDoctorId(String string) {
        this.doctorId.set((Object)string);
    }

    public String getReferralId() {
        return (String)this.referralId.get();
    }

    public void setReferralId(String string) {
        this.referralId.set((Object)string);
    }

    public Integer getTimesPerformed() {
        return (Integer)this.timesPerformed.get();
    }

    public void setTimesPerformed(Integer n) {
        this.timesPerformed.set((Object)n);
    }

    public String getAccessionNumber() {
        return (String)this.accessionNumber.get();
    }

    public void setAccessionNumber(String string) {
        this.accessionNumber.set((Object)string);
    }

    public String getProcedureCode() {
        return (String)this.procedureCode.get();
    }

    public void setProcedureCode(String string) {
        this.procedureCode.set((Object)string);
    }

    public String getPriorProcedureCode() {
        return (String)this.priorProcedureCode.get();
    }

    public void setPriorProcedureCode(String string) {
        this.priorProcedureCode.set((Object)string);
    }

    public Integer getProcedureBaseUnits() {
        return (Integer)this.procedureBaseUnits.get();
    }

    public void setProcedureBaseUnits(Integer n) {
        this.procedureBaseUnits.set((Object)n);
    }

    public String getAsaProcedureCode() {
        return (String)this.asaProcedureCode.get();
    }

    public void setAsaProcedureCode(String string) {
        this.asaProcedureCode.set((Object)string);
    }

    public Integer getAsaProcedureBaseUnits() {
        return (Integer)this.asaProcedureBaseUnits.get();
    }

    public void setAsaProcedureBaseUnits(Integer n) {
        this.asaProcedureBaseUnits.set((Object)n);
    }

    public String getDiagnosis1Code() {
        return (String)this.diagnosis1Code.get();
    }

    public void setDiagnosis1Code(String string) {
        this.diagnosis1Code.set((Object)string);
    }

    public String getDiagnosis2Code() {
        return (String)this.diagnosis2Code.get();
    }

    public void setDiagnosis2Code(String string) {
        this.diagnosis2Code.set((Object)string);
    }

    public String getDiagnosis3Code() {
        return (String)this.diagnosis3Code.get();
    }

    public void setDiagnosis3Code(String string) {
        this.diagnosis3Code.set((Object)string);
    }

    public String getDiagnosis4Code() {
        return (String)this.diagnosis4Code.get();
    }

    public void setDiagnosis4Code(String string) {
        this.diagnosis4Code.set((Object)string);
    }

    public String getDiagnosisAsString() {
        return (String)this.diagnosisAsString.get();
    }

    public String getModifierAsString() {
        return (String)this.modifierAsString.get();
    }

    public String getModifier1Code() {
        return (String)this.modifier1Code.get();
    }

    public void setModifier1Code(String string) {
        this.modifier1Code.set((Object)string);
    }

    public String getModifier2Code() {
        return (String)this.modifier2Code.get();
    }

    public void setModifier2Code(String string) {
        this.modifier2Code.set((Object)string);
    }

    public String getModifier3Code() {
        return (String)this.modifier3Code.get();
    }

    public void setModifier3Code(String string) {
        this.modifier3Code.set((Object)string);
    }

    public String getModifier4Code() {
        return (String)this.modifier4Code.get();
    }

    public void setModifier4Code(String string) {
        this.modifier4Code.set((Object)string);
    }

    public String getMedicalRecordNum() {
        return (String)this.medicalRecordNum.get();
    }

    public void setMedicalRecordNum(String string) {
        this.medicalRecordNum.set((Object)string);
    }

    public static CodingCharge fetchByPk(String string) {
        return (CodingCharge)CurrentSession.get().fetchByPK(CodingCharge.class, new Object[]{string});
    }

    public static Query<CodingCharge> select(String string, Object ... objectArray) {
        return CurrentSession.get().select(CodingCharge.class, string, objectArray);
    }

    public static List<CodingCharge> selectAll() {
        return ((ScanningDao)DependencyInjector.getInstance(ScanningDao.class)).selectAll(CodingCharge.class);
    }

    public static CodingCharge fetch(String string, Object ... objectArray) {
        return (CodingCharge)ListX.getFirst(CodingCharge.select(string, objectArray));
    }

    static {
        ((PropertyContext)$diagnosis1Code).setDisplayName("Dia1");
        ((PropertyContext)$diagnosis2Code).setDisplayName("2");
        ((PropertyContext)$diagnosis3Code).setDisplayName("3");
        ((PropertyContext)$diagnosis4Code).setDisplayName("4");
        ((PropertyContext)$modifier1Code).setDisplayName("Mod1");
        ((PropertyContext)$modifier2Code).setDisplayName("2");
        ((PropertyContext)$modifier3Code).setDisplayName("3");
        ((PropertyContext)$modifier4Code).setDisplayName("4");
        ((PropertyContext)$medicalRecordNum).setDisplayName("MRN");
    }
}

