/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp;

import com.ahsrcm.corp.BusinessEntity;
import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Division;
import com.ahsrcm.corp.Location;
import java.util.Set;
import net.java.dev.properties.jdbc.CurrentSession;
import net.model3.collections.SetX;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class Authorization {
    private static final Logger logger = LoggerHelper.getLogger();
    private BusinessEntity _businessEntity;
    private Company _company;
    private Division _division;
    private Location _location;

    public Authorization(BusinessEntity businessEntity) {
        this._businessEntity = businessEntity;
    }

    public Company getCompany() {
        if (this._company == null && StringX.isNotBlank((String)this.getCompanyId())) {
            this._company = (Company)CurrentSession.get().fetchByPK(Company.class, new Object[]{this.getCompanyId()});
        }
        return this._company;
    }

    public boolean isValid() {
        return !(!StringX.isBlank((String)this.getCompanyId()) && this.getCompany() == null || !StringX.isBlank((String)this.getDivisionId()) && this.getDivision() == null || !StringX.isBlank((String)this.getLocationId()) && this.getLocation() == null);
    }

    public BusinessEntity getBusinessEntity() {
        return this._businessEntity;
    }

    public String getCompanyId() {
        return this.safeSubstring((String)this._businessEntity.value.get(), 0, 4);
    }

    public String getDivisionId() {
        return this.safeSubstring((String)this._businessEntity.value.get(), 4, 8);
    }

    public String getLocationId() {
        return this.safeSubstring((String)this._businessEntity.value.get(), 8, 12);
    }

    private String safeSubstring(String string, int n, int n2) {
        if ((string = StringX.safeSubstring((String)string, (int)n, (int)n2)) != null) {
            string = StringX.trimRight((String)string);
        }
        return string;
    }

    public Division getDivision() {
        if (this._division == null && StringX.isNotBlank((String)this.getDivisionId())) {
            this._division = (Division)CurrentSession.get().fetchByPK(Division.class, new Object[]{this.getCompanyId(), this.getDivisionId()});
        }
        return this._division;
    }

    public Location getLocation() {
        if (this._location == null && StringX.isNotBlank((String)this.getLocationId())) {
            this._location = (Location)CurrentSession.get().fetchByPK(Location.class, new Object[]{this.getCompanyId(), this.getDivisionId(), this.getLocationId()});
        }
        return this._location;
    }

    public boolean isCompanyLevel() {
        return StringX.isNotBlank((String)this.getCompanyId()) && StringX.isBlank((String[])new String[]{this.getDivisionId(), this.getLocationId()});
    }

    public boolean isDivisionLevel() {
        return StringX.isNotBlank((String[])new String[]{this.getCompanyId(), this.getDivisionId()}) && StringX.isBlank((String)this.getLocationId());
    }

    public boolean isLocationLevel() {
        return StringX.isNotBlank((String[])new String[]{this.getCompanyId(), this.getDivisionId(), this.getLocationId()});
    }

    public Set<Location> getAuthorizedLocations() {
        Set set = SetX.create();
        try {
            if (this.isLocationLevel()) {
                set.add(this.getLocation());
            } else if (this.isDivisionLevel()) {
                set.addAll(this.getDivision().locations.get());
            } else if (this.isCompanyLevel()) {
                for (Division division : this.getCompany().divisions.get()) {
                    set.addAll(division.locations.get());
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            logger.debug((Object)"missing C, D or L for business entity User = {} and CDL = {}", this._businessEntity.user.get(), this._businessEntity.value.get());
        }
        return set;
    }

    public String getLocationWhereClause() {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringX.isNotBlank((String)this.getLocationId())) {
            stringBuilder.append("EFLOS = '" + this.getLocationId() + "'");
        }
        if (StringX.isNotBlank((String)this.getDivisionId())) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" and ");
            }
            stringBuilder.append("EFDIV = '" + this.getDivisionId() + "'");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(" and ");
        }
        stringBuilder.append("EFCMP = '" + this.getCompanyId() + "'");
        return "(" + stringBuilder.toString() + ")";
    }

    public String toString() {
        return (String)this._businessEntity.value.get();
    }
}

