/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp;

import com.ahsrcm.corp.Authenticator;
import com.ahsrcm.corp.EaxUserAccess;
import com.ahsrcm.corp.ISeries;
import com.ahsrcm.corp.User;
import com.ahsrcm.corp.rules.UserRole;
import com.ahsrcm.scanning.app.server.SecurityTokenAuthenticator;
import net.java.dev.properties.jdbc.CurrentSession;

public enum AccessControl {
    AdministratoryOnly,
    WorkflowDotCom,
    Public,
    LoggedInUser,
    SecurityToken,
    ShowPatientFileInfo,
    ISeriesEditor("ISERIES", ISeries.class, "iSeries Table Editor"),
    StageXWalk("STAGEXW", "newStageEditor", "Stage X-Ref Editor"),
    WorkflowRulesEditor("RULES", "newRuleSetsEditor", "Workflow Rules Editor"),
    EsbConfigurator("ESBCFG", "newEsbConfigurator", "ESB Configurator"),
    ScanSearch("SEARCH", "newScanSearch", "Detail Scan Search"),
    ScanningMenu("MENU", "Scanning Server Menu", "/index.html?dev=true&tabs=true", true);

    private String _taskIdSuffix;
    private String _jsxSessionMethod;
    private String _description;
    private String _url;
    private Class<?> _clazz;
    private boolean _newWindow = false;

    private AccessControl() {
    }

    private AccessControl(String string2, String string3, String string4) {
        this._taskIdSuffix = string2;
        this._jsxSessionMethod = string3;
        this._description = string4;
    }

    private AccessControl(String string2, Class<?> clazz, String string3) {
        this._taskIdSuffix = string2;
        this._clazz = clazz;
        this._description = string3;
    }

    private AccessControl(String string2, String string3, String string4, boolean bl) {
        this._taskIdSuffix = string2;
        this._description = string3;
        this._url = string4;
        this._newWindow = bl;
    }

    public String getJsxSessionMethod() {
        return this._jsxSessionMethod;
    }

    public String getTaskIdSuffix() {
        return this._taskIdSuffix;
    }

    public String getTaskId() {
        return "SCN_" + this.getTaskIdSuffix();
    }

    public String getDescription() {
        return this._description;
    }

    public Class<?> getDmdaClass() {
        return this._clazz;
    }

    public boolean allowAccess(User user, Authenticator authenticator) {
        if (this == Public) {
            return true;
        }
        if (this == SecurityToken) {
            return authenticator instanceof SecurityTokenAuthenticator;
        }
        if (user == null) {
            return false;
        }
        if (authenticator.isAdministrator()) {
            return true;
        }
        if (this == AdministratoryOnly) {
            return authenticator.isAdministrator();
        }
        if (this == WorkflowDotCom) {
            return user.roles.contains((Object)UserRole.Workflow.get());
        }
        if (this == LoggedInUser) {
            return user != null;
        }
        EaxUserAccess eaxUserAccess = user.group.get() == null ? (EaxUserAccess)CurrentSession.get().fetchByPK(EaxUserAccess.class, new Object[]{user.id.get(), this.getTaskId()}) : (EaxUserAccess)CurrentSession.get().fetchByPK(EaxUserAccess.class, new Object[]{((User)user.group.get()).id.get(), this.getTaskId()});
        return eaxUserAccess != null;
    }

    public boolean getNewWindow() {
        return this._newWindow;
    }

    public String getUrl() {
        return this._url;
    }
}

