/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp;

import com.ahsrcm.corp.Authenticator;
import com.ahsrcm.corp.HasCDLEntity;
import com.ahsrcm.corp.OrmBean;
import com.ahsrcm.corp.cdl.CDLAuthenticator;
import com.ahsrcm.corp.cdl.CDLEntity;
import com.ahsrcm.scanning.dao.AuthorizationException;

public abstract class AbstractAuthenticator
implements Authenticator {
    @Override
    public void validateForReading(OrmBean ormBean) {
        OrmBean ormBean2 = ormBean;
        boolean bl = true;
        if (ormBean instanceof HasCDLEntity) {
            bl = this.isAuthorizedTo((HasCDLEntity)((Object)ormBean));
        }
        if (!bl) {
            throw new AuthorizationException("User " + this.getUserLogin().trim() + " is not authorized to bean " + ormBean2);
        }
    }

    @Override
    public boolean isAuthorizedTo(HasCDLEntity hasCDLEntity) {
        if (hasCDLEntity != null) {
            return this.isAuthorizedTo(hasCDLEntity.getCDLEntity());
        }
        return true;
    }

    @Override
    public boolean isExplicitlyAuthorizedTo(HasCDLEntity hasCDLEntity) {
        if (hasCDLEntity != null) {
            return this.isExplicitlyAuthorizedTo(hasCDLEntity.getCDLEntity());
        }
        return false;
    }

    @Override
    public boolean isExplicitlyAuthorizedTo(CDLEntity cDLEntity) {
        return this.getCDLAuthenticator().isAuthorizationMatch(cDLEntity, true);
    }

    public abstract CDLAuthenticator getCDLAuthenticator();

    @Override
    public boolean isAuthorizedTo(CDLEntity cDLEntity) {
        return this.getCDLAuthenticator().isAuthorizationMatch(cDLEntity, false);
    }

    @Override
    public String getUserId() {
        if (this.getUser() != null) {
            return this.getUser().getId();
        }
        return null;
    }

    @Override
    public String getUserDescription() {
        if (this.getUser() != null) {
            return this.getUser().getDescription();
        }
        return null;
    }

    @Override
    public String getUserLogin() {
        if (this.getUser() != null) {
            return this.getUser().getLoginName();
        }
        return null;
    }
}

