/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.core.virtualmanager;

import com.ahsrcm.corp.cdl.CDLEntity;
import com.ahsrcm.esb.ConnectionTransaction;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.jdbc.EntityPersister;
import net.java.dev.properties.jdbc.Query;
import net.java.dev.properties.jdbc.SelectQuery;
import net.java.dev.properties.jdbc.SessionConfiguration;
import net.java.dev.properties.jdbc.UpdateQuery;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

@Singleton
public class VirtualManagerDAO {
    Logger logger = LoggerHelper.getLogger();
    @Inject
    SessionConfiguration _sessionConfiguration;
    @Inject
    BeanContainer _beanContainer;
    @Inject
    Injector _injector;
    Map<Class<?>, EntityPersister<?>> _persisters = Collections.synchronizedMap(new HashMap());

    <T> EntityPersister<T> getPersister(Class<?> clazz) {
        EntityPersister entityPersister = this._persisters.get(clazz);
        if (entityPersister == null) {
            entityPersister = new EntityPersister(clazz, this._beanContainer.getContext(clazz), this._sessionConfiguration);
            entityPersister.setAddToCache(false);
            this._persisters.put(clazz, entityPersister);
        }
        return entityPersister;
    }

    public <T> T fetchByPk(CDLEntity cDLEntity, Class<T> clazz, Object ... objectArray) {
        EntityPersister<T> entityPersister = this.getPersister(clazz);
        return (T)this.select(cDLEntity, clazz, entityPersister.getPKWhereClause(), objectArray).getResult();
    }

    public <T> Query<T> select(CDLEntity cDLEntity, Class<T> clazz, String string, Object ... objectArray) {
        final EntityPersister<T> entityPersister = this.getPersister(clazz);
        String string2 = StringX.isNotBlank((String)string) ? " where " + string : "";
        String string3 = cDLEntity.getDatabase().isEnterprise() ? entityPersister.getTableName() : this.getConnTxn().getAlias(entityPersister.getTableName(), cDLEntity);
        String string4 = entityPersister.createSelectSql(string3) + string2;
        this.logger.debug((Object)"running on {} - {}", (Object)cDLEntity.getDatabaseId(), (Object)string4);
        Connection connection = this.getConnTxn().getConnection(cDLEntity.getDatabase());
        SelectQuery selectQuery = new SelectQuery<T>(string4, connection, objectArray){

            protected T processRow(ResultSet resultSet) throws SQLException {
                return entityPersister.createFromResultSet(resultSet);
            }
        };
        selectQuery.getResults();
        return selectQuery;
    }

    ConnectionTransaction getConnTxn() {
        return (ConnectionTransaction)this._injector.getInstance(ConnectionTransaction.class);
    }

    public <T> void update(CDLEntity cDLEntity, final T t) {
        final EntityPersister<T> entityPersister = this.getPersister(t.getClass());
        String string = this.getConnTxn().getAlias(entityPersister.getTableName(), cDLEntity);
        String string2 = entityPersister.createUpdateSql(string);
        Connection connection = this.getConnTxn().getConnection(cDLEntity.getDatabase());
        new UpdateQuery(string2, connection){

            protected void prepareQuery() throws SQLException {
                entityPersister.updateQuery(this.getStatement(), t);
            }
        }.execute();
    }

    public <T> void delete(CDLEntity cDLEntity, final T t) {
        final EntityPersister<T> entityPersister = this.getPersister(t.getClass());
        String string = this.getConnTxn().getAlias(entityPersister.getTableName(), cDLEntity);
        String string2 = entityPersister.createDeleteSql(string);
        Connection connection = this.getConnTxn().getConnection(cDLEntity.getDatabase());
        new UpdateQuery(string2, connection){

            protected void prepareQuery() throws SQLException {
                entityPersister.deleteQuery(this.getStatement(), t);
            }
        }.execute();
    }

    public <T> T insert(CDLEntity cDLEntity, final T t) {
        final EntityPersister<T> entityPersister = this.getPersister(t.getClass());
        String string = this.getConnTxn().getAlias(entityPersister.getTableName(), cDLEntity);
        String string2 = entityPersister.createInsertSql(string);
        Connection connection = this.getConnTxn().getConnection(cDLEntity.getDatabase());
        new UpdateQuery(string2, connection){

            protected void prepareQuery() throws SQLException {
                entityPersister.insertQuery(this.getStatement(), t);
            }
        }.execute();
        return t;
    }
}

