/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.core.util;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Properties;
import java.util.UUID;
import net.model3.guice.bootstrap.ConfigurationDirectory;
import net.model3.lang.TimeDuration;
import net.model3.logging.Level;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import net.model3.newfile.File;

@Singleton
public class DeployEdgeProperties {
    final Logger logger = LoggerHelper.getLogger();
    Properties _properties;
    final String useEncryptionPropertyName = "useImageEncryption";
    final String imageEncryptionPasswordPropertyName = "imageEncryptionPassword";
    final String cleanUpPdfToTifPropertyName = "cleanUpPdfToTif";
    final String maxMemoryPropertyName = "maxMemory";
    final String defaultMaxMemoryValue = "1024m";
    final String fileName = "deployedge.properties";

    @Inject
    private DeployEdgeProperties(ConfigurationDirectory configurationDirectory) {
        File file = ((Directory)configurationDirectory.get()).file("deployedge.properties");
        this._properties = new Properties();
        if (file.exists()) {
            this.logPropertyFileContents(file, "Current");
            try {
                this._properties.load(file.createInputStream());
                String string = "implme";
                String string2 = this._properties.getProperty("useImageEncryption", string);
                String string3 = this._properties.getProperty("imageEncryptionPassword", string);
                String string4 = this._properties.getProperty("maxMemory", string);
                boolean bl = false;
                if (string2.equals(string)) {
                    bl = true;
                    this.addAndWriteProperty(file, "useImageEncryption", "true");
                }
                if (string3.equals(string)) {
                    bl = true;
                    this.addAndWriteProperty(file, "imageEncryptionPassword", this.generateEncryptionPassword());
                }
                if (string4.equals(string)) {
                    bl = true;
                    this.addAndWriteProperty(file, "maxMemory", "1024m");
                }
                if (bl) {
                    this.logPropertyFileContents(file, "Updated");
                }
            }
            catch (Exception exception) {
                this.logger.log(Level.WARN, new Object[]{"error reading " + file, exception});
            }
        } else {
            this.setupDefaultDeveloperPropertiesFile(file);
            this.logPropertyFileContents(file, "New");
        }
    }

    private void logPropertyFileContents(File file, String string) {
        String string2 = file.readText();
        String string3 = string2.replaceAll("imageEncryptionPassword.*=.*", "imageEncryptionPassword=**************");
        this.logger.debug((Object)(string + " {} = \n{}"), (Object)"deployedge.properties", (Object)string3);
    }

    private void setDefaultProperty(StringBuilder stringBuilder, String string, String string2) {
        this._properties.setProperty(string, string2);
        String string3 = string + "=" + string2 + "\n\n";
        stringBuilder.append(string3);
    }

    private void setupDefaultDeveloperPropertiesFile(File file) {
        this.logger.debug((Object)"no {} found creating one with encryption setup and enabled", (Object)"deployedge.properties");
        String string = this.generateEncryptionPassword();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        this.setDefaultProperty(stringBuilder, "useImageEncryption", "true");
        this.setDefaultProperty(stringBuilder, "imageEncryptionPassword", string);
        this.setDefaultProperty(stringBuilder, "maxMemory", "1024m");
        String string2 = stringBuilder.toString();
        file.write(string2);
    }

    private void addAndWriteProperty(File file, String string, String string2) {
        this.logger.debug((Object)"{} is being updated to have {}", (Object)"deployedge.properties", (Object)string);
        this._properties.setProperty(string, string2);
        String string3 = file.readText() + "\n" + string + "=" + string2 + "\n";
        file.write(string3);
    }

    private String generateEncryptionPassword() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    private String get(String string, String string2) {
        String string3 = this._properties.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    static int getDefaultThumbnailThreadCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public int getThumbnailThreadCount() {
        int n = DeployEdgeProperties.getDefaultThumbnailThreadCount();
        try {
            String string = this.get("thumbnail.threads", "" + n);
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.logger.warn((Object)exception);
        }
        this.logger.debug((Object)("getThumbnailThreadCount() = " + n));
        return n;
    }

    public String getTiffSplit() {
        return this.get("tiffsplit", "tiffsplit.exe");
    }

    public Boolean getIsLocalTest() {
        return Boolean.parseBoolean(this.get("scanning.isLocalTest", "false"));
    }

    public String getCacheServerUrl() {
        return this.get("CacheServerUrl", "");
    }

    public String getDefaultZoom() {
        return this.get("defaultZoom", "1");
    }

    public Boolean getLogAllSpecs() {
        return Boolean.parseBoolean(this.get("scanning.log.specs", "false"));
    }

    public Boolean getUseClScanners() {
        return Boolean.parseBoolean(this.get("scanning.cl", "true"));
    }

    public Boolean getUseCl2Scanners() {
        return Boolean.parseBoolean(this.get("scanning.cl2", "false"));
    }

    public Boolean getUseJtwain() {
        return Boolean.parseBoolean(this.get("scanning.jtwain", "true"));
    }

    public Integer getHttpSocketTimeout() {
        return Integer.parseInt(this.get("http.socketTimeout", "30000"));
    }

    public Boolean getUseImageEncryption() {
        return Boolean.parseBoolean(this.get("useImageEncryption", "false"));
    }

    public String getImageEncryptionPassword() {
        return this.get("imageEncryptionPassword", "");
    }

    public Boolean getCleanupPdfToTifConversionFiles() {
        return Boolean.parseBoolean(this.get("cleanUpPdfToTif", "true"));
    }

    public Boolean getRequireEaxLoginOnStartup() {
        return Boolean.parseBoolean(this.get("requireEaxLoginOnStartup", "true"));
    }

    public String getLongLivedEaxSessionId() {
        return this.get("longLivedEaxSessionId", "");
    }

    public String getFileName() {
        return "deployedge.properties";
    }

    public TimeDuration getHeartbeatFrequency() {
        return TimeDuration.fromMilliseconds((long)Long.parseLong(this.get("heartbeatFrequency", "60000")));
    }

    public String getTiffConversionProfileName() {
        return this.get("tiffConversionProfileName", "Stucki-110");
    }

    public Integer getImagePrefetchThreshold() {
        return Integer.parseInt(this.get("imagePrefetchThreshold", "100"));
    }

    public Integer getImagePrefetchRange() {
        return Integer.parseInt(this.get("imagePrefetchRange", "50"));
    }
}

