/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.core.transaction;

import com.ahsrcm.corp.Authenticator;
import com.ahsrcm.corp.SuperUserAuthenticator;
import com.ahsrcm.corp.User;
import com.ahsrcm.util.UserContext;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.Callable;
import net.java.dev.properties.jdbc.CurrentSession;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.transaction.Transaction;
import net.model3.transaction.TransactionManager;

@Singleton
public class AhsTransactionManager
extends TransactionManager {
    Logger logger = LoggerHelper.getLogger();
    @Inject
    UserContext _userContext;
    @Inject
    SuperUserAuthenticator _superUserAuthenticator;

    @Inject
    private AhsTransactionManager() {
    }

    public <T> T runWithSuperUser(Callable<T> callable) {
        return this.runWith(this._superUserAuthenticator, callable);
    }

    public <T> T runWith(User user, Callable<T> callable) {
        return this.runWith(user.getAuthenticator(), callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runWith(final Authenticator authenticator, Callable<T> callable) {
        Authenticator authenticator2 = null;
        if (authenticator != null) {
            authenticator2 = this._userContext.getAuthenticator();
        }
        try {
            Object object;
            Object object2 = object = this.run(callable, (Transaction.Listener)new Transaction.Adapter(){

                public void start(Transaction transaction) {
                    if (authenticator != null) {
                        AhsTransactionManager.this._userContext.setAuthenticator(authenticator);
                    }
                }

                public void commit(Transaction transaction) {
                    if (CurrentSession.get((boolean)false) != null) {
                        CurrentSession.get().commit();
                    }
                }

                public void finally_(Transaction transaction) {
                    if (CurrentSession.get((boolean)false) != null) {
                        CurrentSession.get().close();
                    }
                }
            });
            return (T)object2;
        }
        finally {
            if (authenticator != null) {
                this._userContext.setAuthenticator(authenticator2);
            }
        }
    }
}

