/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.core.scanning.gui;

import com.ahsrcm.core.crypto.DecryptedData;
import com.ahsrcm.core.crypto.EncryptedData;
import com.ahsrcm.core.scanning.gui.BufferedImageProxy;
import com.ahsrcm.core.scanning.gui.ImageMissingImageProxy;
import com.ahsrcm.core.scanning.gui.ImageProxy;
import com.ahsrcm.core.util.DeployEdgeProperties;
import com.ahsrcm.corp.ScannedImage;
import com.ahsrcm.corp.ScannedImageView;
import com.ahsrcm.scanning.app.client.GetImageResult;
import com.ahsrcm.scanning.dao.DaoBackgroundExecutor;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.ahsrcm.scanning.device.ImageReaderWriter;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.imaging.Rotation;
import net.model3.imaging.Size;
import net.model3.lang.ThreadScheduler;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.File;

public class ScannedImageProxy
extends BufferedImageProxy {
    private static Map<Object, Object> scaleImageRenderingHints_ = new HashMap<Object, Object>();
    private static final Logger logger;
    private static ThreadScheduler _backgoundDownloadScheduler;
    public static final BufferedImageProxy _imageNotUploadedImageProxy;
    public static final BufferedImageProxy _imageNotFoundImageProxy;
    public static final BufferedImageProxy _imageDownloadingImageProxy;
    public static final BufferedImageProxy _imageBeingUnarchivedImageProxy;
    private List<WeakReference<ProxyListener>> _listeners = Collections.synchronizedList(new ArrayList());
    private ScannedImage _scannedImage;
    private ImageTransferState _imageTransferState;
    private Rotation _rotation;
    final ReentrantLock _downloadLock = new ReentrantLock();
    private ImageProxy _proxyImage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadScheduler getBackgoundDownloadScheduler() {
        if (_backgoundDownloadScheduler != null) return _backgoundDownloadScheduler;
        Class<ScannedImageProxy> clazz = ScannedImageProxy.class;
        synchronized (ScannedImageProxy.class) {
            if (_backgoundDownloadScheduler != null) return _backgoundDownloadScheduler;
            _backgoundDownloadScheduler = new ThreadScheduler(((DeployEdgeProperties)DependencyInjector.getInstance(DeployEdgeProperties.class)).getThumbnailThreadCount(), true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return _backgoundDownloadScheduler;
        }
    }

    public ScannedImageProxy(ScannedImage scannedImage) {
        super((File)null, null, "", (Object)scannedImage);
        this._scannedImage = scannedImage;
        this._proxyImage = (Boolean)this._scannedImage.uploaded.get() != false ? new ImageMissingImageProxy(this._scannedImage, _imageDownloadingImageProxy) : new ImageMissingImageProxy(this._scannedImage, _imageNotUploadedImageProxy);
        this._imageTransferState = ImageTransferState.Downloading;
        this.setCacheFullSizeImage(false);
    }

    public boolean existsInLocalCache() {
        return this._scannedImage.getImageFile().exists();
    }

    public void scheduleDownload() {
        if (!this.existsInLocalCache()) {
            logger.debug((Object)"scheduling download for scanned image {}", this._scannedImage.id.get());
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (ScannedImageProxy.this._downloadLock.tryLock()) {
                        try {
                            Long l = ScannedImageProxy.this._scannedImage.getId();
                            if (!ScannedImageProxy.this.existsInLocalCache()) {
                                logger.debug((Object)"downloading image {}", (Object)l);
                                GetImageResult getImageResult = ScannedImageProxy.this._scannedImage.getImageData();
                                if (!ScannedImageProxy.this.existsInLocalCache()) {
                                    ScannedImageProxy.this._imageTransferState = ImageTransferState.TriedDownloading;
                                    ImageProxy imageProxy = ScannedImageProxy.this._proxyImage;
                                    logger.debug((Object)"image {} NOT successfully downloaded", (Object)l);
                                    if (getImageResult != null && getImageResult.getHttpCode() == 440) {
                                        ScannedImageProxy.this._proxyImage = new ImageMissingImageProxy(ScannedImageProxy.this._scannedImage, _imageBeingUnarchivedImageProxy);
                                    } else if (((Boolean)((ScannedImageProxy)ScannedImageProxy.this)._scannedImage.uploaded.get()).booleanValue()) {
                                        ScannedImageProxy.this._proxyImage = new ImageMissingImageProxy(ScannedImageProxy.this._scannedImage, _imageNotUploadedImageProxy);
                                    } else {
                                        ScannedImageProxy.this._proxyImage = new ImageMissingImageProxy(ScannedImageProxy.this._scannedImage, _imageNotFoundImageProxy);
                                    }
                                    if (imageProxy != ScannedImageProxy.this._proxyImage) {
                                        ScannedImageProxy.this.notifyListeners();
                                    }
                                    logger.debug((Object)"image {} successfully downloaded", (Object)l);
                                }
                            }
                            ScannedImageProxy.this.notifyListeners();
                        }
                        finally {
                            ScannedImageProxy.this._downloadLock.unlock();
                        }
                    }
                }
            };
            ScannedImageProxy.getBackgoundDownloadScheduler().submit("thumbnail_downloader", runnable);
        }
    }

    public void notifyListeners() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                List list = ListX.create((Iterable)ScannedImageProxy.this._listeners);
                Collections.reverse(list);
                for (WeakReference weakReference : list) {
                    ProxyListener proxyListener = (ProxyListener)weakReference.get();
                    if (proxyListener == null) {
                        ScannedImageProxy.this._listeners.remove(weakReference);
                        continue;
                    }
                    proxyListener.imageHasChanged();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            DaoBackgroundExecutor.execute(runnable);
        } else {
            runnable.run();
        }
    }

    public void removeListener(ProxyListener proxyListener) {
        for (WeakReference weakReference : ListX.create(this._listeners)) {
            ProxyListener proxyListener2 = (ProxyListener)weakReference.get();
            if (proxyListener2 != null && proxyListener2 != proxyListener) continue;
            this._listeners.remove(weakReference);
        }
    }

    public void addListener(ProxyListener proxyListener) {
        this._listeners.add(new WeakReference<ProxyListener>(proxyListener));
    }

    @Override
    public String getTitle() {
        return "Image " + this._scannedImage.id.get();
    }

    @Override
    public void fullSizeViewEvent() {
        DaoBackgroundExecutor.executeInGuiBackground(new Runnable(){

            @Override
            public void run() {
                ((ScanningDao)ScanningDao.Impl.get()).insert(new ScannedImageView(ScannedImageProxy.this._scannedImage));
            }
        });
    }

    @Override
    public Rotation getRotation() {
        if (this._rotation == null) {
            this._rotation = (Rotation)this._scannedImage.rotation.get();
        }
        return this._rotation;
    }

    @Override
    public void setRotation(Rotation rotation) {
        this.setRotation(rotation, true);
    }

    public void setRotation(Rotation rotation, boolean bl) {
        this._rotation = rotation;
        if (bl) {
            this._scannedImage.rotation.set((Object)rotation);
            DaoBackgroundExecutor.executeInGuiBackground(new Runnable(){

                @Override
                public void run() {
                    ((ScanningDao)ScanningDao.Impl.get()).update(ScannedImageProxy.this._scannedImage);
                }
            });
        }
        this.notifyListeners();
    }

    @Override
    public String getCaption() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("Page " + this._scannedImage.pageNumber.get() + "<br>");
        stringBuilder.append("Patient File " + this._scannedImage.patientFileId.get() + "<br>");
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    @Override
    public BufferedImage getImage(Size size) {
        if (this._scannedImage.getImageFile().exists()) {
            return super.getImage(size, (Rotation)this._scannedImage.rotation.get());
        }
        if (this._imageTransferState == ImageTransferState.Downloading) {
            this.scheduleDownload();
        }
        return this._proxyImage.getImage(size);
    }

    @Override
    public final BufferedImage findImage() {
        if (this._imageTransferState == ImageTransferState.Downloading) {
            this.scheduleDownload();
        }
        return this._proxyImage.getImage();
    }

    @Override
    public final BufferedImage getImage() {
        if (this._scannedImage.getImageFile().exists()) {
            return super.getImage();
        }
        if (this._imageTransferState == ImageTransferState.Downloading) {
            this.scheduleDownload();
        }
        return this._proxyImage.getImage();
    }

    @Override
    protected BufferedImage findAndLoadImage(File file) {
        logger.debug((Object)("findAndLoadImage -- file=" + file.getCanonicalPath()));
        if (this._cryptoEngine.getCryptoHelper().isFileEncrypted(file)) {
            DecryptedData decryptedData = this._cryptoEngine.decrypt(new EncryptedData(file.readBytes()));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(decryptedData.getBytes());
            return ImageReaderWriter.instance.get().loadImage(byteArrayInputStream);
        }
        return ImageReaderWriter.instance.get().loadImage(file);
    }

    @Override
    protected void saveImage(BufferedImage bufferedImage, File file) throws Exception {
        super.saveImage(bufferedImage, file);
    }

    public ScannedImage getScannedImage() {
        return this._scannedImage;
    }

    @Override
    protected BufferedImage createScaledImage(BufferedImage bufferedImage, Size size) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = this.getPreserveAspectRatio();
        Size size2 = new Size(bufferedImage);
        if (bl3) {
            size = size.createAspected(size2, true);
        }
        BufferedImage bufferedImage2 = new BufferedImage(size.getWidth(), size.getHeight(), 12);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.addRenderingHints(scaleImageRenderingHints_);
        graphics2D.drawImage(bufferedImage, 0, 0, size.getWidth(), size.getHeight(), null);
        graphics2D.dispose();
        if (bl) {
            bufferedImage.flush();
        }
        return bufferedImage2;
    }

    @Override
    protected BufferedImage createRotatedImage(BufferedImage bufferedImage, Rotation rotation) {
        int n;
        int n2;
        if (rotation == Rotation.NONE) {
            return bufferedImage;
        }
        int n3 = bufferedImage.getHeight(null);
        int n4 = bufferedImage.getWidth(null);
        if (rotation == Rotation.NINETY || rotation == Rotation.TWO_SEVENTY) {
            n2 = n4;
            n = n3;
        } else {
            n2 = n3;
            n = n4;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 12);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        if (rotation == Rotation.NINETY) {
            graphics2D.rotate(rotation.getRadians(), n3 / 2, n3 / 2);
        } else if (rotation == Rotation.ONE_EIGHTY) {
            graphics2D.rotate(rotation.getRadians(), n4 / 2, n3 / 2);
        } else if (rotation == Rotation.TWO_SEVENTY) {
            graphics2D.rotate(rotation.getRadians(), n4 / 2, n4 / 2);
        }
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    @Override
    public String getUuid() {
        return this._scannedImage.getImageProxyUuid();
    }

    @Override
    protected String getFileExtension() {
        return "tiff";
    }

    @Override
    public boolean visible() {
        return this._scannedImage.isActive();
    }

    @Override
    public String getQualifiedName() {
        return this.getUuid();
    }

    @Override
    public File getImageLocationAsFile() {
        return this._scannedImage.getImageFile();
    }

    static {
        scaleImageRenderingHints_.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        logger = LoggerHelper.getLogger(ScannedImageProxy.class);
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("_image-not-found.jpg");
        _imageNotFoundImageProxy = new BufferedImageProxy(uRL, "image-not-found", "", null);
        _imageNotFoundImageProxy.setKeepImageInMemory(true);
        uRL = Thread.currentThread().getContextClassLoader().getResource("_image-not-uploaded-yet.jpg");
        _imageNotUploadedImageProxy = new BufferedImageProxy(uRL, "image-not-uploaded", "", null);
        _imageNotUploadedImageProxy.setKeepImageInMemory(true);
        uRL = Thread.currentThread().getContextClassLoader().getResource("_image-is-downloading.jpg");
        _imageDownloadingImageProxy = new BufferedImageProxy(uRL, "image-is-downloading", "", null);
        _imageDownloadingImageProxy.setKeepImageInMemory(true);
        uRL = Thread.currentThread().getContextClassLoader().getResource("_image-being-unarchived.jpg");
        _imageBeingUnarchivedImageProxy = new BufferedImageProxy(uRL, "image-being-unarchived", "", null);
        _imageBeingUnarchivedImageProxy.setKeepImageInMemory(true);
    }

    public static interface ProxyListener {
        public void imageHasChanged();
    }

    static enum ImageTransferState {
        GotIt,
        TriedDownloading,
        Downloading;

    }
}

