/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.core.scanning.gui;

import com.ahsrcm.core.crypto.CryptoEngine;
import com.ahsrcm.core.crypto.DecryptedData;
import com.ahsrcm.core.crypto.EncryptedData;
import com.ahsrcm.core.scanning.gui.ImageProxy;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.ahsrcm.util.guice.Directories;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import javax.imageio.ImageIO;
import net.model3.guice.DependencyInjector;
import net.model3.imaging.ImageUtils;
import net.model3.imaging.Rotation;
import net.model3.imaging.Size;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import net.model3.newfile.File;

public abstract class AbstractImageProxy
implements ImageProxy {
    private static final Logger logger = LoggerHelper.getLogger();
    private URL _imageLocationAsURL;
    private File _imageLocationAsFile;
    private Size _imageSize;
    private String _title;
    private String _caption;
    private String _uuid;
    private String _qualifiedName;
    private boolean _keepImageInMemory = false;
    private boolean _cacheFullSizeImage = true;
    private Rotation _rotation = Rotation.NONE;
    private ImageReferant _image;
    ScanningDao _scanningDao = (ScanningDao)DependencyInjector.getInstance(ScanningDao.class);
    CryptoEngine _cryptoEngine = (CryptoEngine)DependencyInjector.getInstance(CryptoEngine.class);

    protected BufferedImage createRotatedImage(BufferedImage bufferedImage, Rotation rotation) {
        return ImageUtils.createRotatedImage((Image)bufferedImage, (Rotation)rotation);
    }

    protected BufferedImage createScaledImage(BufferedImage bufferedImage, Size size) {
        BufferedImage bufferedImage2 = ImageUtils.createScaledImage((BufferedImage)bufferedImage, (Size)size, (boolean)true, (boolean)false, (boolean)this.getPreserveAspectRatio());
        return bufferedImage2;
    }

    public void setImageLocation(URL uRL) {
        this._imageLocationAsURL = uRL;
    }

    public void setImageLocation(File file) {
        this._imageLocationAsFile = file;
    }

    protected void setImageSize(Size size) {
        this._imageSize = size;
    }

    @Override
    public Size getImageSize() {
        if (this._imageSize == null || this._imageSize.getHeight() == 0 || this._imageSize.getWidth() == 0) {
            this._imageSize = new Size(this.getImage());
        }
        return this._imageSize;
    }

    public File getImageLocationAsFile() {
        return this._imageLocationAsFile;
    }

    public BufferedImage getLoadImage(File file) {
        try {
            if (file != null) {
                logger.debug((Object)"loading image {}", (Object)file.getCanonicalPath());
                return this.findAndLoadImage(file);
            }
            logger.debug((Object)"loading image {}", (Object)this._imageLocationAsURL);
            return this.findAndLoadImage(this._imageLocationAsURL);
        }
        catch (Exception exception) {
            logger.error((Object)exception);
            throw new RuntimeException(exception);
        }
    }

    public BufferedImage findAndLoadImage() {
        File file;
        try {
            file = this.getImageLocationAsFile();
        }
        catch (Exception exception) {
            logger.error((Object)exception);
            throw new RuntimeException(exception);
        }
        Boolean bl = file != null;
        try {
            if (bl.booleanValue()) {
                logger.debug((Object)"loading image {}", (Object)file.getCanonicalPath());
                return this.findAndLoadImage(file);
            }
            logger.debug((Object)"loading image {}", (Object)this._imageLocationAsURL);
            return this.findAndLoadImage(this._imageLocationAsURL);
        }
        catch (Exception exception) {
            logger.warn((Object)"findAndLoadImage -- 1st try failed on", (Object)exception);
            if (bl.booleanValue()) {
                File file2 = this._cryptoEngine.getCryptoHelper().isFileEncrypted(file) ? new File(this._cryptoEngine.getCryptoHelper().getNameWithoutEncryptionExtension(file.getCanonicalPath())) : new File(file.getCanonicalPath() + this._cryptoEngine.getCryptoHelper().getEncryptedFileExtension());
                return this.getLoadImage(file2);
            }
            logger.error((Object)exception);
            throw new RuntimeException(exception);
        }
    }

    @Override
    public BufferedImage getImage() {
        BufferedImage bufferedImage = null;
        if (this._image != null) {
            bufferedImage = this._image.get();
        }
        if (bufferedImage == null) {
            bufferedImage = this.findAndLoadImage();
            if (this._cacheFullSizeImage) {
                if (this._keepImageInMemory) {
                    final BufferedImage bufferedImage2 = bufferedImage;
                    this._image = new ImageReferant(){

                        @Override
                        public BufferedImage get() {
                            return bufferedImage2;
                        }
                    };
                } else {
                    final WeakReference<BufferedImage> weakReference = new WeakReference<BufferedImage>(bufferedImage);
                    this._image = new ImageReferant(){

                        @Override
                        public BufferedImage get() {
                            return (BufferedImage)weakReference.get();
                        }
                    };
                }
            }
        }
        return bufferedImage;
    }

    @Override
    public BufferedImage getImage(Size size) {
        return this.getImage(size, Rotation.NONE);
    }

    @Override
    public BufferedImage getImage(Size size, Rotation rotation) {
        Object object;
        BufferedImage bufferedImage;
        logger.debug((Object)"getting image {} size {} rotation {}", (Object)this.getUuid(), (Object)size, (Object)rotation);
        if (size == null) {
            bufferedImage = this.getImage();
        } else {
            object = this.getCachedFile(size);
            if (!object.exists()) {
                logger.debug((Object)"scaling original image thumbnail doesn't exist");
                BufferedImage bufferedImage2 = this.getImage();
                BufferedImage bufferedImage3 = this.createScaledImage(bufferedImage2, size);
                this.writeThumbnail(size, (File)object, bufferedImage3);
                bufferedImage = bufferedImage3;
            } else {
                logger.debug((Object)"loading thumbnail");
                bufferedImage = this.findAndLoadImage((File)object);
            }
        }
        if (rotation != null && rotation != Rotation.NONE) {
            logger.debug((Object)"rotating image");
            object = bufferedImage;
            bufferedImage = this.createRotatedImage((BufferedImage)object, rotation);
        }
        logger.debug((Object)"completed getting image {} size {} rotation {}", (Object)this.getUuid(), (Object)size, (Object)rotation);
        return bufferedImage;
    }

    protected BufferedImage findAndLoadImage(File file) {
        logger.debug((Object)("findAndLoadImage -- file=" + file.getCanonicalPath()));
        try {
            if (this._cryptoEngine.getCryptoHelper().isFileEncrypted(file)) {
                DecryptedData decryptedData = this._cryptoEngine.decrypt(new EncryptedData(file.readBytes()));
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(decryptedData.getBytes());
                return ImageIO.read(byteArrayInputStream);
            }
            return ImageIO.read(file.asFile());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected BufferedImage findAndLoadImage(URL uRL) {
        try {
            return ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected void saveImage(BufferedImage bufferedImage, File file) throws Exception {
        if (this._scanningDao.useImageEncryption().booleanValue()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, this.getImageIoFormatName(), byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            EncryptedData encryptedData = this._cryptoEngine.encrypt(new DecryptedData(byArray));
            String string = "";
            if (!this._cryptoEngine.getCryptoHelper().isFileEncrypted(file)) {
                string = this._cryptoEngine.getCryptoHelper().getEncryptedFileExtension();
            }
            File file2 = new File(file.getCanonicalPath() + string);
            file2.write(encryptedData.getBytes());
            byteArrayOutputStream.close();
        } else {
            ImageIO.write((RenderedImage)bufferedImage, this.getImageIoFormatName(), file.asCanonicalFile());
        }
    }

    protected void writeThumbnail(Size size, File file, BufferedImage bufferedImage) {
        try {
            this.saveImage(bufferedImage, file);
        }
        catch (Exception exception) {
            throw new RuntimeException("error creating thumbnail " + size + " for " + this.getQualifiedName(), exception);
        }
    }

    protected String getFileExtension() {
        return "jpeg";
    }

    protected String getImageIoFormatName() {
        return "jpeg";
    }

    protected File getCachedFile(Size size) {
        String string = this.getUuid() + "-" + this.getRotation() + "-" + size + "." + this.getFileExtension();
        if (this._scanningDao.useImageEncryption().booleanValue()) {
            string = string + this._cryptoEngine.getCryptoHelper().getEncryptedFileExtension();
        }
        return AbstractImageProxy.getThumbnailDirectory().file(string);
    }

    public static Directory getThumbnailDirectory() {
        return ((Directories)DependencyInjector.getInstance(Directories.class)).thumbnails();
    }

    @Override
    public String getUuid() {
        return this._uuid;
    }

    public void setUuid(String string) {
        this._uuid = string;
    }

    @Override
    public String getQualifiedName() {
        if (this._qualifiedName == null) {
            this._qualifiedName = this.getUuid();
        }
        return this._qualifiedName;
    }

    public void setQualifiedName(String string) {
        this._qualifiedName = string;
    }

    @Override
    public String getTitle() {
        if (this._title == null) {
            return this.getUuid();
        }
        return this._title;
    }

    public void setTitle(String string) {
        this._title = string;
    }

    @Override
    public String getCaption() {
        if (this._caption == null) {
            this.setCaption(this.getTitle());
        }
        return this._caption;
    }

    public void setCaption(String string) {
        this._caption = string;
    }

    @Override
    public Rotation getRotation() {
        return this._rotation;
    }

    @Override
    public void setRotation(Rotation rotation) {
        this._rotation = rotation;
    }

    public void setKeepImageInMemory(boolean bl) {
        this._keepImageInMemory = bl;
    }

    public void setCacheFullSizeImage(boolean bl) {
        this._cacheFullSizeImage = bl;
    }

    static interface ImageReferant {
        public BufferedImage get();
    }
}

