/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.core.logs;

import com.ahsrcm.client.tools.ServerUrlProvider;
import com.ahsrcm.client.tools.SessionIdProvider;
import com.ahsrcm.client.tools.login.LoginPopup;
import com.ahsrcm.client.tools.login.LoginTool;
import com.ahsrcm.client.tools.ui.EnterKeyListener;
import com.ahsrcm.core.logs.LogSender;
import com.google.inject.Inject;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import net.model3.guice.DependencyInjector;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3x.swing.M3Panel;

public class LogSenderUI {
    public static final String Path = "/api/uploadLogs";
    private static final Logger logger = LoggerHelper.getLogger();
    @Inject
    ServerUrlProvider _urlProvider;
    @Inject
    SessionIdProvider _sessionIdProvider;
    @Inject
    LoginPopup _loginPopup;
    @Inject
    LoginTool _loginTool;

    @Inject
    private LogSenderUI() {
    }

    public void run() {
        logger.debug((Object)"started");
        this._loginPopup.withValidLogin(new LoginPopup.CallBack(){

            public void loggedIn(String string) {
                if (!((String)LogSenderUI.this._sessionIdProvider.get()).equals(string)) {
                    LogSenderUI.this._sessionIdProvider.set((Object)string);
                }
                LogSenderUI.this.getDetails();
            }

            public void cancelled() {
            }
        });
        logger.debug((Object)"completed");
    }

    private void getDetails() {
        final JFrame jFrame = new JFrame("Bug Report");
        M3Panel m3Panel = new M3Panel();
        jFrame.add((Component)m3Panel);
        m3Panel.add((Component)new JLabel("Please describe what you were doing when the bug occurred"), (Object)"spanx, wrap");
        final JTextArea jTextArea = new JTextArea(3, 40);
        m3Panel.add((Component)jTextArea, (Object)"spanx, wrap");
        JButton jButton = new JButton(new AbstractAction("Submit"){
            private static final long serialVersionUID = -8656488343570935805L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    LogSender logSender = (LogSender)DependencyInjector.getInstance(LogSender.class);
                    logSender.setMessage(jTextArea.getText());
                    logSender.run();
                    JOptionPane.showMessageDialog(jFrame, "Please notify support that logs have been submitted.", "Succesful Submission", 1);
                }
                catch (RuntimeException runtimeException) {
                    logger.error((Object)"error sending logs", (Object)actionEvent);
                    JOptionPane.showMessageDialog(jFrame, "Log uploading failed. Please contact support.", "Failed Submission", 0);
                }
                jFrame.dispose();
            }
        });
        m3Panel.add((Component)jButton);
        m3Panel.add((Component)new JButton(new AbstractAction("Cancel"){
            private static final long serialVersionUID = 6006292603361674246L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logger.debug((Object)"User cancelled");
                jFrame.dispose();
            }
        }));
        EnterKeyListener enterKeyListener = new EnterKeyListener(jButton);
        jFrame.addKeyListener((KeyListener)enterKeyListener);
        jButton.addKeyListener((KeyListener)enterKeyListener);
        jFrame.pack();
        jFrame.setDefaultCloseOperation(2);
        jFrame.setVisible(true);
    }
}

