/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.core.logs;

import com.ahsrcm.client.tools.ServerUrlProvider;
import com.ahsrcm.client.tools.SessionIdProvider;
import com.ahsrcm.client.tools.login.LoginTool;
import com.google.inject.Inject;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import net.model3.chrono.DateOnly;
import net.model3.chrono.DateTime;
import net.model3.collections.SetX;
import net.model3.guice.bootstrap.LogDirectory;
import net.model3.io.IOHelper;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.net.UrlX;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public class LogSender {
    public static final String Path = "/api/uploadLogs";
    private static final Logger logger = LoggerHelper.getLogger();
    String _message;
    DateOnly _today = new DateOnly();
    Set<File> _logFiles = SetX.create();
    @Inject
    ServerUrlProvider _serverUrlProvider;
    @Inject
    SessionIdProvider _sessionIdProvider;
    @Inject
    LoginTool _loginTool;
    @Inject
    LogDirectory _logDirectory;

    @Inject
    private LogSender() {
    }

    public void run() {
        logger.debug((Object)"started");
        this.gather((Directory)this._logDirectory.get());
        this.gather(LogDirectory.getArchivesDir((LogDirectory)this._logDirectory));
        this.send();
        logger.debug((Object)"completed");
    }

    void gather(Directory directory) {
        DateTime dateTime = new DateTime().addDays(-1);
        for (File file : directory.files()) {
            if (!file.getLastModified().after(dateTime)) continue;
            this._logFiles.add(file);
        }
    }

    String getUsername() {
        if (StringX.isNotBlank((String)((String)this._sessionIdProvider.get()))) {
            return this._loginTool.getUserLoginName((String)this._sessionIdProvider.get());
        }
        return null;
    }

    File createTempZipFile() {
        try {
            byte[] byArray = new byte[8192];
            String string = this.getUsername();
            string = string == null ? "" : string + "-";
            File file = new File("logs-" + string + File.getFileSystemCompatibleTimestamp() + ".zip");
            ZipOutputStream zipOutputStream = new ZipOutputStream(file.createOutputStream());
            for (File file2 : this._logFiles) {
                int n;
                FileInputStream fileInputStream = file2.createInputStream();
                zipOutputStream.putNextEntry(new ZipEntry(file2.getName()));
                while ((n = fileInputStream.read(byArray)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
                fileInputStream.close();
                zipOutputStream.closeEntry();
            }
            this.loadScreenShots(zipOutputStream);
            zipOutputStream.putNextEntry(new ZipEntry("empty"));
            zipOutputStream.write("".getBytes());
            zipOutputStream.closeEntry();
            if (this._message != null) {
                zipOutputStream.putNextEntry(new ZipEntry("notes.txt"));
                zipOutputStream.write(this._message.getBytes());
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
            return file;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    void send() {
        HttpClient httpClient = new HttpClient();
        File file = this.createTempZipFile();
        file.asFile().deleteOnExit();
        try {
            UrlX urlX = ((UrlX)this._serverUrlProvider.get()).subPath(Path);
            PutMethod putMethod = new PutMethod(urlX.toString() + "?sess=" + (String)this._sessionIdProvider.get());
            putMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)file.createInputStream()));
            logger.debug((Object)"sending {} to {}", (Object)file, (Object)putMethod.getURI());
            httpClient.executeMethod((HttpMethod)putMethod);
            String string = IOHelper.readFully((Reader)new InputStreamReader(putMethod.getResponseBodyAsStream()));
            if (putMethod.getStatusCode() != 200) {
                logger.error((Object)"unable to upload logs\n{} - {}\n{}", (Object)putMethod.getStatusCode(), (Object)putMethod.getStatusText(), (Object)string);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            try {
                file.delete();
            }
            catch (Exception exception) {}
        }
    }

    void setMessage(String string) {
        this._message = string;
    }

    private void loadScreenShots(ZipOutputStream zipOutputStream) {
        int n = 1;
        for (Window window : Window.getWindows()) {
            if (!window.isVisible()) continue;
            BufferedImage bufferedImage = new BufferedImage(window.getWidth(), window.getHeight(), 5);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            window.paint(graphics2D);
            graphics2D.dispose();
            try {
                zipOutputStream.putNextEntry(new ZipEntry("window" + n + ".png"));
                ImageIO.write((RenderedImage)bufferedImage, "png", zipOutputStream);
                zipOutputStream.closeEntry();
            }
            catch (Exception exception) {
                logger.warn((Object)exception);
            }
            ++n;
        }
    }
}

