/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.core.logs;

import com.ahsrcm.core.logs.LogFileRoller;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import net.model3.chrono.DateTime;
import net.model3.chrono.Month;
import net.model3.chrono.TimeOnly;
import net.model3.collections.SetX;
import net.model3.guice.bootstrap.LogDirectory;
import net.model3.io.Pipe;
import net.model3.lang.ThreadScheduler;
import net.model3.lang.TimeDuration;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.logging.SimpleLoggingConfigurator;
import net.model3.newfile.Directory;
import net.model3.newfile.File;

@Singleton
public class LogFileRollerImpl
implements LogFileRoller {
    Logger logger = LoggerHelper.getLogger();
    Set<Pattern> _datePatterns = SetX.create((Object[])new Pattern[]{Pattern.compile("^.*(\\d{4})-(\\d\\d)-(\\d\\d).....(\\d\\d)-(\\d\\d)-(\\d\\d).*$"), Pattern.compile("^.*(\\d{4})(\\d\\d)(\\d\\d)-(\\d\\d)(\\d\\d)(\\d\\d)$")});
    @Inject
    LogDirectory _logDirectory;
    Runnable _runnable = new Runnable(){

        @Override
        public void run() {
            LogFileRollerImpl.this.rollLogs();
        }
    };

    public static void main(String[] stringArray) {
        new SimpleLoggingConfigurator().addConsoleAppender();
        new LogFileRollerImpl().rollLogs();
    }

    public LogFileRollerImpl() {
    }

    @Inject
    protected LogFileRollerImpl(ThreadScheduler threadScheduler) {
        threadScheduler.schedule("logFileRoller", new TimeDuration("5 minutes"), this._runnable);
        threadScheduler.scheduleDaily("logFileRoller", new TimeOnly("1am"), this._runnable);
    }

    public DateTime getDate(File file) {
        for (Pattern pattern : this._datePatterns) {
            Matcher matcher = pattern.matcher(file.getName());
            if (!matcher.matches()) continue;
            try {
                return new DateTime(Integer.parseInt(matcher.group(1)), Month.fromNumber((int)Integer.parseInt(matcher.group(2))), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)));
            }
            catch (Exception exception) {
                this.logger.debug((Object)"unable to parse {}", (Object)file.getName(), (Object)exception);
            }
        }
        return file.getLastModified();
    }

    public void rollLogs() {
        try {
            this.logger.debug((Object)"rollLogs() start");
            this.processLogsDirectory();
            this.processLogArchivesDirectory();
        }
        catch (Exception exception) {
            this.logger.error((Object)exception);
        }
    }

    void processLogsDirectory() {
        DateTime dateTime = new DateTime().addDays(-2);
        Directory directory = LogDirectory.getArchivesDir((LogDirectory)this._logDirectory);
        for (File file : ((Directory)this._logDirectory.get()).files()) {
            DateTime dateTime2 = this.getDate(file);
            if (!dateTime2.before(dateTime)) continue;
            this.logger.debug((Object)"moving {} to archives", (Object)file);
            try {
                new Pipe((InputStream)file.createInputStream(), (OutputStream)new GZIPOutputStream(new File(directory, file.getName() + ".gz").createOutputStream())).run();
                file.delete();
            }
            catch (Exception exception) {
                this.logger.warn((Object)"unable to mvoe log file {} to {}", (Object)file, (Object)directory, (Object)exception);
            }
        }
    }

    void processLogArchivesDirectory() {
        DateTime dateTime = new DateTime().addDays(-14);
        for (File file : LogDirectory.getArchivesDir((LogDirectory)this._logDirectory).files()) {
            DateTime dateTime2 = this.getDate(file);
            if (!dateTime2.before(dateTime)) continue;
            try {
                this.logger.debug((Object)"deleting {} to archives", (Object)file);
                file.delete();
            }
            catch (Exception exception) {
                this.logger.warn((Object)"unable to delete log file {}", (Object)file, (Object)exception);
            }
        }
    }
}

