/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.core.localcacheclient;

import com.ahsrcm.core.localcacheclient.PdfToTifConfig;
import com.ahsrcm.scanning.app.client.ConvertImageResult;
import com.ahsrcm.scanning.app.server.ServerAppConfig;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import net.model3.lang.Executor;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import net.model3.newfile.File;

public abstract class PdfToTifConverter {
    private static final Logger logger = LoggerHelper.getLogger();
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
    private final PdfToTifConfig _config;

    public PdfToTifConverter(ServerAppConfig serverAppConfig) {
        this._config = serverAppConfig.getPdfToTifConfig();
    }

    protected abstract String createCommand(File var1, File var2, String var3);

    public ConvertImageResult convertPdfToTif(InputStream inputStream, String string) {
        Directory directory = null;
        try {
            directory = this.createWorkingDir();
            File file = new File(directory, "in.pdf");
            File file2 = new File(directory, "out.tif");
            logger.debug((Object)("pdfFile=" + file.getCanonicalPath()));
            logger.debug((Object)("tifFile=" + file2.getCanonicalPath()));
            file.write(inputStream);
            String string2 = this.createCommand(file, file2, string);
            logger.debug((Object)("convertCmd=" + string2));
            Executor executor = new Executor();
            executor.setCurrentDirectory(directory);
            executor.setCommandLine(string2);
            executor.execute();
            String string3 = executor.getLastError();
            if (StringX.isNotBlank((String)string3)) {
                logger.debug((Object)("Std Err -> " + string3));
            }
            logger.debug((Object)("Std Out -> " + executor.getLastOutput()));
            logger.debug((Object)("Exit Code -> " + executor.getLastResult()));
            if (executor.getLastResult() != 0) {
                throw new RuntimeException("Error running command -- " + executor.getCommandLine());
            }
            return new ConvertImageResult(true, file2, directory);
        }
        catch (Exception exception) {
            logger.error((Object)"Error converting PDF to TIF file", (Object)exception);
            return new ConvertImageResult(false, null, directory);
        }
    }

    public void deleteWorkingDir(ConvertImageResult convertImageResult) {
        try {
            if (this._config.getCleanUpAfterConversion()) {
                if (convertImageResult.getWorkingDir() != null) {
                    convertImageResult.getWorkingDir().deleteTree();
                }
            } else {
                logger.warn((Object)"clean up after conversion turned off. this could cause disk space issues in the future");
            }
        }
        catch (Exception exception) {
            logger.warn((Object)("clean up failed for " + convertImageResult.getWorkingDir().getCanonicalPath()));
        }
    }

    private Directory createWorkingDir() {
        String string = dateFormat.format(new Date()) + "_" + UUID.randomUUID().toString().replace("-", "");
        Directory directory = new Directory(this._config.getTempWorkingDirectory()).subdir(string);
        logger.debug((Object)("workingDir=" + directory.getCanonicalPath()));
        if (!directory.exists()) {
            directory.makeDirectories();
        }
        return directory;
    }
}

