/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.core.localcacheclient;

import com.ahsrcm.core.localcacheclient.LoomConfig;
import com.ahsrcm.scanning.app.client.GetImageResult;
import java.net.MalformedURLException;
import java.net.URL;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.net.UrlX;
import net.model3.servlet.HttpResponseException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.BasicScheme;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public abstract class LoomProvider {
    static final Logger logger = LoggerHelper.getLogger();
    HttpClient _client;
    LoomConfig _config;
    UsernamePasswordCredentials _credentials;
    UrlX _baseUrl;
    byte[] _empty = null;

    public LoomProvider(LoomConfig loomConfig) {
        this._config = loomConfig;
        this._baseUrl = new UrlX(loomConfig.getBaseUrl());
        this._credentials = new UsernamePasswordCredentials(loomConfig.getUsername(), loomConfig.getPassword());
    }

    public void makeDirectories(String string) {
        String[] stringArray = string.split("/");
        String string2 = "";
        for (String string3 : stringArray) {
            string2 = string2 + string3 + "/";
            UrlX urlX = new UrlX(this.getBaseUrl(), string2);
            if (this.executeHead(urlX)) continue;
            this.executeMkcol(urlX);
        }
    }

    public GetImageResult executeGet(UrlX urlX) {
        GetMethod getMethod = new GetMethod();
        byte[] byArray = this.executeRequest((HttpMethodBase)getMethod, urlX);
        if (getMethod.getStatusCode() == 200) {
            return new GetImageResult(200, byArray);
        }
        if (getMethod.getStatusCode() == 404 || getMethod.getStatusCode() == 440) {
            this.logResponseWarning((HttpMethodBase)getMethod, urlX, byArray);
            return new GetImageResult(getMethod.getStatusCode(), this._empty);
        }
        throw this.createHttpResponseException((HttpMethodBase)getMethod, urlX, byArray);
    }

    public boolean executeHead(UrlX urlX) {
        HeadMethod headMethod = new HeadMethod();
        byte[] byArray = this.executeRequest((HttpMethodBase)headMethod, urlX);
        if (headMethod.getStatusCode() == 200) {
            return true;
        }
        if (headMethod.getStatusCode() == 404) {
            this.logResponseWarning((HttpMethodBase)headMethod, urlX, byArray);
            return false;
        }
        throw this.createHttpResponseException((HttpMethodBase)headMethod, urlX, byArray);
    }

    public void executeMkcol(UrlX urlX) {
        HttpMethodBase httpMethodBase = new HttpMethodBase(){
            {
                this.setFollowRedirects(true);
            }

            public String getName() {
                return "MKCOL";
            }
        };
        byte[] byArray = this.executeRequest(httpMethodBase, urlX);
        if (httpMethodBase.getStatusCode() != 201) {
            throw this.createHttpResponseException(httpMethodBase, urlX, byArray);
        }
    }

    public void executePut(UrlX urlX, byte[] byArray) {
        PutMethod putMethod = new PutMethod();
        putMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(byArray));
        byte[] byArray2 = this.executeRequest((HttpMethodBase)putMethod, urlX);
        if (putMethod.getStatusCode() != 200) {
            throw this.createHttpResponseException((HttpMethodBase)putMethod, urlX, byArray2);
        }
    }

    public static UrlX resolveUrlX(UrlX urlX) throws MalformedURLException {
        java.net.URI uRI = UrlX.toURI((URL)urlX.asUrl());
        UrlX urlX2 = new UrlX(uRI.toURL());
        return urlX2;
    }

    public byte[] executeRequest(HttpMethodBase httpMethodBase, UrlX urlX) {
        UrlX urlX2 = urlX;
        try {
            urlX2 = LoomProvider.resolveUrlX(urlX);
            httpMethodBase.setURI(new URI(urlX2.toString(), true));
            if (StringX.isBlank((String)this._config.getAuthToken())) {
                httpMethodBase.addRequestHeader("Authorization", BasicScheme.authenticate((UsernamePasswordCredentials)this._credentials, (String)"UTF-8"));
            } else {
                httpMethodBase.addRequestHeader("X-SESS", this._config.getAuthToken());
            }
            logger.debug((Object)"Executing remote request {} {}", (Object)httpMethodBase.getName(), (Object)urlX2);
            this.getClient().executeMethod((HttpMethod)httpMethodBase);
            byte[] byArray = httpMethodBase.getResponseBody();
            return byArray;
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Exception executing remote action %s %s", httpMethodBase.getName(), urlX2), exception);
        }
        finally {
            try {
                httpMethodBase.releaseConnection();
            }
            catch (Exception exception) {
                logger.error((Object)"Swallowed exception while releasing http connection", (Object)exception);
            }
        }
    }

    public HttpResponseException createHttpResponseException(HttpMethodBase httpMethodBase, UrlX urlX, byte[] byArray) {
        this.logResponseWarning(httpMethodBase, urlX, byArray);
        String string = null;
        if (byArray != null) {
            string = new String(byArray);
        }
        return new HttpResponseException(String.format("Invalid status code in response to request to %s %s%n%s - %s%n%s", httpMethodBase.getName(), urlX, httpMethodBase.getStatusCode(), httpMethodBase.getStatusText(), string), httpMethodBase.getStatusCode());
    }

    public void logResponseWarning(HttpMethodBase httpMethodBase, UrlX urlX, byte[] byArray) {
        String string = null;
        if (byArray != null) {
            string = new String(byArray);
        }
        logger.warn((Object)"method {} to {} response {}", (Object)httpMethodBase.getName(), (Object)urlX, (Object)string);
    }

    public HttpClient getClient() {
        if (this._client == null) {
            throw new RuntimeException("_client has not been set");
        }
        return this._client;
    }

    public void setClient(HttpClient httpClient) {
        this._client = httpClient;
    }

    public UrlX getBaseUrl() {
        return this._baseUrl;
    }
}

