/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.core.localcacheclient;

import com.ahsrcm.core.localcacheclient.LoomProvider;
import com.ahsrcm.core.localcacheclient.RemoteImageProvider;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.scanning.app.client.GetImageResult;
import com.ahsrcm.scanning.app.server.ServerAppConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import net.model3.net.UrlX;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;

@Singleton
public class LoomImageProvider
extends LoomProvider
implements RemoteImageProvider {
    @Inject
    public LoomImageProvider(ServerAppConfig serverAppConfig) {
        super(serverAppConfig.getLoomConfig());
        MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
        super.setClient(new HttpClient((HttpConnectionManager)multiThreadedHttpConnectionManager));
    }

    @Override
    public GetImageResult getImageData(String string, long l, long l2, int n) {
        String string2 = l2 + "-" + n + ".tiff";
        String string3 = ScanBatch.getImagePath(l);
        String string4 = string3 + "/" + string2;
        GetImageResult getImageResult = this.executeGet(new UrlX(this.getBaseUrl(), string4));
        return getImageResult;
    }

    @Override
    public boolean imageDataExists(String string, long l, long l2, int n) {
        String string2 = l2 + "-" + n + ".tiff";
        String string3 = ScanBatch.getImagePath(l);
        String string4 = string3 + "/" + string2;
        return this.executeHead(new UrlX(this.getBaseUrl(), string4));
    }

    @Override
    public void uploadImageData(String string, long l, long l2, int n, byte[] byArray) {
        String string2 = l2 + "-" + n + ".tiff";
        String string3 = ScanBatch.getImagePath(l);
        String string4 = string3 + "/" + string2;
        this.makeDirectories(string3);
        this.executePut(new UrlX(this.getBaseUrl(), string4), byArray);
    }
}

