/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.core.localcacheclient;

import com.ahsrcm.core.localcacheclient.ImageProvider;
import com.ahsrcm.core.localcacheclient.RemoteImageProvider;
import com.ahsrcm.scanning.app.client.GetImageResult;
import com.ahsrcm.scanning.rpc.UpStreamServerUrlProvider;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.InputStream;
import net.model3.io.IOHelper;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.net.UrlX;
import net.model3.servlet.HttpResponseException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

@Singleton
public class HttpImageProvider
implements RemoteImageProvider {
    private static final Logger logger = LoggerHelper.getLogger();
    final HttpClient _client;
    @Inject
    UpStreamServerUrlProvider _urlProvider;

    @Inject
    private HttpImageProvider() {
        MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
        this._client = new HttpClient((HttpConnectionManager)multiThreadedHttpConnectionManager);
    }

    @Override
    public GetImageResult getImageData(String string, long l, long l2, int n) {
        try {
            GetImageResult getImageResult = (GetImageResult)this.executeRemotely(string, "getImageData/" + l + "/" + l2 + "/" + n, new HttpResponseCallback(){

                @Override
                public Object processResponse(PostMethod postMethod) throws Exception {
                    if (postMethod.getStatusCode() == 200) {
                        return new GetImageResult(200, IOHelper.readFully((InputStream)postMethod.getResponseBodyAsStream()));
                    }
                    return new GetImageResult(postMethod.getStatusCode(), ImageProvider._empty);
                }
            });
            return getImageResult;
        }
        catch (HttpResponseException httpResponseException) {
            return new GetImageResult(httpResponseException.getResponseStatusCode(), _empty);
        }
    }

    @Override
    public boolean imageDataExists(String string, long l, long l2, int n) {
        return true;
    }

    @Override
    public void uploadImageData(String string, long l, long l2, int n, final byte[] byArray) {
        this.executeRemotely(string, "uploadImageData/" + l + "/" + l2 + "/" + n, new HttpResponseCallback(){

            @Override
            void prepareRequest(PostMethod postMethod) throws Exception {
                postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(byArray));
            }
        });
    }

    <T> T executeRemotely(String string, String string2, HttpResponseCallback httpResponseCallback) {
        if (this._urlProvider.get() == null) {
            throw new RuntimeException("no upstream url provided");
        }
        return this.executeRemotelyAttempt(((UrlX)this._urlProvider.get()).getRootUrl(), string, string2, httpResponseCallback);
    }

    <T> T executeRemotelyAttempt(UrlX urlX, String string, String string2, HttpResponseCallback httpResponseCallback) {
        UrlX urlX2 = new UrlX(urlX, "/localCacheService/" + string2 + "?sess=" + string);
        PostMethod postMethod = new PostMethod();
        try {
            postMethod.setURI(new URI(urlX2.toString(), true));
            logger.debug((Object)"executing remote request {}", (Object)urlX2);
            httpResponseCallback.prepareRequest(postMethod);
            int n = this._client.executeMethod((HttpMethod)postMethod);
            if (n < 200 || n > 299) {
                byte[] byArray = IOHelper.readFully((InputStream)postMethod.getResponseBodyAsStream());
                throw new HttpResponseException("invalid status code " + n + " in response to request to " + urlX2 + "\n" + postMethod.getStatusCode() + " - " + postMethod.getStatusText() + "\n" + new String(byArray), n);
            }
            Object object = httpResponseCallback.processResponse(postMethod);
            return (T)object;
        }
        catch (HttpResponseException httpResponseException) {
            throw httpResponseException;
        }
        catch (Exception exception) {
            logger.warn((Object)("failure in remote action " + urlX2), (Object)exception);
            throw new RuntimeException("Exception while executing remote action " + urlX2, exception);
        }
        finally {
            if (postMethod != null) {
                try {
                    postMethod.releaseConnection();
                }
                catch (Exception exception) {
                    logger.error((Object)"swallowed exception while releasing http connection", (Object)exception);
                }
            }
        }
    }

    abstract class HttpResponseCallback {
        HttpResponseCallback() {
        }

        void prepareRequest(PostMethod postMethod) throws Exception {
        }

        Object processResponse(PostMethod postMethod) throws Exception {
            return null;
        }
    }
}

