/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.core.localcacheclient;

import com.ahsrcm.core.crypto.CryptoEngine;
import com.ahsrcm.core.crypto.DecryptedData;
import com.ahsrcm.core.crypto.EncryptedData;
import com.ahsrcm.core.localcacheclient.RemoteImageProvider;
import com.ahsrcm.corp.ScannedImage;
import com.ahsrcm.scanning.app.client.GetImageResult;
import com.ahsrcm.scanning.app.server.ServerAppConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import net.model3.newfile.File;

@Singleton
public class FileSystemImageProvider
implements RemoteImageProvider {
    private static final Logger logger = LoggerHelper.getLogger();
    private final ServerAppConfig _config;
    private final CryptoEngine _cryptoEngine;
    private final Directory _imageIncrementalDirectory;

    @Inject
    public FileSystemImageProvider(ServerAppConfig serverAppConfig, CryptoEngine cryptoEngine) {
        this._config = serverAppConfig;
        this._cryptoEngine = cryptoEngine;
        this._imageIncrementalDirectory = this._config.getImageIncrementalDirectory() != null ? new Directory(this._config.getImageIncrementalDirectory()) : null;
        logger.debug((Object)"using _imageIncrementalDirectory = {}", (Object)this._imageIncrementalDirectory);
    }

    @Override
    public boolean imageDataExists(String string, long l, long l2, int n) {
        File file = ScannedImage.getImageFile(null, l, l2, n);
        return file.exists();
    }

    @Override
    public GetImageResult getImageData(String string, long l, long l2, int n) {
        String string2;
        String string3;
        File file = ScannedImage.getImageFile(null, l, l2, n);
        logger.debug((Object)"getImageData -- imageFile = {}", (Object)file.getCanonicalPath());
        if (this.isFileEncrypted(file)) {
            string3 = file.getCanonicalPath();
            string2 = file.getCanonicalPath().substring(0, file.getCanonicalPath().length() - this._cryptoEngine.getCryptoHelper().getEncryptedFileExtension().length());
        } else {
            string2 = file.getCanonicalPath();
            string3 = file.getCanonicalPath() + this._cryptoEngine.getCryptoHelper().getEncryptedFileExtension();
        }
        File file2 = new File(string3);
        File file3 = new File(string2);
        if (file2.exists()) {
            return new GetImageResult(200, this.readDataWithEncryptionCheck(file2));
        }
        if (file3.exists()) {
            return new GetImageResult(200, this.readDataWithEncryptionCheck(file3));
        }
        return new GetImageResult(404, new byte[0]);
    }

    @Override
    public void uploadImageData(String string, long l, long l2, int n, byte[] byArray) {
        File file = ScannedImage.getImageFile(null, l, l2, n);
        File file2 = null;
        try {
            if (this._imageIncrementalDirectory != null) {
                file2 = ScannedImage.getImageFile(this._imageIncrementalDirectory, l, l2, n);
            }
        }
        catch (Exception exception) {
            logger.warn((Object)"failed to create incrementalImageFile", (Object)exception);
        }
        if (!file.exists()) {
            if (file2 != null) {
                logger.debug((Object)("saving incremental image to " + file2));
                this.writeDataWithEncryptionCheck(file2, byArray);
            }
            logger.debug((Object)("saving uploaded image to " + file));
            this.writeDataWithEncryptionCheck(file, byArray);
        }
    }

    private boolean isFileEncrypted(File file) {
        return file.getCanonicalPath().endsWith(this._cryptoEngine.getCryptoHelper().getEncryptedFileExtension());
    }

    private byte[] readDataWithEncryptionCheck(File file) {
        if (this.isFileEncrypted(file)) {
            DecryptedData decryptedData = this._cryptoEngine.decrypt(new EncryptedData(file.readBytes()));
            return decryptedData.getBytes();
        }
        return file.readBytes();
    }

    private void writeDataWithEncryptionCheck(File file, byte[] byArray) {
        if (this._config.getUseImageEncryption()) {
            EncryptedData encryptedData = this._cryptoEngine.encrypt(new DecryptedData(byArray));
            file.write(encryptedData.getBytes());
        } else {
            file.write(byArray);
        }
    }
}

