/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.core.fiscal;

import com.ahsrcm.core.fiscal.FiscalCalendar;
import com.ahsrcm.corp.O1PCAL;
import net.model3.chrono.DateOnly;
import net.model3.lang.AbstractComparable;

public class FiscalMonth {
    final O1PCAL _o1pcal;
    final FiscalCalendar _calendar;
    final int _indexInCalendar;

    public FiscalMonth(FiscalCalendar fiscalCalendar, O1PCAL o1PCAL, int n) {
        this._calendar = fiscalCalendar;
        this._o1pcal = o1PCAL;
        this._indexInCalendar = n;
    }

    public boolean isInPeriod(DateOnly dateOnly) {
        return this.compare(dateOnly) == 0;
    }

    public FiscalMonth subtract(int n) {
        return this._calendar.getFiscalMonths().get(this._indexInCalendar - n);
    }

    public DateOnly start() {
        return (DateOnly)this._o1pcal.startOfMonth.get();
    }

    public int getYear() {
        return (Integer)this._o1pcal.year.get();
    }

    public int getPeriod() {
        return (Integer)this._o1pcal.period.get();
    }

    public int asYearPeriod() {
        return this._o1pcal.asYearPeriod();
    }

    public DateOnly end() {
        return (DateOnly)this._o1pcal.endOfMonth.get();
    }

    public int compare(DateOnly dateOnly) {
        if (dateOnly.lessThan((AbstractComparable)this.start())) {
            return -1;
        }
        if (dateOnly.greaterThan((AbstractComparable)this.end())) {
            return 1;
        }
        return 0;
    }
}

