/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.core.fiscal;

import com.ahsrcm.core.fiscal.FiscalMonth;
import com.ahsrcm.corp.O1PCAL;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.util.List;
import net.model3.chrono.DateOnly;
import net.model3.chrono.Month;
import net.model3.collections.ListX;

@Singleton
public class FiscalCalendar {
    List<FiscalMonth> _fiscalMonths;

    public FiscalMonth getFiscalMonth(BigDecimal bigDecimal) {
        String string = bigDecimal.toString();
        int n = Integer.parseInt(string.substring(0, 4));
        int n2 = Integer.parseInt(string.substring(4, 6));
        int n3 = Integer.parseInt(string.substring(6));
        return this.getFiscalMonth(new DateOnly(n, Month.fromNumber((int)n2), n3));
    }

    public FiscalMonth getFiscalMonth(DateOnly dateOnly) {
        for (FiscalMonth fiscalMonth : this.getFiscalMonths()) {
            if (!fiscalMonth.isInPeriod(dateOnly)) continue;
            return fiscalMonth;
        }
        throw new RuntimeException("no fiscal month found for " + dateOnly);
    }

    public List<FiscalMonth> getFiscalMonths() {
        if (this._fiscalMonths == null) {
            List list = ListX.create();
            int n = 0;
            for (O1PCAL o1PCAL : O1PCAL.select("oadiv = 'CORP' ORDER BY oayy, oapd", new Object[0])) {
                list.add(new FiscalMonth(this, o1PCAL, n));
                ++n;
            }
            this._fiscalMonths = list;
        }
        return this._fiscalMonths;
    }
}

