/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.core.crypto;

import com.ahsrcm.core.crypto.AESCryptoConfig;
import com.ahsrcm.core.crypto.CryptoEngine;
import com.ahsrcm.core.crypto.CryptoHelper;
import com.ahsrcm.core.crypto.DecryptedData;
import com.ahsrcm.core.crypto.EncryptedData;
import com.google.inject.Inject;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import net.model3.lang.ExceptionPropagator;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class BouncyCastleCryptoEngine
implements CryptoEngine {
    private final AESCryptoConfig config;
    private final CipherParameters cipherParameters;
    private final CryptoHelper cryptoHelper = new CryptoHelper();

    @Inject
    public BouncyCastleCryptoEngine(AESCryptoConfig aESCryptoConfig) {
        this.config = aESCryptoConfig;
        SecretKeySpec secretKeySpec = this.generateKeySpec(aESCryptoConfig);
        this.cipherParameters = new ParametersWithIV((CipherParameters)new KeyParameter(secretKeySpec.getEncoded()), aESCryptoConfig.getIv());
    }

    @Override
    public EncryptedData encrypt(DecryptedData decryptedData) {
        return new EncryptedData(this.doCrypto(decryptedData.getBytes(), true));
    }

    @Override
    public DecryptedData decrypt(EncryptedData encryptedData) {
        return new DecryptedData(this.doCrypto(encryptedData.getBytes(), false));
    }

    @Override
    public CryptoHelper getCryptoHelper() {
        return this.cryptoHelper;
    }

    private byte[] doCrypto(byte[] byArray, boolean bl) {
        try {
            BufferedBlockCipher bufferedBlockCipher = this.getCipher(bl);
            byte[] byArray2 = new byte[bufferedBlockCipher.getOutputSize(byArray.length)];
            int n = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
            n += bufferedBlockCipher.doFinal(byArray2, n);
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray2, 0, byArray3, 0, n);
            return byArray3;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    private SecretKeySpec generateKeySpec(AESCryptoConfig aESCryptoConfig) {
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(aESCryptoConfig.getPassword().toCharArray(), aESCryptoConfig.getSalt(), aESCryptoConfig.getKeyIterations(), aESCryptoConfig.getKeySize());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(aESCryptoConfig.getKeyGenAlgorithm());
            byte[] byArray = secretKeyFactory.generateSecret(pBEKeySpec).getEncoded();
            return new SecretKeySpec(byArray, "AES");
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    private BufferedBlockCipher getCipher(boolean bl) {
        try {
            PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()), (BlockCipherPadding)new PKCS7Padding());
            paddedBufferedBlockCipher.init(bl, this.cipherParameters);
            return paddedBufferedBlockCipher;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }
}

