/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.core.crypto;

import com.ahsrcm.core.crypto.AESCryptoConfig;
import com.ahsrcm.core.crypto.CryptoEngine;
import com.ahsrcm.core.crypto.CryptoHelper;
import com.ahsrcm.core.crypto.DecryptedData;
import com.ahsrcm.core.crypto.EncryptedData;
import com.google.inject.Inject;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import net.model3.lang.ExceptionPropagator;

public class AESCryptoEngine
implements CryptoEngine {
    private final AESCryptoConfig config;
    private final String cipherName;
    private final SecretKeySpec keySpec;
    private final CryptoHelper cryptoHelper = new CryptoHelper();

    @Inject
    public AESCryptoEngine(AESCryptoConfig aESCryptoConfig) {
        this.config = aESCryptoConfig;
        this.cipherName = "AES/" + aESCryptoConfig.getCipherMode() + "/" + aESCryptoConfig.getPaddingMode();
        this.keySpec = this.generateKeySpec(aESCryptoConfig);
    }

    @Override
    public EncryptedData encrypt(DecryptedData decryptedData) {
        try {
            Cipher cipher = this.getCipher(1);
            byte[] byArray = cipher.doFinal(decryptedData.getBytes());
            return new EncryptedData(byArray);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    @Override
    public DecryptedData decrypt(EncryptedData encryptedData) {
        try {
            Cipher cipher = this.getCipher(2);
            byte[] byArray = cipher.doFinal(encryptedData.getBytes());
            return new DecryptedData(byArray);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    @Override
    public CryptoHelper getCryptoHelper() {
        return this.cryptoHelper;
    }

    private SecretKeySpec generateKeySpec(AESCryptoConfig aESCryptoConfig) {
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(aESCryptoConfig.getPassword().toCharArray(), aESCryptoConfig.getSalt(), aESCryptoConfig.getKeyIterations(), aESCryptoConfig.getKeySize());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(aESCryptoConfig.getKeyGenAlgorithm());
            byte[] byArray = secretKeyFactory.generateSecret(pBEKeySpec).getEncoded();
            return new SecretKeySpec(byArray, "AES");
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    private Cipher getCipher(int n) {
        try {
            Cipher cipher = Cipher.getInstance(this.cipherName);
            cipher.init(n, (Key)this.keySpec, new IvParameterSpec(this.config.getIv()));
            return cipher;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }
}

