
import java.awt.Font
import javax.swing.JLabel
import javax.swing.text.JTextComponent
import java.awt.Color
import java.awt.Cursor

import javax.swing.border.LineBorder
import java.awt.Dimension
import javax.swing.BorderFactory;
import javax.swing.JPanel
import javax.swing.JCheckBox
import javax.swing.SwingConstants
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import net.model3x.swing.datechooser.DayLabel
import net.model3x.swing.datechooser.DateChooserPanel

defaultLabel = new JLabel()
defaultFont = defaultLabel.getFont()



def font( style, size ) {
   def defaultFont = new JLabel().getFont()
   return new Font(defaultFont.name,style,size)
}

def color( i ) {
	if ( i instanceof Color ) {
		return i
	} else if ( i instanceof Integer ) {
		return new Color(i)
	}
}


def gray( darkness ) {
	int b = 255 - darkness
	return new Color(b,b,b)
}


def myanim( c ) {
	c = color(c)
	anim(c, over: "0.25s")
}

s ( JTextComponent, activate: "blue") {
	background = Color.blue
}

s( JLabel, "DateChooser-header" ) {
  background = color( 0x5C85FF )
  preferredSize = new Dimension(30,20)
  size = new Dimension(30,20)
  opaque = true
  horizontalAlignment = SwingConstants.RIGHT
}

s ( DateChooserPanel ) {
	opaque: false
}

s ( DayLabel ) {

	background = Color.white
  	opaque = true
  	minimumSize = new Dimension(25,20)
  	preferredSize = new Dimension(30,20)
  	horizontalAlignment = SwingConstants.RIGHT

	a( "today" ) { border = LineBorder.createBlackLineBorder() }

	a( 'Disabled'       ) { background = myanim( new Color(232,232,232) ) }
	a( "BookingOpen"    ) { background = myanim( 0x99FFB3 ) }
	a( "BookingPartial" ) { background = myanim( 0xE6FF99 ) }
	a( "BookingFull"    ) { background = myanim( 0xFFB399 ) }
	a( 'Selected'       ) { background = myanim( 0xCCDAFF ) }

	a( styleClass( 'MouseHover' ) | styleClass( 'DragHover' ) ) { background = myanim( 0xFFD8CC ) }

}

s ( "RichTab" ) {
     background = gray( 25 )
     Border paddingBorder = BorderFactory.createEmptyBorder(2,10,2,10)
     Border matteBorder = BorderFactory.createMatteBorder(1,1,1,1,gray(75))
     border = BorderFactory.createCompoundBorder(matteBorder,paddingBorder)
     
    a( "selected" ) { 
        background = Color.white
        matteBorder = BorderFactory.createMatteBorder(1,1,1,0,gray(50))
        border = BorderFactory.createCompoundBorder(matteBorder,paddingBorder)
    }
}

s ( "RichTabLabel" ) {
     font = font(0, 15)
}
