/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui.autoimport;

import com.ahsrcm.client.scanning.ImageSource;
import com.ahsrcm.client.scanning.ImportProcessor;
import com.ahsrcm.client.scanning.JTwainImageSource;
import com.ahsrcm.client.scanning.PatientFileImportProcessor;
import com.ahsrcm.client.scanning.PdfChooserImageSource;
import com.ahsrcm.client.scanning.ScannedImageSource;
import com.ahsrcm.client.scanning.ScannerManager;
import com.ahsrcm.client.scanning.TiffChooserImageSource;
import com.ahsrcm.client.scanning.gui.EntityComboBoxModel;
import com.ahsrcm.corp.BusinessEntity;
import com.ahsrcm.corp.PatientFile;
import com.ahsrcm.corp.User;
import com.ahsrcm.scanning.dao.ClientScanningDao;
import com.ahsrcm.scanning.dao.DaoBackgroundExecutor;
import com.ahsrcm.scanning.device.Feeder;
import com.ahsrcm.scanning.device.PaperSize;
import com.ahsrcm.util.UserContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.model3.bean.converters.Converter;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.StringX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3x.swing.HStringProvider;
import net.model3x.swing.M3Panel;
import net.model3x.swing.domviewer.ComponentTreeModelBuilder;

public class StragglerPanel {
    private static final Log logger = LogHelper.getLog();
    private static final long serialVersionUID = 3010442489231765353L;
    private User _user;
    private M3Panel _panel = new M3Panel("ins 20, wrap 2, fillx", "[][grow]");
    private final ScannerManager _jtwainManager = (ScannerManager)DependencyInjector.getInstance(ScannerManager.class);
    private EntityComboBoxModel<ImageSource> _scannerModel;
    private final EntityComboBoxModel<Feeder> _feederModel = new EntityComboBoxModel<Feeder>(Feeder.values());
    private final EntityComboBoxModel<PaperSize> _paperSizeModel = new EntityComboBoxModel<PaperSize>(PaperSize.values());
    private final ClientScanningDao _dao = (ClientScanningDao)DependencyInjector.getInstance(ClientScanningDao.class);
    private boolean _testing = false;
    private JButton _createButton;
    private JLabel _patientLabel;
    private JLabel _batchLabel;
    private JTextField _batchNumber;
    private JTextField _patientFileNumber;
    private JLabel _patientFileMsg;
    private JLabel _scannerMsg;
    private JComboBox _scannerCB;
    private JLabel _scannerLabel;
    private JComboBox _paperSizeCB;
    private JLabel _paperLabel;
    private JComboBox _feederCB;
    private JLabel _feederLabel;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        StragglerPanel stragglerPanel = new StragglerPanel(true);
        jFrame.add(stragglerPanel.getPanel());
        ComponentTreeModelBuilder.addFrameMenus();
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public StragglerPanel() {
        this.initComponents();
        this.initPartTwo();
    }

    private StragglerPanel(boolean bl) {
        this._testing = true;
        this.initComponents();
        this.initPartTwo();
    }

    public User getUser() {
        if (this._user == null) {
            this._user = ((UserContext)UserContext.Impl.get()).getUser();
        }
        return this._user;
    }

    public JPanel getPanel() {
        return this._panel;
    }

    private void initPartTwo() {
        this._scannerCB.setModel(this._scannerModel);
        this._feederCB.setModel(this._feederModel);
        this._paperSizeCB.setModel(this._paperSizeModel);
        this._paperSizeModel.setSelectedEntity(PaperSize.Letter);
        this._feederModel.setSelectedEntity(Feeder.Simplex);
        if (!this._testing) {
            for (BusinessEntity businessEntity : this.getUser().businessEntities) {
                logger.debug((Object)"biz entities {}={}", businessEntity.entityId.get(), businessEntity.value.get());
            }
        }
        this._createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StragglerPanel.this._createButtonActionPerformed(actionEvent);
            }
        });
        this.resetForm();
    }

    void resetErrorMessages() {
        JLabel[] jLabelArray;
        for (JLabel jLabel : jLabelArray = new JLabel[]{this._patientFileMsg, this._scannerMsg}) {
            jLabel.setText("");
            jLabel.setVisible(false);
            jLabel.setForeground(Color.RED);
        }
    }

    private void initComponents() {
        this._batchLabel = new JLabel();
        this._feederLabel = new JLabel();
        this._paperLabel = new JLabel();
        this._scannerLabel = new JLabel();
        this._createButton = new JButton();
        this._patientLabel = new JLabel();
        this._feederCB = new JComboBox();
        this._paperSizeCB = new JComboBox();
        this._batchNumber = new JTextField();
        this._patientFileNumber = new JTextField();
        this._patientFileMsg = new JLabel();
        this._scannerMsg = new JLabel();
        this._scannerCB = new JComboBox();
        List list = ListX.create();
        list.addAll(this._jtwainManager.getAllScanners());
        list.add(new TiffChooserImageSource());
        list.add(new PdfChooserImageSource());
        this._scannerModel = new EntityComboBoxModel(list);
        this._scannerModel.setConverter((Converter<ImageSource>)new HStringProvider.HStringAdapter<ImageSource>(null){

            public String valueToString(ImageSource imageSource) {
                if (imageSource instanceof TiffChooserImageSource) {
                    return "TIFF File Scanner";
                }
                if (imageSource instanceof PdfChooserImageSource) {
                    return "PDF File Scanner";
                }
                if (imageSource instanceof JTwainImageSource) {
                    return ((JTwainImageSource)imageSource).getName();
                }
                return imageSource.toString();
            }
        });
        this._panel.setBackground(Color.white);
        this._batchLabel.setText("Batch Number");
        this._createButton.setText("Import Straggler");
        this._patientLabel.setText("Patient File Number");
        this._patientFileNumber.setText("");
        this._patientFileMsg.setForeground(Color.red);
        this._patientFileMsg.setText("jLabel5");
        this._scannerLabel.setText("Scanner");
        this._feederLabel.setText("Document Feeder");
        this._paperLabel.setText("Paper Size");
        this._panel.add((Component)this._batchLabel, (Object)"right");
        this._panel.add((Component)this._batchNumber, (Object)"growx");
        this._panel.add((Component)this._patientLabel, (Object)"right");
        this._panel.add((Component)this._patientFileNumber, (Object)"growx");
        this._panel.add((Component)this._patientFileMsg, (Object)"span, center");
        this._panel.add((Component)this._scannerLabel, (Object)"right");
        this._panel.add((Component)this._scannerCB, (Object)"growx");
        this._panel.add((Component)this._feederLabel, (Object)"right");
        this._panel.add((Component)this._feederCB, (Object)"growx");
        this._panel.add((Component)this._paperLabel, (Object)"right");
        this._panel.add((Component)this._paperSizeCB, (Object)"growx");
        this._panel.add((Component)this._scannerMsg, (Object)"span, center");
        this._panel.add((Component)new JLabel(), (Object)"span");
        this._panel.add((Component)this._createButton, (Object)"span, center");
    }

    private void _createButtonActionPerformed(ActionEvent actionEvent) {
        PatientFile patientFile = this.validateForm();
        if (patientFile == null) {
            return;
        }
        this.performScan(false, patientFile);
        this.resetForm();
    }

    void performScan(final boolean bl, final PatientFile patientFile) {
        this._createButton.setEnabled(false);
        this._createButton.setText("Scan in process...");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ImageSource imageSource = (ImageSource)StragglerPanel.this._scannerModel.getSelectedEntity();
                    if (imageSource instanceof TiffChooserImageSource) {
                        ((TiffChooserImageSource)imageSource).setDuplex(Feeder.Duplex.equals(StragglerPanel.this._feederModel.getSelectedEntity()));
                    } else if (imageSource instanceof ScannedImageSource) {
                        ((ScannedImageSource)imageSource).setFeeder((Feeder)StragglerPanel.this._feederModel.getSelectedEntity());
                        ((ScannedImageSource)imageSource).setPaperSize((PaperSize)StragglerPanel.this._paperSizeModel.getSelectedEntity());
                        ((ScannedImageSource)imageSource).setShowOptionsDialog(bl);
                    }
                    ImportProcessor.ListenerAdapter listenerAdapter = new ImportProcessor.ListenerAdapter(){

                        @Override
                        public void error() {
                            JOptionPane.showConfirmDialog((Component)StragglerPanel.this._panel, "An error occurred while importing the image.");
                        }
                    };
                    PatientFileImportProcessor patientFileImportProcessor = new PatientFileImportProcessor(DependencyInjector.get(), patientFile, imageSource, listenerAdapter);
                    patientFileImportProcessor.process();
                }
                catch (Exception exception) {
                    try {
                        logger.error((Object)exception);
                        throw new RuntimeException(exception);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                StragglerPanel.this._createButton.setEnabled(true);
                                StragglerPanel.this._createButton.setText("Import Straggler");
                            }
                        });
                        throw throwable;
                    }
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        DaoBackgroundExecutor.executeInGuiBackground((Runnable)runnable);
    }

    public PatientFile validateForm() {
        Object object;
        this.resetErrorMessages();
        boolean bl = true;
        Long l = null;
        PatientFile patientFile = null;
        if (StringX.isBlank((String)this._patientFileNumber.getText())) {
            this._patientFileMsg.setText("Must enter a Patient File Number");
            this._patientFileMsg.setVisible(true);
            bl = false;
        }
        try {
            l = Long.valueOf(this._patientFileNumber.getText());
        }
        catch (Exception exception) {
            this._patientFileMsg.setText("Patient File is not a valid Number");
            this._patientFileMsg.setVisible(true);
            bl = false;
        }
        if (StringX.isBlank((String)this._batchNumber.getText())) {
            this._patientFileMsg.setText("Must enter a Patient File Number");
            this._patientFileMsg.setVisible(true);
            bl = false;
        }
        if (this._scannerModel.getSelectedEntity() == null) {
            this._scannerMsg.setText("Please select a scanner");
            this._scannerMsg.setVisible(true);
            bl = false;
        }
        if (bl) {
            object = this._dao.validateUserToObject(PatientFile.class, l);
            if (object == null) {
                this._patientFileMsg.setText("Invalid Patient File Number");
                this._patientFileMsg.setVisible(true);
                bl = false;
            } else if (!((Boolean)object).booleanValue()) {
                this._patientFileMsg.setText("User is not authorized to this Patient File");
                this._patientFileMsg.setVisible(true);
                bl = false;
            }
        }
        if (bl) {
            String string;
            patientFile = PatientFile.fetchByPk((Long)l);
            object = patientFile.getBatch().getId().toString();
            if (!((String)object).equals(string = this._batchNumber.getText())) {
                this._patientFileMsg.setText("Scan Batch and Patient File do not match");
                this._patientFileMsg.setVisible(true);
                bl = false;
            }
            if (!bl) {
                patientFile = null;
            }
        }
        return patientFile;
    }

    public void resetForm() {
        this.resetErrorMessages();
        this._batchNumber.setText("");
        this._patientFileNumber.setText("");
    }
}

