/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui.autoimport;

import com.ahsrcm.client.scanning.ImporterDirectories;
import com.ahsrcm.client.scanning.gui.EntityComboBoxModel;
import com.ahsrcm.client.scanning.gui.IndexOptionEnum;
import com.ahsrcm.corp.BatchType;
import com.ahsrcm.corp.BusinessEntity;
import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Division;
import com.ahsrcm.corp.Doctor;
import com.ahsrcm.corp.Location;
import com.ahsrcm.corp.User;
import com.ahsrcm.scanning.device.Feeder;
import com.ahsrcm.util.TiffFileFilter;
import com.ahsrcm.util.UserContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import net.model3.chrono.DateOnly;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.AbstractComparable;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import net.model3x.swing.M3Panel;
import net.model3x.swing.datechooser.TextFieldDateOnlyChooser;
import net.model3x.swing.domviewer.ComponentTreeModelBuilder;

public class ImportBatchPanel {
    static final Log logger = LogHelper.getLog();
    EntityComboBoxModel<Company> _companyModel = EntityComboBoxModel.create();
    EntityComboBoxModel<Division> _divisionModel = EntityComboBoxModel.create();
    EntityComboBoxModel<Location> _locationModel = EntityComboBoxModel.create();
    EntityComboBoxModel<Doctor> _doctorModel = EntityComboBoxModel.create();
    EntityComboBoxModel<BatchType> _batchTypeModel = EntityComboBoxModel.create();
    EntityComboBoxModel<User> _coderModel = EntityComboBoxModel.create();
    EntityComboBoxModel<Feeder> _feederModel = EntityComboBoxModel.create();
    User _user;
    java.io.File[] _selectedFiles;
    M3Panel _panel = new M3Panel("ins 20, wrap 2, fillx", "[][grow]");
    SimpleDateFormat _fileNameDateFormat = new SimpleDateFormat("yyMMdd");
    @Inject
    ImporterDirectories _importerDirectories;
    boolean _testOnly = false;
    private JComboBox _batchType;
    private JLabel _batchTypeMsg;
    private JButton _browseButton;
    private JComboBox _companyCB;
    private JButton _createButton;
    private TextFieldDateOnlyChooser _dateOfServiceDC;
    private JComboBox _divisionCB;
    private JComboBox _doctorCB;
    private JLabel _dosMsg;
    private JLabel _file;
    private JLabel _fileMsg;
    private JComboBox _locationOfServiceCB;
    private JLabel _locationOfServiceMsg;
    private JLabel _divisionLabel;
    private JLabel _losLabel;
    private JLabel _companyLabel;
    private JLabel _dateLabel;
    private JLabel _docLabel;
    private JLabel _batchTypeLabel;
    private JLabel _coderLabel;
    private JLabel _coderMsg;
    private JComboBox _coderCB;
    private JLabel _indexTypeLabel;
    private JComboBox _indexTypeCB;
    private JLabel _duplexTypeLabel;
    private JComboBox _duplexTypeCB;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        ImportBatchPanel importBatchPanel = new ImportBatchPanel();
        jFrame.add(importBatchPanel.getPanel());
        ComponentTreeModelBuilder.addFrameMenus();
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public ImportBatchPanel(List<User> list) {
        DependencyInjector.inject((Object)this);
        this.initComponents();
        this.initPartTwo(list);
        this.setEnabled(true);
    }

    private ImportBatchPanel() {
        this._testOnly = true;
        this.initComponents();
        this.initPartTwo(null);
        this.setEnabled(true);
    }

    public User getUser() {
        if (this._user == null) {
            this._user = ((UserContext)UserContext.Impl.get()).getUser();
        }
        return this._user;
    }

    public JPanel getPanel() {
        return this._panel;
    }

    private void initPartTwo(List<User> list) {
        this._doctorModel.setNullable(true);
        this._companyCB.setModel(this._companyModel);
        this._divisionCB.setModel(this._divisionModel);
        this._locationOfServiceCB.setModel(this._locationModel);
        this._doctorCB.setModel(this._doctorModel);
        this._coderCB.setModel(this._coderModel);
        this._coderModel.setItems(list);
        this._coderModel.setNullable(false);
        this._coderModel.setDefault(null);
        if (!this._testOnly) {
            for (BusinessEntity businessEntity : this.getUser().businessEntities) {
                logger.debug((Object)"biz entities {}={}", businessEntity.entityId.get(), businessEntity.value.get());
            }
            this._companyModel.setItems(this.getUser().allowedCompanies.get());
        }
        this._companyCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new SwingWorker<Void, Void>(){
                    List<Division> divisions = Collections.emptyList();

                    @Override
                    protected Void doInBackground() throws Exception {
                        try {
                            if (ImportBatchPanel.this._companyModel.getSelectedEntity() != null) {
                                this.divisions = ImportBatchPanel.this.getUser().getAuthorizedDivisions(ImportBatchPanel.this._companyModel.getSelectedEntity());
                            }
                        }
                        catch (Exception exception) {
                            logger.warn((Object)exception);
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        ImportBatchPanel.this._divisionModel.setItems(this.divisions);
                        ImportBatchPanel.this._divisionModel.reset();
                    }
                }.execute();
            }
        });
        this._divisionCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new SwingWorker<Void, Void>(){
                    List<Location> losList = Collections.emptyList();
                    List<Doctor> doctors = Collections.emptyList();

                    @Override
                    protected Void doInBackground() throws Exception {
                        try {
                            Division division = ImportBatchPanel.this._divisionModel.getSelectedEntity();
                            if (division != null) {
                                this.losList = ImportBatchPanel.this.getUser().getAuthorizedLocations(division);
                                this.doctors = division.getActiveDoctors();
                            }
                        }
                        catch (Exception exception) {
                            logger.warn((Object)exception);
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        ImportBatchPanel.this._locationModel.setItems(this.losList);
                        ImportBatchPanel.this._locationModel.reset();
                        ImportBatchPanel.this._doctorModel.setItems(this.doctors);
                        ImportBatchPanel.this._doctorModel.reset();
                    }
                }.execute();
            }
        });
        if (this._companyModel.getSize() > 0) {
            this._companyCB.setSelectedIndex(0);
        }
        this._batchType.setModel(this._batchTypeModel);
        if (!this._testOnly) {
            this._batchTypeModel.setItems(this.getUser().batchTypes.get());
        }
        this._indexTypeCB.setModel(new DefaultComboBoxModel<String>(IndexOptionEnum.getIdKeySet()));
        this._indexTypeCB.setSelectedIndex(1);
        this._indexTypeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (ImportBatchPanel.this._indexTypeCB.getSelectedIndex()) {
                    case 1: {
                        ImportBatchPanel.this._duplexTypeCB.setEnabled(true);
                        break;
                    }
                    default: {
                        ImportBatchPanel.this._duplexTypeCB.setSelectedIndex(-1);
                        ImportBatchPanel.this._duplexTypeCB.setEnabled(false);
                    }
                }
            }
        });
        this._feederModel.setItems(ListX.create((Object[])Feeder.values()));
        this._duplexTypeCB.setModel(this._feederModel);
        this._duplexTypeCB.setSelectedIndex(-1);
        this._duplexTypeCB.setEnabled(false);
        this._dosMsg.setVisible(false);
        this.resetForm();
    }

    void resetErrorMessages() {
        JLabel[] jLabelArray;
        for (JLabel jLabel : jLabelArray = new JLabel[]{this._dosMsg, this._locationOfServiceMsg, this._batchTypeMsg, this._fileMsg, this._coderMsg}) {
            jLabel.setText("");
            jLabel.setVisible(false);
            jLabel.setForeground(Color.RED);
        }
    }

    private void initComponents() {
        this._companyLabel = new JLabel();
        this._dateLabel = new JLabel();
        this._locationOfServiceCB = new JComboBox();
        this._createButton = new JButton();
        this._dateOfServiceDC = new TextFieldDateOnlyChooser();
        this._doctorCB = new JComboBox();
        this._coderCB = new JComboBox();
        this._divisionLabel = new JLabel();
        this._losLabel = new JLabel();
        this._divisionCB = new JComboBox();
        this._companyCB = new JComboBox();
        this._docLabel = new JLabel();
        this._dosMsg = new JLabel();
        this._coderMsg = new JLabel();
        this._coderLabel = new JLabel();
        this._batchTypeLabel = new JLabel();
        this._batchType = new JComboBox();
        this._batchTypeMsg = new JLabel();
        this._locationOfServiceMsg = new JLabel();
        this._browseButton = new JButton();
        this._file = new JLabel();
        this._fileMsg = new JLabel();
        this._indexTypeCB = new JComboBox();
        this._indexTypeLabel = new JLabel();
        this._duplexTypeCB = new JComboBox();
        this._duplexTypeLabel = new JLabel();
        this._panel.setBackground(Color.white);
        this._companyLabel.setText("Company");
        this._dateLabel.setText("Date of Service");
        this._createButton.setText("Import");
        this._divisionLabel.setText("Division");
        this._losLabel.setText("Location of Service");
        this._docLabel.setText("Doctor");
        this._dosMsg.setForeground(Color.red);
        this._batchTypeLabel.setText("Batch Type");
        this._batchTypeMsg.setForeground(Color.red);
        this._coderMsg.setForeground(Color.red);
        this._coderLabel.setText("Coder");
        this._browseButton.setText("Choose File");
        this._browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportBatchPanel.this._browseButtonActionPerformed(actionEvent);
            }
        });
        this._file.setText("Please choose a file....");
        this._fileMsg.setForeground(Color.red);
        this._fileMsg.setText("");
        this._indexTypeLabel.setText("Indexing");
        this._duplexTypeLabel.setText("Duplex Type");
        this._createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportBatchPanel.this._createButtonActionPerformed(actionEvent);
            }
        });
        this._panel.add((Component)this._companyLabel, (Object)"right");
        this._panel.add((Component)this._companyCB, (Object)"growx");
        this._panel.add((Component)this._divisionLabel, (Object)"right");
        this._panel.add((Component)this._divisionCB, (Object)"growx");
        this._panel.add((Component)this._losLabel, (Object)"right");
        this._panel.add((Component)this._locationOfServiceCB, (Object)"growx");
        this._panel.add((Component)this._locationOfServiceMsg, (Object)"span, center");
        this._panel.add((Component)this._dateLabel, (Object)"right");
        this._panel.add((Component)this._dateOfServiceDC, (Object)"growx");
        this._panel.add((Component)this._docLabel, (Object)"right");
        this._panel.add((Component)this._doctorCB, (Object)"growx");
        this._panel.add((Component)this._dosMsg, (Object)"span, center");
        this._panel.add((Component)this._batchTypeLabel, (Object)"right");
        this._panel.add((Component)this._batchType, (Object)"growx");
        this._panel.add((Component)this._batchTypeMsg, (Object)"span, center");
        this._panel.add((Component)this._coderLabel, (Object)"right");
        this._panel.add((Component)this._coderCB, (Object)"growx");
        this._panel.add((Component)this._coderMsg, (Object)"span, center");
        this._panel.add((Component)this._indexTypeLabel, (Object)"right");
        this._panel.add((Component)this._indexTypeCB, (Object)"growx");
        this._panel.add((Component)this._duplexTypeLabel, (Object)"right");
        this._panel.add((Component)this._duplexTypeCB, (Object)"growx");
        this._panel.add((Component)this._browseButton, (Object)"right");
        this._panel.add((Component)this._file, (Object)"growx");
        this._panel.add((Component)this._fileMsg, (Object)"span, center");
        this._panel.add((Component)this._createButton, (Object)"span, center");
    }

    private void _browseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setFileFilter((FileFilter)new TiffFileFilter());
        int n = jFileChooser.showOpenDialog((Component)this._panel);
        if (0 == n) {
            java.io.File[] fileArray = jFileChooser.getSelectedFiles();
            this._selectedFiles = fileArray;
            StringBuilder stringBuilder = new StringBuilder();
            for (java.io.File file : fileArray) {
                if (stringBuilder.length() > 50) {
                    stringBuilder.append(";...");
                    break;
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("; ");
                }
                stringBuilder.append(file.getName());
            }
            this._file.setText(stringBuilder.toString());
            this._file.repaint();
        }
    }

    private void _createButtonActionPerformed(ActionEvent actionEvent) {
        if (!this.validateForm()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(System.currentTimeMillis());
        stringBuilder.append("--");
        switch (this._indexTypeCB.getSelectedIndex()) {
            case 1: {
                stringBuilder.append("B_").append(this._feederModel.getSelectedEntity()).append("_");
                break;
            }
            case 2: {
                stringBuilder.append("1_NA_");
                break;
            }
            case 3: {
                stringBuilder.append("2_NA_");
                break;
            }
            case 4: {
                stringBuilder.append("3_NA_");
                break;
            }
            default: {
                stringBuilder.append("N_NA_");
            }
        }
        stringBuilder.append((String)this._companyModel.getSelectedEntity().id.get());
        stringBuilder.append("_");
        stringBuilder.append((String)this._divisionModel.getSelectedEntity().id.get());
        stringBuilder.append("_");
        stringBuilder.append((String)this._locationModel.getSelectedEntity().id.get());
        stringBuilder.append("_");
        stringBuilder.append(this._fileNameDateFormat.format(this._dateOfServiceDC.getValue().asDate()));
        stringBuilder.append("_");
        stringBuilder.append((String)this._batchTypeModel.getSelectedEntity().id.get());
        Doctor doctor = this._doctorModel.getSelectedEntity();
        if (doctor != null) {
            stringBuilder.append("_");
            stringBuilder.append((String)doctor.id.get());
        }
        Directory directory = this._importerDirectories.createBatchQueue.subDirectory((String)this._coderModel.getSelectedEntity().loginName.get());
        if (this._selectedFiles.length > 1) {
            directory = new Directory(directory, stringBuilder.toString());
            directory.makeDirectories();
        }
        int n = 0;
        for (java.io.File file : this._selectedFiles) {
            String string = null;
            string = this._selectedFiles.length > 1 ? n++ + "" : stringBuilder.toString();
            File file2 = new File(file);
            File file3 = new File(directory, string);
            file2.copyFileTo(file3);
        }
        this.resetForm();
    }

    public final void setEnabled(boolean bl) {
        this._panel.setEnabled(bl);
        this._companyCB.setEnabled(bl);
        this._divisionCB.setEnabled(bl);
        this._locationOfServiceCB.setEnabled(bl);
        this._dateOfServiceDC.setEnabled(bl);
        this._doctorCB.setEnabled(bl);
        this._createButton.setVisible(bl);
        this._divisionLabel.setEnabled(bl);
        this._losLabel.setEnabled(bl);
        this._companyLabel.setEnabled(bl);
        this._dateLabel.setEnabled(bl);
        this._file.setEnabled(bl);
        this._docLabel.setEnabled(bl);
        this._batchTypeLabel.setEnabled(bl);
        this._batchType.setEnabled(bl);
        this._createButton.setEnabled(bl);
        this._panel.invalidate();
        this._panel.repaint();
    }

    public boolean validateForm() {
        this.resetErrorMessages();
        boolean bl = true;
        DateOnly dateOnly = this._dateOfServiceDC.getValue();
        if (dateOnly == null) {
            this._dosMsg.setText("Date of service must be entered");
            this._dosMsg.setVisible(true);
            bl = false;
        } else if (dateOnly.greaterThan((AbstractComparable)new DateOnly())) {
            this._dosMsg.setText("Date of service cannot be in the future");
            this._dosMsg.setVisible(true);
            bl = false;
        }
        if (this._batchTypeModel.getSelectedEntity() == null) {
            this._batchTypeMsg.setText("Batch type must be entered");
            this._batchTypeMsg.setVisible(true);
            bl = false;
        }
        if (this._coderModel.getSelectedEntity() == null) {
            this._coderMsg.setText("Coder must be entered");
            this._coderMsg.setVisible(true);
            bl = false;
        }
        if (this._locationModel.getSelectedEntity() == null) {
            this._locationOfServiceMsg.setText("Company/Division/Location of Service must be entered");
            this._locationOfServiceMsg.setVisible(true);
            bl = false;
        }
        if (this._selectedFiles == null || this._selectedFiles.length == 0) {
            this._fileMsg.setText("File(s) must be selected");
            this._fileMsg.setVisible(true);
            bl = false;
        }
        if (bl && this._indexTypeCB.getSelectedIndex() < 0) {
            this._indexTypeCB.setSelectedIndex(0);
        }
        return bl;
    }

    public void resetForm() {
        this.resetErrorMessages();
        this._companyModel.reset();
        this._divisionModel.reset();
        this._locationModel.reset();
        this._dateOfServiceDC.setValue(null);
        this._doctorModel.reset();
        this._batchType.setSelectedItem(null);
        this._coderModel.setSelectedItem(null);
        this._file.setText("");
        this._selectedFiles = null;
    }
}

