/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import com.ahsrcm.client.scanning.gui.EntityComboBoxModel;
import com.ahsrcm.corp.PatientFile;
import com.ahsrcm.corp.User;
import com.ahsrcm.corp.rules.Rule;
import com.ahsrcm.corp.rules.RuleManager;
import com.ahsrcm.corp.rules.Stage;
import com.ahsrcm.corp.rules.UserRole;
import com.ahsrcm.util.UserContext;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import net.java.dev.properties.container.PropertyContextable;
import net.java.dev.properties.util.BeanComparator;
import net.model3.bean.converters.Converter;
import net.model3.bean.converters.ConverterAdapter;
import net.model3.collections.ListX;
import net.model3.collections.SetX;
import net.model3.util.StringJoiner;

public class UserStageChooserPanel
extends JPanel {
    private static final long serialVersionUID = 547804965330014055L;
    private final EntityComboBoxModel<Stage> _stageModel = new EntityComboBoxModel();
    private final EntityComboBoxModel<User> _userModel = new EntityComboBoxModel();
    private final PatientFile _visit;
    private Listener _listener = new Listener(){

        @Override
        public void cancelPressed() {
        }

        @Override
        public void okayPressed(Stage stage, User user) {
        }
    };
    private JButton _cancelButton;
    private JButton _okayButton;
    private JComboBox _stageCB;
    private JLabel _stageMsg;
    private JComboBox _userCB;
    private JLabel _userMsg;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;

    public UserStageChooserPanel(PatientFile patientFile, Stage stage) {
        this._visit = patientFile;
        this.initComponents();
        this.initPartDeux();
        this.setOpaque(true);
        this.setBackground(Color.white);
        this._stageModel.setSelectedEntity(stage);
    }

    public void setListener(Listener listener) {
        this._listener = listener;
    }

    private void initPartDeux() {
        Rule rule = this._visit.currentRule();
        this._stageMsg.setForeground(Color.RED);
        this._userMsg.setForeground(Color.RED);
        this._userModel.setConverter((Converter<User>)new ConverterAdapter<User>(){

            public String valueToString(User user) {
                return user.toString() + " - " + new StringJoiner((Iterable)user.roles, ", ", (Converter)new ConverterAdapter<UserRole>(){

                    public String valueToString(UserRole userRole) {
                        return (String)userRole.id.get();
                    }
                });
            }
        });
        List list = ListX.create((Iterable)rule.allowedToStages);
        if (!((UserContext)UserContext.Impl.get()).getUser().isManager()) {
            list.remove(Stage.Canceled.get());
        }
        if (!((UserContext)UserContext.Impl.get()).getUser().canDoDataEntry()) {
            list.remove(Stage.DataEntryComplete.get());
        }
        if (!list.contains(this._visit.stage.get())) {
            list.add((Stage)this._visit.stage.get());
        }
        this._stageModel.setItems(list);
        this._stageModel.setNullable(true);
        this._stageCB.setModel(this._stageModel);
        this._userCB.setModel(this._userModel);
        this._stageCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Stage stage = (Stage)UserStageChooserPanel.this._stageModel.getSelectedEntity();
                Set set = stage != null ? UserStageChooserPanel.this._visit.getRuleManager().getPossibleUsers(stage) : SetX.create();
                List list = ListX.create((Iterable)set);
                Collections.sort(list, BeanComparator.create((PropertyContextable[])new PropertyContextable[]{User.Meta.description}));
                UserStageChooserPanel.this._userModel.setItems(list);
                if (stage != null) {
                    User user = UserStageChooserPanel.this._visit.getRuleManager().getDefaultUser(stage);
                    UserStageChooserPanel.this._userModel.setSelectedEntity(user);
                }
                UserStageChooserPanel.this.updateErrorMessages();
            }
        });
        this._userCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserStageChooserPanel.this.updateErrorMessages();
            }
        });
        this._okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserStageChooserPanel.this.okayPressed();
            }
        });
        this._cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserStageChooserPanel.this._listener.cancelPressed();
            }
        });
        this.updateErrorMessages();
    }

    private void okayPressed() {
        if (!this._userMsg.isVisible() && !this._stageMsg.isVisible()) {
            this._listener.okayPressed(this._stageModel.getSelectedEntity(), this._userModel.getSelectedEntity());
        }
    }

    void updateErrorMessages() {
        User user = this._userModel.getSelectedEntity();
        Stage stage = this._stageModel.getSelectedEntity();
        this._userMsg.setVisible(false);
        this._stageMsg.setVisible(false);
        RuleManager ruleManager = this._visit.getRuleManager();
        Rule rule = ruleManager.getRule(stage);
        boolean bl = false;
        if (rule != null && ((Boolean)rule.userRequired.get()).booleanValue()) {
            bl = true;
        }
        if (stage != null && bl && user == null) {
            this._userMsg.setVisible(true);
            this._userMsg.setText("You must select the user to transfer to.");
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this._userCB = new JComboBox();
        this._stageCB = new JComboBox();
        this.jLabel2 = new JLabel();
        this._okayButton = new JButton();
        this._cancelButton = new JButton();
        this.jLabel3 = new JLabel();
        this._userMsg = new JLabel();
        this._stageMsg = new JLabel();
        this.jLabel1.setText("User");
        this._userCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this._stageCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel2.setText("Stage");
        this._okayButton.setText("Okay");
        this._cancelButton.setText("Cancel");
        this.jLabel3.setText("Choose the stage then user.");
        this._userMsg.setText("jLabel4");
        this._stageMsg.setText("jLabel4");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addComponent(this._okayButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._cancelButton)).addComponent(this._stageCB, 0, -1, Short.MAX_VALUE).addComponent(this._userCB, -2, 270, -2))).addComponent(this.jLabel3))).addGroup(groupLayout.createSequentialGroup().addGap(44, 44, 44).addComponent(this._userMsg)).addGroup(groupLayout.createSequentialGroup().addGap(44, 44, 44).addComponent(this._stageMsg))).addContainerGap(56, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addGap(17, 17, 17).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this._stageCB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._stageMsg).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this._userCB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._userMsg).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._okayButton).addComponent(this._cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    Stage getStage() {
        return this._stageModel.getSelectedEntity();
    }

    void setStage(Stage stage) {
        this._stageModel.setSelectedEntity(stage);
    }

    void setUser(User user) {
        this._userModel.setSelectedEntity(user);
    }

    User getUser() {
        return this._userModel.getSelectedEntity();
    }

    public static interface Listener {
        public void okayPressed(Stage var1, User var2);

        public void cancelPressed();
    }
}

