/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import com.ahsrcm.client.scanning.gui.Thumbnail;
import com.ahsrcm.core.scanning.gui.ImageProxy;
import com.ahsrcm.core.scanning.gui.ImageProxyPopupFactory;
import com.ahsrcm.corp.ScannedImage;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.model3.collections.ListX;
import net.model3.imaging.Size;
import net.model3.lang.StringX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.swing.FixedGridLayout;
import net.model3x.swing.M3Layout;

public class ThumbnailStrip<T>
extends JPanel
implements Scrollable {
    private static final Log logger = LogHelper.getLog();
    private static final long serialVersionUID = 1L;
    Size _thumbnailSize = new Size(200, 200);
    Thumbnail<T> _currentThumbnail;
    private List<Thumbnail<T>> _thumbnails = new ArrayList<Thumbnail<T>>();
    private Set<Thumbnail<T>> _selectedThumbnails = new HashSet<Thumbnail<T>>();
    private Thumbnail<T> _lastSelectedThumbnail;
    private ActionListener _selectionListener;
    private JScrollPane _scrollPane;
    private ImageProxyPopupFactory _popupFactory;
    private int _viewportWidth;
    private ResetGroupsListener _resetGroupsListener = new ResetGroupsListener(){

        @Override
        public void reset() {
        }
    };
    private LinkedHashMap<String, Group> _groups;
    private List<Group> _sortedGroups;
    private GroupingStrategy<T> _groupingStrategy;
    private CaptionProvider<T> _captionProvider;

    public ThumbnailStrip() {
        if (Boolean.valueOf(false).booleanValue()) {
            this._lastSelectedThumbnail.toString();
        }
        this._groups = new LinkedHashMap();
        this._groupingStrategy = new GroupingStrategy<T>(){

            @Override
            public String getGroupingField(Thumbnail<T> thumbnail) {
                return "";
            }
        };
        this._captionProvider = new CaptionProvider<T>(){

            @Override
            public String getCaption(Thumbnail<T> thumbnail) {
                return thumbnail.getImage().getCaption();
            }
        };
        this.setLayout((LayoutManager)new M3Layout());
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
    }

    public ThumbnailStrip(JScrollPane jScrollPane) {
        this();
        this._scrollPane = jScrollPane;
    }

    public void setSelectionListener(ActionListener actionListener) {
        this._selectionListener = actionListener;
    }

    public void setThumbnailSize(Size size) {
        this._thumbnailSize = size;
    }

    public Set<Thumbnail<T>> getSelectedThumbnails() {
        return this._selectedThumbnails;
    }

    public void addThumbnail(ImageProxy imageProxy, T t) {
        final Thumbnail<T> thumbnail = new Thumbnail<T>(imageProxy, this, this._thumbnailSize);
        thumbnail.addSelectListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Object object;
                if (mouseEvent.getButton() == 3 && ThumbnailStrip.this._popupFactory != null) {
                    if (!ThumbnailStrip.this._selectedThumbnails.contains(thumbnail)) {
                        for (Thumbnail thumbnail2 : ThumbnailStrip.this._selectedThumbnails) {
                            thumbnail2.setUnselectedBorder();
                        }
                        ThumbnailStrip.this._selectedThumbnails.clear();
                        ThumbnailStrip.this._selectedThumbnails.add(thumbnail);
                        thumbnail.setSelectedBorder();
                    }
                    object = ThumbnailStrip.this._popupFactory.createPopup(thumbnail.getImage());
                    ((JPopupMenu)object).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1) {
                    boolean bl;
                    object = new HashSet();
                    boolean bl2 = (mouseEvent.getModifiersEx() & 0x80) == 128;
                    boolean bl3 = (mouseEvent.getModifiersEx() & 0x40) == 64;
                    boolean bl4 = bl = (mouseEvent.getModifiersEx() & 0x200) == 512;
                    if (bl2 && !bl) {
                        object.addAll(ThumbnailStrip.this._selectedThumbnails);
                    }
                    if (bl3 && ThumbnailStrip.this._currentThumbnail != null) {
                        ThumbnailStrip.this.doShiftSelect(ThumbnailStrip.this._currentThumbnail, thumbnail, object);
                    } else if (object.contains(thumbnail)) {
                        object.remove(thumbnail);
                    } else {
                        object.add(thumbnail);
                    }
                    for (Thumbnail thumbnail32 : ThumbnailStrip.this._selectedThumbnails) {
                        thumbnail32.setUnselectedBorder();
                    }
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Thumbnail thumbnail32;
                        thumbnail32 = (Thumbnail)iterator.next();
                        thumbnail32.setSelectedBorder();
                    }
                    ThumbnailStrip.this._selectedThumbnails = (Set)object;
                    if (ThumbnailStrip.this._selectionListener != null) {
                        ThumbnailStrip.this._selectionListener.actionPerformed(null);
                    }
                    ThumbnailStrip.this._currentThumbnail = thumbnail;
                }
            }
        });
        thumbnail.setReference(t);
        this._thumbnails.add(thumbnail);
        this.getGroup(thumbnail).add(thumbnail);
        this.doLayoutHack();
    }

    protected void doShiftSelect(Thumbnail<T> thumbnail, Thumbnail<T> thumbnail2, Set<Thumbnail<T>> set) {
        List<Thumbnail<T>> list = this.flattenGroups();
        int n = list.indexOf(thumbnail);
        int n2 = list.indexOf(thumbnail2);
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        for (int i = n3; i <= n4; ++i) {
            set.add(list.get(i));
        }
    }

    private void doLayoutHack() {
        this.invalidate();
        this.validate();
        this.repaint();
        if (this._scrollPane != null) {
            this._scrollPane.invalidate();
            this._scrollPane.validate();
            this._scrollPane.repaint();
        }
    }

    public List<ImageProxy> getImageCollection() {
        ArrayList<ImageProxy> arrayList = new ArrayList<ImageProxy>();
        for (Group group : this._sortedGroups) {
            for (Thumbnail thumbnail : group._thumbnails) {
                arrayList.add(thumbnail.getImage());
            }
        }
        return arrayList;
    }

    public int getScanCount() {
        return this._thumbnails.size();
    }

    public void setScrollPane(JScrollPane jScrollPane) {
        this._scrollPane = jScrollPane;
        this._scrollPane.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = ThumbnailStrip.this._scrollPane.getViewport().getWidth();
                if (ThumbnailStrip.this._viewportWidth != n) {
                    ThumbnailStrip.this._viewportWidth = n;
                    for (Group group : ThumbnailStrip.this._groups.values()) {
                        if (group._layout.getMaximumWidth() == ThumbnailStrip.this._viewportWidth) continue;
                        group._layout.setMaximumWidth(ThumbnailStrip.this._viewportWidth);
                    }
                    ThumbnailStrip.this.doLayoutHack();
                }
            }
        });
    }

    public void setPopupFactory(ImageProxyPopupFactory imageProxyPopupFactory) {
        this._popupFactory = imageProxyPopupFactory;
    }

    public void removeThumbnail(T t) {
        Thumbnail<T> thumbnail = null;
        for (Thumbnail<T> thumbnail2 : this._thumbnails) {
            if (!thumbnail2.getReference().equals(t)) continue;
            thumbnail = thumbnail2;
            break;
        }
        if (thumbnail != null) {
            this._thumbnails.remove(thumbnail);
            this.remove(thumbnail);
            this.resetCaptions();
        }
    }

    public void resetCaptions() {
        for (Thumbnail<T> thumbnail : this._thumbnails) {
            thumbnail.setCaption(this._captionProvider.getCaption(thumbnail));
        }
    }

    public Thumbnail<T> getThumbnailByImageProxy(ImageProxy imageProxy) {
        for (Thumbnail<T> thumbnail : this._thumbnails) {
            if (thumbnail.getImage() != imageProxy) continue;
            return thumbnail;
        }
        return null;
    }

    public Thumbnail<T> getThumbnailByReference(T t) {
        for (Thumbnail<T> thumbnail : this._thumbnails) {
            if (!thumbnail.getReference().equals(t)) continue;
            return thumbnail;
        }
        return null;
    }

    public GroupingStrategy<T> getGroupingStrategy() {
        return this._groupingStrategy;
    }

    public void setGroupingStrategy(GroupingStrategy<T> groupingStrategy) {
        this._groupingStrategy = groupingStrategy;
        this.resetGroups();
    }

    public void resetGroups() {
        Thumbnail<T> thumbnail2;
        this._resetGroupsListener.reset();
        this._groups.clear();
        this.removeAll();
        for (Thumbnail<T> thumbnail2 : this._thumbnails) {
            if (!thumbnail2.getImage().visible()) continue;
            thumbnail2.setCaption(this._captionProvider.getCaption(thumbnail2));
            this.getGroup(thumbnail2).add(thumbnail2);
        }
        ArrayList<Group> arrayList = new ArrayList<Group>(this._groups.values());
        Collections.sort(arrayList, new Comparator<Group>(){

            @Override
            public int compare(Group group, Group group2) {
                return group._groupingField.compareTo(group2._groupingField);
            }
        });
        thumbnail2 = arrayList.iterator();
        while (thumbnail2.hasNext()) {
            Group group = (Group)thumbnail2.next();
            group.sort();
            if (StringX.isNotBlank((String)group._groupingField)) {
                JComponent jComponent = DefaultComponentFactory.getInstance().createSeparator(this._groupingStrategy + " " + group._groupingField);
                this.add((Component)jComponent, "wrap");
            }
            this.add((Component)group.createPanel(), "wrap");
        }
        this._sortedGroups = arrayList;
        this.resetCaptions();
        this.doLayoutHack();
    }

    public void setResetGroupsListener(ResetGroupsListener resetGroupsListener) {
        this._resetGroupsListener = resetGroupsListener;
    }

    private Group getGroup(Thumbnail<T> thumbnail) {
        String string = this._groupingStrategy.getGroupingField(thumbnail);
        Group group = this._groups.get(string);
        if (group == null) {
            group = new Group();
            group._groupingField = string;
            this._groups.put(string, group);
        }
        return group;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 15;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 15;
    }

    public List<Thumbnail<T>> flattenGroups() {
        List list = ListX.create();
        for (Group group : this._sortedGroups) {
            list.addAll(group._thumbnails);
        }
        return list;
    }

    public void setCaptionProvider(CaptionProvider<T> captionProvider) {
        this._captionProvider = captionProvider;
        this.resetCaptions();
    }

    static {
        logger.toString();
    }

    public static interface CaptionProvider<T> {
        public String getCaption(Thumbnail<T> var1);
    }

    public static interface ResetGroupsListener {
        public void reset();
    }

    public static abstract class GroupingStrategy<U> {
        public abstract String getGroupingField(Thumbnail<U> var1);

        public boolean showOnCaption() {
            return true;
        }
    }

    class Group {
        private List<Thumbnail<T>> _thumbnails = new ArrayList();
        private String _groupingField;
        private FixedGridLayout _layout = new FixedGridLayout();

        Group() {
        }

        JPanel createPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.white);
            this._layout.setMaximumWidth(ThumbnailStrip.this._viewportWidth);
            jPanel.setLayout((LayoutManager)this._layout);
            for (Thumbnail thumbnail : this._thumbnails) {
                jPanel.add(thumbnail);
            }
            return jPanel;
        }

        void add(Thumbnail<T> thumbnail) {
            this._thumbnails.add(thumbnail);
        }

        void sort() {
            Collections.sort(this._thumbnails, new Comparator<Thumbnail<T>>(){

                @Override
                public int compare(Thumbnail<T> thumbnail, Thumbnail<T> thumbnail2) {
                    Integer n = (Integer)((ScannedImage)thumbnail.getReference()).pageNumber.get();
                    Integer n2 = (Integer)((ScannedImage)thumbnail2.getReference()).pageNumber.get();
                    return n.compareTo(n2);
                }
            });
        }
    }
}

