/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import com.ahsrcm.client.scanning.gui.ImageViewer;
import com.ahsrcm.client.scanning.gui.ScanDetailPopupFactory;
import com.ahsrcm.client.scanning.gui.ThumbnailStrip;
import com.ahsrcm.core.scanning.gui.ImageProxy;
import com.ahsrcm.core.scanning.gui.ScannedImageProxy;
import com.ahsrcm.corp.ScannedImage;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import net.model3.imaging.Size;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.swing.CurvedBorder;

public class Thumbnail<T>
extends JPanel {
    private static final Log logger = LogHelper.getLog();
    private static final long serialVersionUID = 0L;
    private JLabel _imageLabel = new JLabel();
    private JLabel _textLabel = new JLabel();
    private boolean _selected = false;
    private ImageProxy _imageProxy;
    private Size _imageSize;
    private BufferedImage _image = null;
    private ThumbnailStrip<T> _thumbnailStrip;
    private T _reference;
    private ScannedImageProxy.ProxyListener _proxyListener;

    public Thumbnail(ImageProxy imageProxy, ThumbnailStrip<T> thumbnailStrip, Size size) {
        this._imageProxy = imageProxy;
        this._imageSize = size;
        this._thumbnailStrip = thumbnailStrip;
        this._imageLabel.setBackground(Color.BLUE);
        this._imageLabel.setBorder(new LineBorder(Color.GRAY, 1));
        this.setBackground(Color.white);
        this.setOpaque(true);
        this._imageLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && Thumbnail.this.getReference() instanceof ScannedImage) {
                    ImageViewer.showImage(Thumbnail.this._imageProxy, Thumbnail.this._thumbnailStrip.getImageCollection(), ScanDetailPopupFactory.createImageViewerPopup((ScannedImage)Thumbnail.this.getReference(), Thumbnail.this._thumbnailStrip));
                }
            }
        });
        if (this._imageProxy instanceof ScannedImageProxy) {
            ScannedImageProxy scannedImageProxy = (ScannedImageProxy)this._imageProxy;
            this._proxyListener = new ScannedImageProxy.ProxyListener(){

                public void imageHasChanged() {
                    Thumbnail.this.resetImage();
                }
            };
            scannedImageProxy.addListener(this._proxyListener);
        }
        this.setLayout(new BoxLayout(this, 1));
        this._imageLabel.setAlignmentX(0.5f);
        this._textLabel.setAlignmentX(0.5f);
        this.setUnselectedBorder();
        this.add(this._imageLabel);
        this.add(this._textLabel);
        this._textLabel.setBorder(new EmptyBorder(2, 0, 2, 0));
        this._textLabel.setHorizontalTextPosition(0);
        this.setCaption(imageProxy.getCaption());
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this._image == null) {
            this.resetImage();
        }
        super.paintComponent(graphics);
    }

    public void resetImage() {
        final BufferedImage bufferedImage = this._imageProxy.getImage(this._imageSize);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Thumbnail.this.setImage(bufferedImage);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setSelectedBorder() {
        int n = 2;
        this.setBorder(new CompoundBorder((Border)new CurvedBorder(Color.GRAY, n, 10), new EmptyBorder(5 - n, 15 - n, 5 - n, 15 - n)));
    }

    public void setUnselectedBorder() {
        this.setBorder(new EmptyBorder(5, 15, 5, 15));
    }

    public ThumbnailStrip<T> getThumbnailStrip() {
        return this._thumbnailStrip;
    }

    private void setImage(BufferedImage bufferedImage) {
        this._image = bufferedImage;
        this._imageLabel.setIcon(new ImageIcon(bufferedImage));
    }

    public void setImageProxy(ImageProxy imageProxy) {
        if (this._proxyListener != null) {
            ((ScannedImageProxy)this._imageProxy).removeListener(this._proxyListener);
            this._proxyListener = null;
        }
        this._imageProxy = imageProxy;
        this.resetImage();
        if (this._imageProxy instanceof ScannedImageProxy) {
            ScannedImageProxy scannedImageProxy = (ScannedImageProxy)this._imageProxy;
            this._proxyListener = new ScannedImageProxy.ProxyListener(){

                public void imageHasChanged() {
                    Thumbnail.this.resetImage();
                }
            };
            scannedImageProxy.addListener(this._proxyListener);
        }
    }

    public void addSelectListener(MouseListener mouseListener) {
        this._imageLabel.addMouseListener(mouseListener);
        this._textLabel.addMouseListener(mouseListener);
        this.addMouseListener(mouseListener);
    }

    public T getReference() {
        return this._reference;
    }

    public void setReference(T t) {
        this._reference = t;
    }

    public ImageProxy getImage() {
        return this._imageProxy;
    }

    public void setCaption(String string) {
        this._textLabel.setText(string);
        logger.trace((Object)"text={}", (Object)string);
    }

    public boolean isSelected() {
        return this._selected;
    }

    static {
        logger.toString();
    }
}

