/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import com.ahsrcm.client.scanning.gui.ResettableForm;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.model3x.swing.M3Panel;
import net.model3x.swing.domviewer.ComponentTreeModelBuilder;

public class TextFieldWithPopup
extends JTextField
implements ResettableForm {
    private static final long serialVersionUID = 1L;
    private static ImageIcon _downArrow;
    private static ImageIcon _downArrowHover;
    ImageIcon _icon = _downArrow;
    int _iconInsetX = -2;
    private PopperUpper _popperUpper = new PopperUpper(){

        @Override
        public void showPopup(TextFieldWithPopup textFieldWithPopup) {
        }
    };

    public static void main(String[] stringArray) throws Exception {
        System.setProperty("app.name", "TextFieldWithPopup");
        UIManager.setLookAndFeel(new MetalLookAndFeel());
        JFrame jFrame = new JFrame();
        M3Panel m3Panel = new M3Panel();
        m3Panel.add((Component)new TextFieldWithPopup(20), (Object)"wrap");
        m3Panel.add((Component)new TextFieldWithPopup(20), (Object)"wrap");
        m3Panel.add((Component)new TextFieldWithPopup(20), (Object)"wrap");
        jFrame.add((Component)m3Panel);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
        ComponentTreeModelBuilder.registerHotkey();
        ComponentTreeModelBuilder.addFrameMenus();
    }

    public TextFieldWithPopup(int n) {
        this();
        this.setColumns(n);
    }

    public TextFieldWithPopup() {
        this.setBackground(Color.white);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                TextFieldWithPopup.this.updateIcon(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                TextFieldWithPopup.this.changeIcon(_downArrow);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (TextFieldWithPopup.this.overIcon(mouseEvent)) {
                    TextFieldWithPopup.this.showPopup();
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TextFieldWithPopup.this.showPopup();
                }
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                TextFieldWithPopup.this.updateIcon(mouseEvent);
            }
        });
    }

    boolean overIcon(MouseEvent mouseEvent) {
        return mouseEvent.getX() >= this.iconRegionStartX();
    }

    void updateIcon(MouseEvent mouseEvent) {
        if (this.overIcon(mouseEvent)) {
            this.setCursor(Cursor.getDefaultCursor());
            this.changeIcon(_downArrowHover);
        } else {
            this.setCursor(Cursor.getPredefinedCursor(2));
            this.changeIcon(_downArrow);
        }
    }

    void changeIcon(ImageIcon imageIcon) {
        if (imageIcon != this._icon) {
            this._icon = imageIcon;
            this.repaint();
        }
    }

    public JTextField getTextField() {
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = this.getHeight() / 2 - this._icon.getIconHeight() / 2;
        graphics.drawImage(this._icon.getImage(), this.iconX(), n, null);
    }

    int iconX() {
        return this.getWidth() - _downArrow.getIconWidth() - this._iconInsetX;
    }

    int iconRegionStartX() {
        return this.iconX() - this._iconInsetX;
    }

    void showPopup() {
        this._popperUpper.showPopup(this);
    }

    Dimension addDimensions(Dimension dimension, Dimension dimension2) {
        Dimension dimension3 = new Dimension();
        dimension3.width = dimension.width + dimension2.width + 2;
        dimension3.height = Math.max(dimension.height, dimension2.height);
        return dimension3;
    }

    @Override
    public void resetForm() {
        this.setText("");
    }

    @Override
    public String getText() {
        return super.getText().toUpperCase();
    }

    public void setPopperUpper(PopperUpper popperUpper) {
        this._popperUpper = popperUpper;
    }

    static {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("dd-arrow.png");
        _downArrow = new ImageIcon(uRL);
        uRL = Thread.currentThread().getContextClassLoader().getResource("dd-arrow-hover.png");
        _downArrowHover = new ImageIcon(uRL);
    }

    public static interface PopperUpper {
        public void showPopup(TextFieldWithPopup var1);
    }
}

